/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.model;

import javax.swing.Icon;
import org.eclipse.persistence.tools.utility.model.Model;

/**
 * Used by general-purpose UI models and renderers to cast
 * application model objects to something displayable.
 */
@SuppressWarnings("nls")
public interface Displayable
	extends Model
{
	/**
	 * Return a string that can be used to identify the model
	 * in a textual UI setting (typically the object's name).
	 * When the display string changes, the model should fire
	 * the appropriate change notification:<pre>
	 *     this.firePropertyChanged(DISPLAY_STRING_PROPERTY, oldDisplayString, this.displayString);
	 * </pre>
	 */
	String displayString();
		String DISPLAY_STRING_PROPERTY = "displayString";

	/**
	 * Return an icon that can be used to identify the model
	 * in a UI component that supports icons (the icon can be null).
	 * When the icon changes, the model should fire
	 * the appropriate change notification:<pre>
	 *     this.firePropertyChanged(ICON_PROPERTY, oldIcon, this.icon);
	 * </pre>
	 */
	Icon icon();
		String ICON_PROPERTY = "icon";
}