/*******************************************************************************
 * Copyright (c) 2010, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.iterable;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterable.SuperIterableWrapper;

@SuppressWarnings("nls")
public class SuperIterableWrapperTests extends TestCase {

	public SuperIterableWrapperTests(String name) {
		super(name);
	}

	public void testIterator() {
		ArrayList<String> list = new ArrayList<String>();
		list.add("foo");
		list.add("bar");
		list.add("baz");
		String concat = "";
		for (String s : list) {
			concat += s;
		}
		assertEquals("foobarbaz", concat);

		Iterable<Object> iterable = new SuperIterableWrapper<Object>(list);
		concat = "";
		for (Object s : iterable) {
			concat += s;
		}
		assertEquals("foobarbaz", concat);
	}

	public void testToString() {
		Iterable<Object> iterable = new SuperIterableWrapper<Object>(Collections.emptyList());
		assertNotNull(iterable.toString());
	}
}