/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ByteArrayTools;


@SuppressWarnings("nls")
public class ByteArrayToolsTests
	extends TestCase
{
	public ByteArrayToolsTests(String name) {
		super(name);
	}

	// ********** convert to hex string **********

	public void testConvertToHexString() throws Exception {
		String s = "test";
		assertEquals("74657374", ByteArrayTools.convertToHexString(s.getBytes())); // UTF-8 values
	}

	public void testConvertToHexString_negative() throws Exception {
		String s = "caf\u00E9"; // cafe'
		assertEquals(this.getHexCafe(), ByteArrayTools.convertToHexString(s.getBytes()));
	}

	public void testConvertToHexCharArray() throws Exception {
		String s = "test";
		TestTools.assertEquals("74657374", ByteArrayTools.convertToHexCharArray(s.getBytes()));
	}

	public void testConvertToHexCharArray_negative() throws Exception {
		String s = "caf\u00E9"; // cafe'
		TestTools.assertEquals(this.getHexCafe(), ByteArrayTools.convertToHexCharArray(s.getBytes()));
	}

	private String getHexCafe() {
		return StringToolsTests.getHexCafe();
	}
}