/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.OptimisticLockingType;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalOptimisticLocking;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperClassEntity;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class OptimisticLocking
extends AbstractExternalForm
implements ExternalOptimisticLocking {
    static final String CASCADE = "cascade";
    static final String OPTIMISTIC_LOCKING = "optimistic-locking";
    static final String SELECTED_COLUMN = "selected-column";
    static final String TYPE = "type";

    OptimisticLocking(MappedSuperClassEntity parent) {
        super(parent);
    }

    @Override
    public void addColumn(int index, String columnName) {
        EntityColumn column = this.buildColumn(index);
        column.addSelf();
        column.setName(columnName);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(TYPE);
        names.add(CASCADE);
        return names;
    }

    private EntityColumn buildColumn(int index) {
        return new EntityColumn(this, SELECTED_COLUMN, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(SELECTED_COLUMN);
        return names;
    }

    @Override
    public ListIterable<ExternalEntityColumn> columns() {
        int count = this.columnsSize();
        ArrayList<EntityColumn> columns = new ArrayList<EntityColumn>(count);
        int index = count;
        while (--index >= 0) {
            EntityColumn column = this.buildColumn(index);
            columns.add(0, column);
        }
        return new ListListIterable(columns);
    }

    @Override
    public int columnsSize() {
        return this.getChildrenSize(SELECTED_COLUMN);
    }

    @Override
    public ExternalEntityColumn getColumn(int index) {
        Element element = this.getChild(SELECTED_COLUMN, index);
        if (element == null) {
            return null;
        }
        return this.buildColumn(index);
    }

    @Override
    protected String getElementName() {
        return OPTIMISTIC_LOCKING;
    }

    @Override
    public OptimisticLockingType getOptimisticLockingType() {
        return this.getEnumAttribute(TYPE, OptimisticLockingType.class);
    }

    @Override
    public void removeAllColumns() {
        this.removeChildren(SELECTED_COLUMN);
    }

    @Override
    public void removeColumn(int index) {
        EntityColumn column = this.buildColumn(index);
        column.removeSelf();
    }

    @Override
    public void setOptimisticLockingType(OptimisticLockingType type) {
        this.setAttribute(TYPE, (Enum<?>)type);
        if (type == null) {
            this.removeSelf();
        }
    }

    @Override
    public void setShouldCascade(Boolean value) {
        this.setAttribute(CASCADE, value);
    }

    @Override
    public Boolean shouldCascade() {
        return this.getBooleanAttribute(CASCADE);
    }
}

