/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.InheritanceType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntitySecondaryTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalSQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.AssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.AttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.DiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityListener;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperClassEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryTable;
import org.eclipse.persistence.tools.mapping.orm.dom.SQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.SecondaryTable;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class Entity
extends MappedSuperClassEntity
implements ExternalEntity {
    static final String CLASS_EXTRACTOR = "class-extractor";
    static final String DISCRIMINATOR_VALUE = "discriminator-value";
    static final String ENTITY = "entity";
    static final String INHERITANCE = "inheritance";
    static final String NAME = "name";
    static final String STRATEGY = "strategy";

    Entity(ORMConfiguration parent, int index) {
        super(parent, index);
    }

    @Override
    public void addAssociationOverride(int index, String name) {
        AssociationOverride associationOverride = this.buildAssociationOverride(index);
        associationOverride.addSelf();
        associationOverride.setName(name);
    }

    @Override
    public void addAttributeOverride(int index, String name) {
        AttributeOverride attributeOverride = this.buildAttributeOverride(index);
        attributeOverride.addSelf();
        attributeOverride.setName(name);
    }

    @Override
    public ExternalDiscriminatorColumn addDiscriminatorColumn(String columnName) {
        DiscriminatorColumn column = this.getDiscriminatorColumn();
        if (column == null) {
            column = this.buildDiscriminatorColumn();
            column.addSelf();
        }
        column.setName(columnName);
        return column;
    }

    @Override
    public void addNamedQuery(int index, String name) {
        NamedQuery namedQuery = this.buildNamedQuery(index);
        namedQuery.addSelf();
        namedQuery.setName(name);
    }

    @Override
    public void addNativeQuery(int index, String name) {
        NamedNativeQuery namedNativeQuery = this.buildNamedNativeQuery(index);
        namedNativeQuery.addSelf();
        namedNativeQuery.setName(name);
    }

    @Override
    public void addPrimaryKeyJoinColumn(int index, String name) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        pkJoinColumn.addSelf();
        pkJoinColumn.setName(name);
    }

    @Override
    public ExternalEntityTable addPrimaryTable(String tableName) {
        PrimaryTable primaryTable = this.buildPrimaryTable();
        primaryTable.addSelf();
        primaryTable.setName(tableName);
        return primaryTable;
    }

    @Override
    public void addSecondaryTable(int index, String name, String catalog, String schema) {
        SecondaryTable secondaryTable = this.buildSecondaryTable(index);
        secondaryTable.addSelf();
        secondaryTable.setName(name);
        secondaryTable.setCatalogName(catalog);
        secondaryTable.setSchemaName(schema);
    }

    @Override
    public void addSqlResultSetMapping(int index, String name) {
        SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(index);
        sqlResultSetMapping.addSelf();
        sqlResultSetMapping.setName(name);
    }

    @Override
    public void addStoredProcedureQuery(int index, String name, String procedureName) {
        NamedStoredProcedureQuery storedProcedureQuery = this.buildStoredProcedureQuery(index);
        storedProcedureQuery.addSelf();
        storedProcedureQuery.setName(name);
        storedProcedureQuery.setProcedureName(procedureName);
    }

    @Override
    public ListIterable<ExternalAssociationOverride> associationOverrides() {
        int count = this.associationOverridesSize();
        ArrayList<AssociationOverride> associationOverrides = new ArrayList<AssociationOverride>(count);
        int index = count;
        while (--index >= 0) {
            AssociationOverride associationOverride = this.buildAssociationOverride(index);
            associationOverrides.add(0, associationOverride);
        }
        return new ListListIterable(associationOverrides);
    }

    @Override
    public int associationOverridesSize() {
        return this.getChildrenSize("attribute-override");
    }

    @Override
    public ListIterable<ExternalAttributeOverride> attributeOverrides() {
        int count = this.attributeOverridesSize();
        ArrayList<AttributeOverride> attributeOverrides = new ArrayList<AttributeOverride>(count);
        int index = count;
        while (--index >= 0) {
            AttributeOverride attributeOverride = this.buildAttributeOverride(index);
            attributeOverrides.add(0, attributeOverride);
        }
        return new ListListIterable(attributeOverrides);
    }

    @Override
    public int attributeOverridesSize() {
        return this.getChildrenSize("association-override");
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(NAME);
        names.add("class");
        names.add("parent-class");
        names.add("access");
        names.add("cacheable");
        names.add("metadata-complete");
        names.add("read-only");
        names.add("existence-checking");
        names.add("exclude-default-mappings");
        return names;
    }

    private AssociationOverride buildAssociationOverride(int index) {
        return new AssociationOverride(this, index);
    }

    private AttributeOverride buildAttributeOverride(int index) {
        return new AttributeOverride(this, index);
    }

    private DiscriminatorColumn buildDiscriminatorColumn() {
        return new DiscriminatorColumn(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("customizer");
        names.add("change-tracking");
        names.add("table");
        names.add("secondary-table");
        names.add("primary-key-join-column");
        names.add("no-sql");
        names.add("id-class");
        names.add("primary-key");
        names.add(INHERITANCE);
        names.add(DISCRIMINATOR_VALUE);
        names.add("discriminator-column");
        names.add(CLASS_EXTRACTOR);
        names.add("optimistic-locking");
        names.add("cache");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("copy-policy");
        names.add("instantiation-copy-policy");
        names.add("clone-copy-policy");
        names.add("sequence-generator");
        names.add("table-generator");
        names.add("named-query");
        names.add("named-native-query");
        names.add("named-stored-procedure-query");
        names.add("sql-result-set-mapping");
        names.add("exclude-default-listeners");
        names.add("exclude-superclass-listeners");
        names.add(EntityListener.ENTITY_LISTENERS);
        names.add("pre-persist");
        names.add("post-persist");
        names.add("pre-remove");
        names.add("post-remove");
        names.add("pre-update");
        names.add("post-update");
        names.add("post-load");
        names.add("property");
        names.add("attribute-override");
        names.add("association-override");
        names.add("attributes");
        return names;
    }

    private NamedNativeQuery buildNamedNativeQuery(int index) {
        return new NamedNativeQuery(this, index);
    }

    private NamedQuery buildNamedQuery(int index) {
        return new NamedQuery(this, index);
    }

    private PrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(int index) {
        return new PrimaryKeyJoinColumn(this, index);
    }

    private PrimaryTable buildPrimaryTable() {
        return new PrimaryTable(this);
    }

    private SecondaryTable buildSecondaryTable(int index) {
        return new SecondaryTable(this, index);
    }

    private SQLResultSetMapping buildSqlResultSetMapping(int index) {
        return new SQLResultSetMapping(this, index);
    }

    private NamedStoredProcedureQuery buildStoredProcedureQuery(int index) {
        return new NamedStoredProcedureQuery(this, index);
    }

    @Override
    public ExternalAssociationOverride getAssociationOverride(int index) {
        Element element = this.getChild("association-override", index);
        if (element == null) {
            return null;
        }
        return this.buildAssociationOverride(index);
    }

    @Override
    public ExternalAttributeOverride getAttributeOverride(int index) {
        Element element = this.getChild("attribute-override", index);
        if (element == null) {
            return null;
        }
        return this.buildAttributeOverride(index);
    }

    @Override
    public String getClassExtractorClassName() {
        return this.getChildAttribute(CLASS_EXTRACTOR, "class");
    }

    @Override
    public DiscriminatorColumn getDiscriminatorColumn() {
        Element element = this.getChild("discriminator-column");
        if (element == null) {
            return null;
        }
        return this.buildDiscriminatorColumn();
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getChildTextNode(DISCRIMINATOR_VALUE);
    }

    @Override
    protected String getElementName() {
        return ENTITY;
    }

    @Override
    public InheritanceType getInheritenceStrategy() {
        Element element = this.getChild(INHERITANCE);
        if (element == null) {
            return null;
        }
        return this.getEnumAttribute(element, STRATEGY, InheritanceType.class);
    }

    @Override
    public String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public ExternalBasicNamedQuery getNamedQuery(int index) {
        Element element = this.getChild("named-query", index);
        if (element == null) {
            return null;
        }
        return this.buildNamedQuery(index);
    }

    @Override
    public ExternalBasicNamedQuery getNamedQuery(int index, String name) {
        ExternalBasicNamedQuery namedQuery = this.getNamedQuery(index);
        if (namedQuery == null) {
            return null;
        }
        if (ObjectTools.notEquals((Object)name, (Object)namedQuery.getName())) {
            namedQuery = null;
        }
        return namedQuery;
    }

    @Override
    public ExternalNativeQuery getNativeQuery(int index) {
        Element element = this.getChild("named-native-query", index);
        if (element == null) {
            return null;
        }
        return this.buildNamedNativeQuery(index);
    }

    @Override
    public ExternalNativeQuery getNativeQuery(int index, String name) {
        ExternalNativeQuery nativeQuery = this.getNativeQuery(index);
        if (nativeQuery == null) {
            return null;
        }
        if (ObjectTools.notEquals((Object)name, (Object)nativeQuery.getName())) {
            nativeQuery = null;
        }
        return nativeQuery;
    }

    @Override
    public ExternalPrimaryKeyJoinColumn getPrimaryKeyJoinColumn(int index) {
        Element element = this.getChild("primary-key-join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildPrimaryKeyJoinColumn(index);
    }

    @Override
    public ExternalEntityTable getPrimaryTable() {
        Element element = this.getChild("table");
        if (element == null) {
            return null;
        }
        return this.buildPrimaryTable();
    }

    @Override
    public ExternalEntitySecondaryTable getSecondaryTable(int index) {
        Element element = this.getChild("secondary-table");
        if (element == null) {
            return null;
        }
        return this.buildSecondaryTable(index);
    }

    @Override
    public ExternalSQLResultSetMapping getSqlResultSetMapping(int index) {
        Element element = this.getChild("sql-result-set-mapping", index);
        if (element == null) {
            return null;
        }
        return this.buildSqlResultSetMapping(index);
    }

    @Override
    public ExternalStoredProcedureQuery getStoredProcedureQuery(int index) {
        Element element = this.getChild("named-stored-procedure-query", index);
        if (element == null) {
            return null;
        }
        return this.buildStoredProcedureQuery(index);
    }

    @Override
    public ExternalStoredProcedureQuery getStoredProcedureQuery(int index, String name) {
        ExternalStoredProcedureQuery storedProcedureQuery = this.getStoredProcedureQuery(index);
        if (storedProcedureQuery == null) {
            return null;
        }
        if (ObjectTools.notEquals((Object)name, (Object)storedProcedureQuery.getName())) {
            storedProcedureQuery = null;
        }
        return storedProcedureQuery;
    }

    @Override
    public ListIterable<ExternalNamedQuery> namedQueries() {
        int count = this.namedQueriesSize();
        ArrayList<NamedQuery> namedQueries = new ArrayList<NamedQuery>(count);
        int index = count;
        while (--index >= 0) {
            NamedQuery namedQuery = this.buildNamedQuery(index);
            namedQueries.add(0, namedQuery);
        }
        return new ListListIterable(namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.getChildrenSize("named-query");
    }

    @Override
    public ListIterable<ExternalNativeQuery> nativeQueries() {
        int count = this.nativeQueriesSize();
        ArrayList<NamedNativeQuery> nativeQueries = new ArrayList<NamedNativeQuery>(count);
        int index = count;
        while (--index >= 0) {
            NamedNativeQuery nativeQuery = this.buildNamedNativeQuery(index);
            nativeQueries.add(0, nativeQuery);
        }
        return new ListListIterable(nativeQueries);
    }

    @Override
    public int nativeQueriesSize() {
        return this.getChildrenSize("named-native-query");
    }

    @Override
    public ListIterable<ExternalPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        int count = this.primaryKeyJoinColumnsSize();
        ArrayList<PrimaryKeyJoinColumn> pkJoinColumns = new ArrayList<PrimaryKeyJoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
            pkJoinColumns.add(0, pkJoinColumn);
        }
        return new ListListIterable(pkJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.getChildrenSize("primary-key-join-column");
    }

    @Override
    public void removeAssociationOverride(int index) {
        AssociationOverride associationOverride = this.buildAssociationOverride(index);
        associationOverride.removeSelf();
    }

    @Override
    public void removeAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildAttributeOverride(index);
        attributeOverride.removeSelf();
    }

    @Override
    public void removeNamedQuery(int index) {
        NamedQuery namedQuery = this.buildNamedQuery(index);
        namedQuery.removeSelf();
    }

    @Override
    public void removeNativeQuery(int index) {
        NamedNativeQuery namedNativeQuery = this.buildNamedNativeQuery(index);
        namedNativeQuery.removeSelf();
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        pkJoinColumn.removeSelf();
    }

    @Override
    public void removePrimaryTable() {
        PrimaryTable primaryTable = this.buildPrimaryTable();
        primaryTable.removeSelf();
    }

    @Override
    public void removeSecondaryTable(int index) {
        SecondaryTable secondaryTable = this.buildSecondaryTable(index);
        secondaryTable.removeSelf();
    }

    @Override
    public void removeSqlResultSetMapping(int index) {
        SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(index);
        sqlResultSetMapping.removeSelf();
    }

    @Override
    public void removeStoredProcedureQuery(int index) {
        NamedStoredProcedureQuery storedProcedureQuery = this.buildStoredProcedureQuery(index);
        storedProcedureQuery.removeSelf();
    }

    @Override
    public ListIterable<ExternalEntitySecondaryTable> secondaryTables() {
        int count = this.secondaryTablesSize();
        ArrayList<SecondaryTable> secondaryTables = new ArrayList<SecondaryTable>(count);
        int index = count;
        while (--index >= 0) {
            SecondaryTable secondaryTable = this.buildSecondaryTable(index);
            secondaryTables.add(0, secondaryTable);
        }
        return new ListListIterable(secondaryTables);
    }

    @Override
    public int secondaryTablesSize() {
        return this.getChildrenSize("secondary-table");
    }

    @Override
    public void setClassExtractorClassName(String className) {
        Element element = this.getChild(CLASS_EXTRACTOR);
        if (element == null && className != null) {
            element = this.addChild(CLASS_EXTRACTOR);
        }
        if (className != null) {
            this.setAttribute(element, "class", className);
        } else if (element != null) {
            this.removeChild(CLASS_EXTRACTOR);
        }
    }

    @Override
    public void setDiscriminatorValue(String discriminatorValue) {
        this.updateChildTextNode(DISCRIMINATOR_VALUE, discriminatorValue);
    }

    @Override
    public void setInheritanceStrategy(InheritanceType value) {
        Element element = this.getChild(INHERITANCE);
        if (element == null && value == null) {
            return;
        }
        if (element == null && value != null) {
            element = this.addChild(INHERITANCE);
        }
        if (value != null) {
            this.setAttribute(element, STRATEGY, (Enum<?>)value);
        } else if (element != null) {
            this.removeChild(INHERITANCE);
        }
    }

    @Override
    public void setName(String name) {
        this.setAttribute(NAME, name);
    }

    @Override
    public ListIterable<ExternalSQLResultSetMapping> sqlResultSetMappings() {
        int count = this.sqlResultSetMappingsSize();
        ArrayList<SQLResultSetMapping> sqlResultSetMappings = new ArrayList<SQLResultSetMapping>(count);
        int index = count;
        while (--index >= 0) {
            SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(index);
            sqlResultSetMappings.add(0, sqlResultSetMapping);
        }
        return new ListListIterable(sqlResultSetMappings);
    }

    @Override
    public int sqlResultSetMappingsSize() {
        return this.getChildrenSize("sql-result-set-mapping");
    }

    @Override
    public ListIterable<ExternalStoredProcedureQuery> storedProcedureQueries() {
        int count = this.storedProcedureQueriesSize();
        ArrayList<NamedStoredProcedureQuery> storedProcedureQueries = new ArrayList<NamedStoredProcedureQuery>(count);
        int index = count;
        while (--index >= 0) {
            NamedStoredProcedureQuery nativeQuery = this.buildStoredProcedureQuery(index);
            storedProcedureQueries.add(0, nativeQuery);
        }
        return new ListListIterable(storedProcedureQueries);
    }

    @Override
    public int storedProcedureQueriesSize() {
        return this.getChildrenSize("named-stored-procedure-query");
    }
}

