/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModelWrapper;

public class DoublePropertyValueModel<V>
extends PropertyValueModelWrapper<PropertyValueModel<? extends V>>
implements PropertyValueModel<V> {
    protected volatile PropertyValueModel<? extends V> valueModelValueModel;
    protected final PropertyChangeListener valueModelValueListener = this.buildValueModelValueListener();

    public DoublePropertyValueModel(PropertyValueModel<? extends PropertyValueModel<? extends V>> valueModel) {
        super(valueModel);
    }

    protected PropertyChangeListener buildValueModelValueListener() {
        return new ValueModelListener();
    }

    @Override
    public V getValue() {
        return this.valueModelValueModel == null ? null : (V)this.valueModelValueModel.getValue();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }

    @Override
    protected void wrappedValueChanged(PropertyValueModel<? extends V> oldValue, PropertyValueModel<? extends V> newValue) {
        if (this.hasListeners()) {
            V old = this.getValue();
            this.disengageValueModel();
            this.engageValueModel();
            this.firePropertyChanged("value", old, this.getValue());
        }
    }

    protected void wrappedValueModelValueChanged(PropertyChangeEvent event) {
        this.firePropertyChanged(event.clone(this));
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.engageValueModel();
    }

    protected void engageValueModel() {
        this.valueModelValueModel = (PropertyValueModel)this.valueModel.getValue();
        if (this.valueModelValueModel != null) {
            this.valueModelValueModel.addPropertyChangeListener("value", this.valueModelValueListener);
        }
    }

    @Override
    protected void disengageModel() {
        this.disengageValueModel();
        super.disengageModel();
    }

    protected void disengageValueModel() {
        if (this.valueModelValueModel != null) {
            this.valueModelValueModel.removePropertyChangeListener("value", this.valueModelValueListener);
        }
        this.valueModelValueModel = null;
    }

    class ValueModelListener
    extends PropertyChangeAdapter {
        ValueModelListener() {
        }

        @Override
        public void propertyChanged(PropertyChangeEvent event) {
            DoublePropertyValueModel.this.wrappedValueModelValueChanged(event);
        }
    }
}

