/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.event;

import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.ChangeEvent;

public final class PropertyChangeEvent
extends ChangeEvent {
    private final String propertyName;
    private final Object oldValue;
    private final Object newValue;
    private static final long serialVersionUID = 1L;

    public PropertyChangeEvent(Model source, String propertyName, Object oldValue, Object newValue) {
        super(source);
        if (propertyName == null) {
            throw new NullPointerException();
        }
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(this.propertyName);
        sb.append(": ");
        sb.append(this.oldValue);
        sb.append(" => ");
        sb.append(this.newValue);
    }

    public PropertyChangeEvent clone(Model newSource) {
        return new PropertyChangeEvent(newSource, this.propertyName, this.oldValue, this.newValue);
    }

    public PropertyChangeEvent clone(Model newSource, String newPropertyName) {
        return new PropertyChangeEvent(newSource, newPropertyName, this.oldValue, this.newValue);
    }
}

