/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LocalVariable {
    private ConstantPool constantPool;
    private short startPC;
    private short length;
    private short nameIndex;
    private short descriptorIndex;
    private short index;
    private FieldType fieldDescriptor;

    LocalVariable(ClassFileDataInputStream stream, ConstantPool constantPool) throws IOException {
        this.constantPool = constantPool;
        this.initialize(stream);
    }

    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.startPC = stream.readU2();
        this.length = stream.readU2();
        this.nameIndex = stream.readU2();
        this.descriptorIndex = stream.readU2();
        this.index = stream.readU2();
    }

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        this.getFieldDescriptor().printDeclarationOn(writer);
        writer.print(' ');
        writer.println(this.name());
        writer.indent();
        writer.print("PC start: ");
        writer.print(this.startPC);
        writer.print(" length: ");
        writer.println(this.length);
        writer.undent();
    }

    public boolean isNamed(String name) {
        return this.name().equals(name);
    }

    public String name() {
        return this.constantPool.getUTF8String(this.nameIndex);
    }

    public String descriptor() {
        return this.constantPool.getUTF8String(this.descriptorIndex);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getFieldDescriptor().accept(visitor);
    }

    public FieldType getFieldDescriptor() {
        if (this.fieldDescriptor == null) {
            this.fieldDescriptor = FieldType.createFieldType(this.descriptor());
        }
        return this.fieldDescriptor;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public short getStartPC() {
        return this.startPC;
    }

    public short getLength() {
        return this.length;
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public short getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public short getIndex() {
        return this.index;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.name() + ')';
    }
}

