/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWDescriptorMultiTableInfoPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWReferenceHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWSecondaryTableHolder
extends MWModel {
    private MWTableHandle tableHandle;
    private volatile boolean primaryKeysHaveSameName;
    public static final String PRIMARY_KEYS_HAVE_SAME_NAME_PROPERTY = "primaryKeysHaveSameName";
    private MWReferenceHandle referenceHandle;
    public static final String REFERENCE_PROPERTY = "reference";

    private MWSecondaryTableHolder() {
    }

    MWSecondaryTableHolder(MWDescriptorMultiTableInfoPolicy parent, MWTable mwTable) {
        super(parent);
        this.tableHandle.setTable(mwTable);
    }

    @Override
    protected void initialize(Node rent) {
        super.initialize(rent);
        this.primaryKeysHaveSameName = true;
        this.tableHandle = new MWTableHandle(this, this.buildTableScrubber());
        this.referenceHandle = new MWReferenceHandle(this, this.buildReferenceScrubber());
    }

    private MWDescriptorMultiTableInfoPolicy getPolicy() {
        return (MWDescriptorMultiTableInfoPolicy)this.getParent();
    }

    public MWTable getTable() {
        return this.tableHandle.getTable();
    }

    public boolean primaryKeysHaveSameName() {
        return this.primaryKeysHaveSameName;
    }

    public void setPrimaryKeysHaveSameName(boolean primaryKeysHaveSameName) {
        boolean old = this.primaryKeysHaveSameName;
        this.primaryKeysHaveSameName = primaryKeysHaveSameName;
        this.firePropertyChanged(PRIMARY_KEYS_HAVE_SAME_NAME_PROPERTY, old, primaryKeysHaveSameName);
        if (old != primaryKeysHaveSameName && primaryKeysHaveSameName) {
            this.setReference(null);
        }
    }

    public MWReference getReference() {
        if (this.primaryKeysHaveSameName) {
            throw new IllegalStateException("This secondary table association is based on primary keys");
        }
        return this.referenceHandle.getReference();
    }

    public void setReference(MWReference reference) {
        if (reference != null && this.primaryKeysHaveSameName) {
            throw new IllegalStateException("This secondary table association is based on primary keys");
        }
        MWReference old = this.referenceHandle.getReference();
        this.referenceHandle.setReference(reference);
        this.firePropertyChanged(REFERENCE_PROPERTY, old, reference);
    }

    @Override
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.tableHandle);
        list.add(this.referenceHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWSecondaryTableHolder.this.tableRemoved();
            }

            public String toString() {
                return "MWSecondaryTableHolder.buildTableScrubber()";
            }
        };
    }

    void tableRemoved() {
        this.getPolicy().removeSecondaryTableHolder(this);
    }

    private MWHandle.NodeReferenceScrubber buildReferenceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWSecondaryTableHolder.this.setReference(null);
            }

            public String toString() {
                return "MWSecondaryTableHolder.buildReferenceScrubber()";
            }
        };
    }

    @Override
    public void toString(StringBuffer sb) {
        this.getTable().toString(sb);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWSecondaryTableHolder.class);
        XMLCompositeObjectMapping tableHandleMapping = new XMLCompositeObjectMapping();
        tableHandleMapping.setAttributeName("tableHandle");
        tableHandleMapping.setGetMethodName("getTableHandleForTopLink");
        tableHandleMapping.setSetMethodName("setTableHandleForTopLink");
        tableHandleMapping.setReferenceClass(MWTableHandle.class);
        tableHandleMapping.setXPath("table-handle");
        descriptor.addMapping((DatabaseMapping)tableHandleMapping);
        descriptor.addDirectMapping(PRIMARY_KEYS_HAVE_SAME_NAME_PROPERTY, "primary-keys-have-same-name/text()");
        XMLCompositeObjectMapping referenceHandleMapping = new XMLCompositeObjectMapping();
        referenceHandleMapping.setAttributeName("referenceHandle");
        referenceHandleMapping.setGetMethodName("getReferenceHandleForTopLink");
        referenceHandleMapping.setSetMethodName("setReferenceHandleForTopLink");
        referenceHandleMapping.setReferenceClass(MWReferenceHandle.class);
        referenceHandleMapping.setXPath("reference-handle");
        descriptor.addMapping((DatabaseMapping)referenceHandleMapping);
        return descriptor;
    }

    private MWTableHandle getTableHandleForTopLink() {
        return this.tableHandle.getTable() == null ? null : this.tableHandle;
    }

    private void setTableHandleForTopLink(MWTableHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildTableScrubber();
        this.tableHandle = handle == null ? new MWTableHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWReferenceHandle getReferenceHandleForTopLink() {
        return this.referenceHandle.getReference() == null ? null : this.referenceHandle;
    }

    private void setReferenceHandleForTopLink(MWReferenceHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildReferenceScrubber();
        this.referenceHandle = handle == null ? new MWReferenceHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

