/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository;

import java.io.File;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsApplicationNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsPlugin;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DatabasePlatformNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.AddDatabasePlatformAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.DatabasePlatformRepositoryTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.RenameDatabasePlatformRepositoryAction;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.node.NodeModel;

public final class DatabasePlatformRepositoryNode
extends PlatformsApplicationNode {
    private ListValueModel childrenModel;
    protected static final String[] DATABASE_PLATFORM_REPOSITORY_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};

    public DatabasePlatformRepositoryNode(DatabasePlatformRepository value, ApplicationContext context, PlatformsPlugin plugin) {
        super((NodeModel)value, context.getNodeManager().getRootNode(), plugin, context);
    }

    protected void initialize() {
        super.initialize();
        this.childrenModel = this.buildChildrenModel();
    }

    private ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    private ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildPlatformNodeAdapter(), "displayString");
    }

    private ListValueModel buildPlatformNodeAdapter() {
        return new TransformationListValueModelAdapter(this.buildPlatformsAdapter()){

            @Override
            protected Object transformItem(Object item) {
                return DatabasePlatformRepositoryNode.this.buildDatabasePlatformNode((DatabasePlatform)item);
            }
        };
    }

    DatabasePlatformNode buildDatabasePlatformNode(DatabasePlatform databasePlatform) {
        return new DatabasePlatformNode(databasePlatform, this, this.getPlatformsPlugin(), this.getApplicationContext());
    }

    private CollectionValueModel buildPlatformsAdapter() {
        return new CollectionAspectAdapter(this, "platforms"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((DatabasePlatformRepository)this.subject).platforms();
            }

            @Override
            protected int sizeFromSubject() {
                return ((DatabasePlatformRepository)this.subject).platformsSize();
            }
        };
    }

    @Override
    protected Class propertiesPageClass() {
        return DatabasePlatformRepositoryTabbedPropertiesPage.class;
    }

    @Override
    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext context) {
        return new DatabasePlatformRepositoryTabbedPropertiesPage(context);
    }

    @Override
    public String helpTopicID() {
        return "database.platform.repository";
    }

    @Override
    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    @Override
    protected String[] displayStringPropertyNames() {
        return DATABASE_PLATFORM_REPOSITORY_DISPLAY_STRING_PROPERTY_NAMES;
    }

    @Override
    protected String buildIconKey() {
        return "DATABASE_PLATFORM_REPOSITORY";
    }

    @Override
    public boolean save(File mostRecentSaveDirectory, WorkbenchContext context) {
        context = this.buildLocalWorkbenchContext(context);
        if (this.getDatabasePlatformRepository().getFile() == null) {
            File file = this.promptForSaveFile(mostRecentSaveDirectory, context);
            if (file == null) {
                return false;
            }
            this.getDatabasePlatformRepository().setFile(file);
        }
        this.getDatabasePlatformRepository().write();
        return true;
    }

    @Override
    public boolean saveAs(File mostRecentSaveDirectory, WorkbenchContext context) {
        File file = this.promptForSaveFile(mostRecentSaveDirectory, context = this.buildLocalWorkbenchContext(context));
        if (file == null) {
            return false;
        }
        this.getDatabasePlatformRepository().setFile(file);
        this.getDatabasePlatformRepository().write();
        return true;
    }

    @Override
    public File saveFile() {
        return this.getDatabasePlatformRepository().getFile();
    }

    @Override
    public GroupContainerDescription buildMenuDescription(WorkbenchContext context) {
        context = this.buildLocalWorkbenchContext(context);
        RootMenuDescription menu = new RootMenuDescription();
        MenuGroupDescription basicGroup = new MenuGroupDescription();
        basicGroup.add(this.buildRenameAction(context));
        basicGroup.add(this.buildAddPlatformAction(context));
        menu.add(basicGroup);
        MenuGroupDescription helpGroup = new MenuGroupDescription();
        helpGroup.add(this.getPlatformsPlugin().getHelpAction(context));
        menu.add(helpGroup);
        return menu;
    }

    @Override
    public GroupContainerDescription buildToolBarDescription(WorkbenchContext context) {
        context = this.buildLocalWorkbenchContext(context);
        ToolBarDescription toolBar = new ToolBarDescription();
        ToolBarButtonGroupDescription basicGroup = new ToolBarButtonGroupDescription();
        basicGroup.add(this.buildRenameAction(context));
        basicGroup.add(this.buildAddPlatformAction(context));
        toolBar.add(basicGroup);
        return toolBar;
    }

    DatabasePlatformRepository getDatabasePlatformRepository() {
        return (DatabasePlatformRepository)this.getValue();
    }

    private FrameworkAction buildRenameAction(WorkbenchContext workbenchContext) {
        return new RenameDatabasePlatformRepositoryAction(workbenchContext);
    }

    private FrameworkAction buildAddPlatformAction(WorkbenchContext workbenchContext) {
        return new AddDatabasePlatformAction(workbenchContext);
    }

    private File promptForSaveFile(File mostRecentSaveDirectory, WorkbenchContext context) {
        JFileChooser fileChooser = new JFileChooser(mostRecentSaveDirectory);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle(context.getApplicationContext().getResourceRepository().getString("REPOSITORY_SAVE_FILE_TITLE", this.getDatabasePlatformRepository().getName()));
        int buttonChoice;
        while ((buttonChoice = fileChooser.showSaveDialog(context.getCurrentWindow())) == 0) {
            File file = fileChooser.getSelectedFile();
            if (this.getPlatformsPlugin().fileIsSupported(file)) {
                return file;
            }
            JOptionPane.showMessageDialog(context.getCurrentWindow(), context.getApplicationContext().getResourceRepository().getString("UNSUPPORTED_FILE_TYPE"));
        }
        return null;
    }
}

