/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.AddQueryDialog;

final class AddEjbQueryDialog
extends AddQueryDialog {
    private JRadioButton namedQueryRadioButton;
    private JRadioButton finderRadioButton;
    private JRadioButton topLinkReservedFinderRadioButton;
    private JRadioButton ejbSelectRadioButton;
    private JComboBox nameComboBox;

    public AddEjbQueryDialog(WorkbenchContext context, boolean supportsReportQuery) {
        super(context, supportsReportQuery);
    }

    @Override
    protected Component buildMainPanel() {
        JPanel messagePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel queryVarietyPanel = this.buildQueryVarietyPanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        messagePanel.add((Component)queryVarietyPanel, constraints);
        this.helpManager().addTopicID(queryVarietyPanel, this.helpTopicId() + ".ejb20");
        JPanel queryTypePanel = this.buildQueryTypePanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        messagePanel.add((Component)queryTypePanel, constraints);
        this.helpManager().addTopicID(queryTypePanel, this.helpTopicId() + ".type");
        JPanel namePanel = this.buildNamePanel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 5);
        messagePanel.add((Component)namePanel, constraints);
        this.helpManager().addTopicID(namePanel, this.helpTopicId() + ".name");
        this.getOKAction().setEnabled(false);
        return messagePanel;
    }

    @Override
    protected JPanel buildNamePanel() {
        JPanel namePanel = super.buildNamePanel();
        GridBagConstraints constraints = new GridBagConstraints();
        this.nameComboBox = new JComboBox(MWQueryManager.topLinkReservedFinderNames());
        this.nameComboBox.addActionListener(this);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        namePanel.add((Component)this.nameComboBox, constraints);
        return namePanel;
    }

    private JPanel buildQueryVarietyPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("VARIETY_BORDER_LABEL_ON_ADD_QUERY_DIALOG")));
        GridBagConstraints constraints = new GridBagConstraints();
        this.namedQueryRadioButton = new JRadioButton(this.resourceRepository().getString("TOPLINK_NAMED_QUERY_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
        this.namedQueryRadioButton.addActionListener(this);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        buttonPanel.add((Component)this.namedQueryRadioButton, constraints);
        this.finderRadioButton = new JRadioButton(this.resourceRepository().getString("EJB_FINDER_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
        this.finderRadioButton.addActionListener(this);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        buttonPanel.add((Component)this.finderRadioButton, constraints);
        this.topLinkReservedFinderRadioButton = new JRadioButton(this.resourceRepository().getString("TOPLINK_RESERVED_FINDER_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
        this.topLinkReservedFinderRadioButton.addActionListener(this);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        buttonPanel.add((Component)this.topLinkReservedFinderRadioButton, constraints);
        this.ejbSelectRadioButton = new JRadioButton(this.resourceRepository().getString("EJB_SELECT_TYPE_LABEL_ON_ADD_QUERY_DIALOG"));
        this.ejbSelectRadioButton.addActionListener(this);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 5, 0);
        buttonPanel.add((Component)this.ejbSelectRadioButton, constraints);
        ButtonGroup queryVarietyButtonGroup = new ButtonGroup();
        queryVarietyButtonGroup.add(this.namedQueryRadioButton);
        queryVarietyButtonGroup.add(this.finderRadioButton);
        queryVarietyButtonGroup.add(this.topLinkReservedFinderRadioButton);
        queryVarietyButtonGroup.add(this.ejbSelectRadioButton);
        return buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.namedQueryRadioButton) {
            this.setVisibleNameEditor(this.getNameTextField());
            this.getNameTextField().setText("");
            this.enableQueryTypePanel(true);
        } else if (source == this.finderRadioButton) {
            this.setVisibleNameEditor(this.getNameTextField());
            if (!this.getNameTextField().getText().startsWith("find")) {
                this.getNameTextField().setText("find");
            }
            this.enableQueryTypePanel(true);
        } else if (source == this.topLinkReservedFinderRadioButton) {
            this.setVisibleNameEditor(this.nameComboBox);
            this.setQueryTypeForTopLinkReservedFinder();
            this.enableQueryTypePanel(false);
        } else if (source == this.ejbSelectRadioButton) {
            this.setVisibleNameEditor(this.getNameTextField());
            if (!this.getNameTextField().getText().startsWith("ejbSelect")) {
                this.getNameTextField().setText("ejbSelect");
            }
            this.enableQueryTypePanel(true);
        } else if (source == this.nameComboBox) {
            this.setQueryTypeForTopLinkReservedFinder();
        }
        super.actionPerformed(ae);
    }

    private void setVisibleNameEditor(JComponent visibleComponent) {
        if (visibleComponent == this.getNameTextField()) {
            if (!this.getNameTextField().isVisible()) {
                this.getNameTextField().setVisible(true);
            }
            this.nameComboBox.setVisible(false);
        } else if (visibleComponent == this.nameComboBox) {
            if (!this.nameComboBox.isVisible()) {
                this.nameComboBox.setVisible(true);
            }
            this.getNameTextField().setVisible(false);
        } else {
            throw new RuntimeException(this.resourceRepository().getString("EITHER_TEXTFIELD_COMBOBOX_SET_VISIBLE_EXCEPTION"));
        }
    }

    private void setQueryTypeForTopLinkReservedFinder() {
        if (this.getQueryName().equals("findByPrimaryKey")) {
            this.setQueryType("READ_OBJECT_QUERY");
        } else if (this.getQueryName().equals("findAll")) {
            this.setQueryType("READ_ALL_QUERY");
        } else if (this.getQueryName().equals("findOneBySql")) {
            this.setQueryType("READ_OBJECT_QUERY");
        } else if (this.getQueryName().equals("findManyBySql")) {
            this.setQueryType("READ_ALL_QUERY");
        } else if (this.getQueryName().equals("findOneByEjbql")) {
            this.setQueryType("READ_OBJECT_QUERY");
        } else if (this.getQueryName().equals("findManyByEjbql")) {
            this.setQueryType("READ_ALL_QUERY");
        } else if (this.getQueryName().equals("findOneByQuery")) {
            this.setQueryType("READ_OBJECT_QUERY");
        } else if (this.getQueryName().equals("findManyByQuery")) {
            this.setQueryType("READ_ALL_QUERY");
        }
    }

    @Override
    protected void prepareToShow() {
        super.prepareToShow();
        this.finderRadioButton.doClick();
    }

    @Override
    public String getQueryName() {
        if (this.topLinkReservedFinderRadioButton.isSelected()) {
            return (String)this.nameComboBox.getSelectedItem();
        }
        return this.getNameTextField().getText();
    }
}

