/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchWindow;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

final class OpenRecentFileAction
extends AbstractAction {
    private WorkbenchWindow workbenchWindow;
    private File recentFile;
    private static final Icon ICON = new EmptyIcon(16);

    OpenRecentFileAction(WorkbenchWindow workbenchWindow, int count, File recentFile) {
        this.initialize(workbenchWindow, count, recentFile);
    }

    void initialize(WorkbenchWindow workbenchWindow, int count, File recentFile) {
        this.workbenchWindow = workbenchWindow;
        this.recentFile = recentFile;
        String countString = Integer.toString(count);
        String shortFileName = FileTools.shortenFileName((File)recentFile.getAbsoluteFile());
        this.putValue("Name", countString + " " + shortFileName);
        this.putValue("ShortDescription", recentFile.getAbsolutePath());
        this.putValue("SmallIcon", ICON);
        if (count < 10) {
            this.putValue("MnemonicKey", new Integer(countString.charAt(0)));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.recentFile.exists()) {
            this.workbenchWindow.nodeManager().open(this.recentFile, this.workbenchWindow.getContext());
        } else {
            JOptionPane.showMessageDialog(this.workbenchWindow, this.workbenchWindow.resourceRepository().getString("recentProjectFileNotFound.message", this.recentFile.getAbsolutePath()), this.workbenchWindow.resourceRepository().getString("recentProjectFileNotFound.title"), 0);
            this.workbenchWindow.getApplication().recentFilesManager().removeRecentFile(this.recentFile);
        }
    }
}

