/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ChangeFlagTest
extends AutoVerifyTestCase {
    protected boolean extraChangeComparison = false;
    protected Employee clone;
    protected ObjectChangePolicy changePolicy;
    private DescriptorEventAdapter eventAdapter = new DescriptorEventAdapter(){

        public void preWrite(DescriptorEvent event) {
            ChangeFlagTest.this.writeOccurred(event);
        }
    };

    public void setup() {
        this.getSession().getDescriptor(Employee.class).getEventManager().addListener((DescriptorEventListener)this.eventAdapter);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector employees = uow.readAllObjects(Employee.class);
        this.clone = (Employee)employees.firstElement();
        this.clone.setFirstName(this.clone.getFirstName() + "1");
        uow.commit();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getDescriptor(Employee.class).getEventManager().removeListener((DescriptorEventListener)this.eventAdapter);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void verify() {
        if (this.extraChangeComparison) {
            throw new TestErrorException("An extra change comparison occurred when commiting an employee to the database.");
        }
    }

    public void writeOccurred(DescriptorEvent event) {
        Object object = ((WriteObjectQuery)event.getQuery()).getObject();
        if (object != this.clone) {
            this.extraChangeComparison = true;
        }
    }
}

