/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.queries.report.Bar;
import org.eclipse.persistence.testing.tests.queries.report.Beer;
import org.eclipse.persistence.testing.tests.queries.report.Brewer;
import org.eclipse.persistence.testing.tests.queries.report.Person;

public class ReportQueryWithDuplicateQueryKeysTest
extends AutoVerifyTestCase {
    public void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Bar bar = new Bar();
        Person person = new Person();
        person.setKey("Key1");
        person.setName("Anthony");
        bar.setBrewer(person);
        bar.setName("Dugs Jugs o' Beer");
        bar.setKey("TheKey");
        Beer beer = new Beer();
        person.setFaviouriteBeer(beer);
        beer.setBrand("Dugs");
        beer.setKey("AnotherKey");
        beer.setBrewer(new Brewer("Molson"));
        beer.getBrewer().setKey("Key2");
        bar.addBeer(beer);
        uow.registerObject((Object)bar);
        uow.commit();
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Bar bar = (Bar)uow.readObject(Bar.class);
        uow.deleteObject((Object)bar);
        uow.deleteObject((Object)bar.getBrewer());
        uow.deleteObject((Object)bar.getBrewer().getFaviouriteBeer().getBrewer());
        uow.deleteObject((Object)bar.getBrewer().getFaviouriteBeer());
        uow.commit();
    }

    public void test() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery reportQuery = new ReportQuery(Bar.class, builder);
        Expression expression = builder.get("brewer").get("faviouriteBeer").get("brewer").get("name");
        reportQuery.addAttribute("Names", expression);
        try {
            Object result = this.getSession().executeQuery((DatabaseQuery)reportQuery);
        }
        catch (QueryException ex) {
            throw new TestErrorException("Test failed as the toplink failed to find the correct descriptor." + ex.toString());
        }
    }
}

