/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class NamedQueryConformNullPointerException
extends TestCase {
    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression firstNameExpression = emp.get("firstName").equal(emp.getParameter("firstName"));
        Expression lastNameExpression = emp.get("lastName").equal(emp.getParameter("lastName"));
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(firstNameExpression.and(lastNameExpression));
        query.addArgument("firstName");
        query.addArgument("lastName");
        query.conformResultsInUnitOfWork();
        this.getSession().removeQuery("getEmployeeWithName");
        this.getSession().addQuery("getEmployeeWithName", (DatabaseQuery)query);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Bob"));
        Employee employeeClone = (Employee)uow.registerObject((Object)employee);
        employeeClone.setFirstName("Bobby");
        Employee employee1 = (Employee)uow.executeQuery("getEmployeeWithName", (Object)"Bob", (Object)"Smith");
        if (employee1 != null) {
            throw new TestErrorException("employee is not null and should be");
        }
        employee1 = (Employee)uow.executeQuery("getEmployeeWithName", (Object)"Bobby", (Object)"Smith");
        if (employee1 == null) {
            throw new TestErrorException("employee is null and shouldn't be");
        }
    }
}

