/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.AttributeConverter;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class ConverterClass
implements Converter {
    protected boolean isForMapKey;
    protected boolean disableConversion;
    protected Class fieldClassification;
    protected String fieldClassificationName;
    protected String attributeConverterClassName;
    protected AttributeConverter attributeConverter;

    public ConverterClass(String attributeConverterClassName, boolean isForMapKey, String fieldClassificationName, boolean disableConversion) {
        this.isForMapKey = isForMapKey;
        this.disableConversion = disableConversion;
        this.fieldClassificationName = fieldClassificationName;
        this.attributeConverterClassName = attributeConverterClassName;
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        try {
            return this.attributeConverter.convertToEntityAttribute(dataValue);
        }
        catch (RuntimeException re) {
            throw new PersistenceException(ExceptionLocalization.buildMessage((String)"wrap_convert_exception", (Object[])new Object[]{"convertToEntityAttribute", this.attributeConverterClassName, dataValue}), (Throwable)re);
        }
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        try {
            return this.attributeConverter.convertToDatabaseColumn(objectValue);
        }
        catch (RuntimeException re) {
            throw new PersistenceException(ExceptionLocalization.buildMessage((String)"wrap_convert_exception", (Object[])new Object[]{"convertToDatabaseColumn", this.attributeConverterClassName, objectValue}), (Throwable)re);
        }
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        DirectToFieldMapping m;
        ConverterClass converter;
        block20: {
            ClassLoader loader;
            block19: {
                loader = ConversionManager.getDefaultManager().getLoader();
                if (this.disableConversion) {
                    converter = null;
                } else {
                    converter = this;
                    Class attributeConverterClass = null;
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                attributeConverterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.attributeConverterClassName, true, loader));
                                this.attributeConverter = (AttributeConverter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(attributeConverterClass));
                                break block19;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames((String)this.attributeConverterClassName, (Exception)exception.getException());
                            }
                        }
                        attributeConverterClass = PrivilegedAccessHelper.getClassForName((String)this.attributeConverterClassName, (boolean)true, (ClassLoader)loader);
                        this.attributeConverter = (AttributeConverter)PrivilegedAccessHelper.newInstanceFromClass((Class)attributeConverterClass);
                    }
                    catch (ClassNotFoundException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames((String)this.attributeConverterClassName, (Exception)exception);
                    }
                    catch (IllegalAccessException exception) {
                        throw ValidationException.errorInstantiatingClass(attributeConverterClass, (Exception)exception);
                    }
                    catch (InstantiationException exception) {
                        throw ValidationException.errorInstantiatingClass(attributeConverterClass, (Exception)exception);
                    }
                }
            }
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.fieldClassification = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.fieldClassificationName, true, loader));
                        break block20;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames((String)this.fieldClassificationName, (Exception)exception.getException());
                    }
                }
                this.fieldClassification = PrivilegedAccessHelper.getClassForName((String)this.fieldClassificationName, (boolean)true, (ClassLoader)loader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames((String)this.attributeConverterClassName, (Exception)exception);
            }
        }
        if (mapping.isDirectToFieldMapping()) {
            m = (DirectToFieldMapping)mapping;
            m.setConverter((Converter)converter);
            m.setFieldClassification(this.fieldClassification);
            m.setFieldClassificationClassName(this.fieldClassificationName);
        } else if (mapping.isDirectMapMapping() && this.isForMapKey) {
            m = (DirectMapMapping)mapping;
            m.setKeyConverter((Converter)converter);
            m.setDirectKeyFieldClassification(this.fieldClassification);
            m.setDirectKeyFieldClassificationName(this.fieldClassificationName);
        } else if (mapping.isDirectCollectionMapping()) {
            m = (DirectCollectionMapping)mapping;
            m.setValueConverter((Converter)converter);
            m.setDirectFieldClassification(this.fieldClassification);
            m.setDirectFieldClassificationName(this.fieldClassificationName);
        }
    }

    public boolean isMutable() {
        return false;
    }
}

