/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.ConcurrentModificationException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class UnitOfWorkConcurrentRevertTest
extends AutoVerifyTestCase {
    public Employee baseEmp;
    public boolean exception = false;

    public UnitOfWorkConcurrentRevertTest() {
        this.setDescription("Test that a concurrent modification exception can be avoided by a reverting UnitOfWork.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        this.baseEmp = (Employee)uow.readObject(Employee.class);
        for (int count = 20; count > 0; --count) {
            this.baseEmp.addPhoneNumber(new PhoneNumber(String.valueOf(count), String.valueOf(count), "5555555"));
        }
        uow.commit();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    for (int count = 20; count > 0; --count) {
                        UnitOfWork uow = UnitOfWorkConcurrentRevertTest.this.getSession().acquireUnitOfWork();
                        Employee emp = (Employee)uow.readObject((Object)UnitOfWorkConcurrentRevertTest.this.baseEmp);
                        emp.getPhoneNumbers();
                        uow.revertObject((Object)emp);
                    }
                }
                catch (ConcurrentModificationException ex) {
                    UnitOfWorkConcurrentRevertTest.this.exception = true;
                }
            }
        };
        Thread thread1 = new Thread(runnable2);
        thread1.start();
        try {
            for (int count = 20; count > 0; --count) {
                uow = this.getSession().acquireUnitOfWork();
                Employee emp = (Employee)uow.readObject((Object)this.baseEmp);
                emp.getPhoneNumbers().remove(0);
                uow.commit();
            }
        }
        catch (ConcurrentModificationException ex) {
            this.exception = true;
        }
        try {
            thread1.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void verify() {
        if (this.exception) {
            this.exception = false;
            throw new TestErrorException("Concurrent Modification exception was thrown durring a revert");
        }
    }
}

