/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class MWConfigModelEncryptionTest
extends AutoVerifyTestCase {
    DatabaseSessionConfig m_sessionConfig1;
    DatabaseSessionConfig m_sessionConfig2;

    public MWConfigModelEncryptionTest() {
        this.setDescription("Tests the detection and encryption of a unencrypted password on the config model");
    }

    public void test() throws Exception {
        SessionConfigs m_sessions = SessionManager.getManager().getInternalMWConfigObjects("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSession.xml", ((Object)((Object)this)).getClass().getClassLoader());
        this.m_sessionConfig1 = (DatabaseSessionConfig)m_sessions.getSessionConfigs().firstElement();
        this.m_sessionConfig2 = (DatabaseSessionConfig)m_sessions.getSessionConfigs().lastElement();
        this.m_sessionConfig2.getLoginConfig().setEncryptedPassword(null);
    }

    protected void verify() {
        String password1 = this.m_sessionConfig1.getLoginConfig().getEncryptedPassword();
        String password2 = this.m_sessionConfig1.getLoginConfig().getPassword();
        String password3 = this.m_sessionConfig1.getLoginConfig().getEncryptedPassword();
        if (password1.equals(password3)) {
            throw new TestErrorException("The password was not encrypted on the getPassword() call. Either the password was already encrypted or the detection failed.");
        }
        try {
            this.m_sessionConfig2.getLoginConfig().getPassword();
        }
        catch (NullPointerException e) {
            throw new TestErrorException("Call to getPassword() with a null password caused a NPE");
        }
    }
}

