/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class ScrollableCursorTest
extends TestCase {
    protected int size;
    protected Vector normalQueryObjects;
    protected Vector cursoredQueryObjects;
    protected Class referenceClass;
    protected Expression joinExpression;
    protected boolean TYPE_SCROLL_INSENSITIVE_isSupported;
    protected boolean CONCUR_UPDATABLE_isSupported;

    public ScrollableCursorTest(Class referenceClass, Expression expression) {
        this.setReferenceClass(referenceClass);
        this.setName(this.getName() + "(" + referenceClass + ")");
        this.setDescription("This test verifies that the number of objects read in using a scrollable cursor matches the number of object read in using a normal query");
        this.joinExpression = expression;
    }

    public Vector getCursoredQueryObjects() {
        return this.cursoredQueryObjects;
    }

    public Vector getNormalQueryObjects() {
        return this.normalQueryObjects;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public int getSize() {
        return this.size;
    }

    public void setCursoredQueryObjects(Vector objects) {
        this.cursoredQueryObjects = objects;
    }

    public void setNormalQueryObjects(Vector objects) {
        this.normalQueryObjects = objects;
    }

    public void setReferenceClass(Class aClass) {
        this.referenceClass = aClass;
    }

    public void setSize(int aSize) {
        this.size = aSize;
    }

    protected void setup() {
        if (this.getSession().getPlatform().isDB2() || this.getSession().getPlatform().isAccess() || this.getSession().getPlatform().isTimesTen() || this.getSession().getPlatform().isSymfoware()) {
            throw new TestWarningException("ScrollableCursor is not supported on this platform.");
        }
        this.TYPE_SCROLL_INSENSITIVE_isSupported = true;
        this.CONCUR_UPDATABLE_isSupported = true;
        if (this.getSession().getPlatform().isSQLServer()) {
            this.TYPE_SCROLL_INSENSITIVE_isSupported = false;
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        this.setNormalQueryObjects(this.getSession().readAllObjects(this.getReferenceClass(), this.joinExpression));
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        ScrollableCursor cursor = null;
        try {
            this.cursoredQueryObjects = new Vector();
            query.setReferenceClass(this.getReferenceClass());
            query.setSelectionCriteria(this.joinExpression);
            if (this.TYPE_SCROLL_INSENSITIVE_isSupported && this.CONCUR_UPDATABLE_isSupported) {
                query.useScrollableCursor(2);
            } else {
                ScrollableCursorPolicy policy = new ScrollableCursorPolicy();
                if (!this.TYPE_SCROLL_INSENSITIVE_isSupported) {
                    policy.setResultSetType(1005);
                }
                if (!this.CONCUR_UPDATABLE_isSupported) {
                    policy.setResultSetConcurrency(1007);
                }
                policy.setPageSize(2);
                query.useScrollableCursor(policy);
            }
            cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
            ScrollableCursor cursor2 = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
            try {
                cursor2.next(5);
            }
            catch (QueryException ex) {
                // empty catch block
            }
            this.setSize(cursor2.size());
            cursor2.close();
            while (cursor.hasNext()) {
                Object databaseObject = cursor.next();
                this.getCursoredQueryObjects().addElement(databaseObject);
            }
            ReadAllQuery query3 = new ReadAllQuery(this.getReferenceClass());
            ScrollableCursorPolicy policy = new ScrollableCursorPolicy();
            policy.setResultSetType(1005);
            query3.useScrollableCursor(policy);
            ScrollableCursor cursor3 = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query3);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    protected void verify() {
        if (this.getNormalQueryObjects().size() != this.getCursoredQueryObjects().size()) {
            throw new TestErrorException("The number of streamed objects (" + this.getCursoredQueryObjects().size() + ") does not match the number of objects stored on the database (" + this.getNormalQueryObjects().size() + ") ");
        }
        if (this.getSize() != this.getNormalQueryObjects().size()) {
            throw new TestErrorException("The cursored stream size function is not working properly");
        }
    }
}

