/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReloadSelectionObjectTest
extends ReadObjectTest {
    private boolean shouldRefreshCache;
    private Object selectionObject;

    public ReloadSelectionObjectTest(Object originalObject) {
        this(originalObject, false);
    }

    public ReloadSelectionObjectTest(Object originalObject, boolean shouldRefreshCache) {
        super(originalObject);
        this.shouldRefreshCache = shouldRefreshCache;
        if (shouldRefreshCache) {
            this.setName("ReloadSelectionObjectTest read from DB");
        } else {
            this.setName("ReloadSelectionObjectTest read from Cache");
        }
    }

    public void reset() throws Throwable {
        super.reset();
        this.rollbackTransaction();
    }

    protected void setup() {
        super.setup();
        this.beginTransaction();
        this.getDatabaseSession().writeObject(this.originalObject);
        this.selectionObject = new Employee();
        ((Employee)this.selectionObject).setId(((Employee)this.originalObject).getId());
        if (this.shouldRefreshCache) {
            this.getSession().getIdentityMapAccessor().initializeIdentityMap(this.originalObject.getClass());
        }
        this.getQuery().loadResultIntoSelectionObject();
        this.getQuery().setSelectionObject(this.selectionObject);
    }

    protected void verify() {
        super.verify();
        if (this.objectFromDatabase != this.selectionObject) {
            throw new TestException("objects are not identical");
        }
        ObjectBuilder builder = this.getSession().getDescriptor(this.originalObject).getObjectBuilder();
        Object primaryKey = builder.extractPrimaryKeyFromObject(this.getOriginalObject(), this.getAbstractSession());
        if (this.getSession().getIdentityMapAccessor().getFromIdentityMap(primaryKey, this.originalObject.getClass()) == null) {
            throw new TestException("object was not put in the cache");
        }
        if (this.getSession().getIdentityMapAccessor().getFromIdentityMap(primaryKey, this.originalObject.getClass()) != this.selectionObject) {
            throw new TestException("object was not updated in the cache");
        }
    }
}

