/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Cubicle;
import org.eclipse.persistence.testing.tests.proxyindirection.DesktopComputerImpl;

public class InheritanceReadAllTest
extends AutoVerifyTestCase {
    Vector cubicles;

    public InheritanceReadAllTest() {
        this.setDescription("Tests ReadAllObjects using Proxy Indirection with target interfaces including super interfaces.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
    }

    public void test() {
        ReadAllQuery q = new ReadAllQuery();
        q.setReferenceClass(Cubicle.class);
        this.cubicles = (Vector)this.getSession().executeQuery((DatabaseQuery)q);
    }

    public void verify() {
        if (this.cubicles.size() != 3) {
            throw new TestErrorException("All Cubicles were not read in.  Expected 3, got " + this.cubicles.size() + ".");
        }
        for (int i = 0; i < this.cubicles.size(); ++i) {
            Cubicle c = (Cubicle)this.cubicles.elementAt(i);
            if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(DesktopComputerImpl.class).getSize() != i) {
                throw new TestErrorException("ProxyIndirection did not work - DesktopComputer was read in along with Cubicle.");
            }
            c.getComputer().getDescription();
            if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(DesktopComputerImpl.class).getSize() != i) continue;
            throw new TestErrorException("ProxyIndirection did not work - DesktopComputer was not read in when triggered from Cubicle.");
        }
    }
}

