/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadObjectvsParameterizedSQLTest
extends PerformanceComparisonTestCase {
    protected Employee employee;
    protected ReadObjectQuery bindQuery;
    protected ReadObjectQuery query;

    public ReadObjectvsParameterizedSQLTest() {
        this.setDescription("This test compares the performance of read object vs using parameterized SQL.");
        this.addReadObjectSameQueryTest();
        this.addReadObjectParameterizedSQLTest();
        this.addReadObjectParameterizedSQLSameQueryTest();
        this.addReadObjectPreparedStatementTest();
        this.addReadObjectDynamicTest();
    }

    public void setup() {
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        this.bindQuery = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        this.bindQuery.setSelectionCriteria(builder.get("firstName").equal(builder.getParameter("firstName")).and(builder.get("lastName").equal(builder.getParameter("lastName"))));
        this.bindQuery.addArgument("firstName");
        this.bindQuery.addArgument("lastName");
        this.bindQuery.bindAllParameters();
        this.bindQuery.cacheStatement();
        this.query = new ReadObjectQuery(Employee.class);
        builder = new ExpressionBuilder();
        this.query.setSelectionCriteria(builder.get("firstName").equal(builder.getParameter("firstName")).and(builder.get("lastName").equal(builder.getParameter("lastName"))));
        this.query.addArgument("firstName");
        this.query.addArgument("lastName");
    }

    public void test() throws Exception {
        this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)this.employee);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        query.setSelectionCriteria(builder.get("firstName").equal((Object)this.employee.getFirstName()).and(builder.get("lastName").equal((Object)this.employee.getLastName())));
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void addReadObjectSameQueryTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)ReadObjectvsParameterizedSQLTest.this.employee);
                Vector<String> arguments = new Vector<String>(2);
                arguments.add(ReadObjectvsParameterizedSQLTest.this.employee.getFirstName());
                arguments.add(ReadObjectvsParameterizedSQLTest.this.employee.getLastName());
                this.getSession().executeQuery((DatabaseQuery)ReadObjectvsParameterizedSQLTest.this.query, arguments);
            }
        };
        test.setName("ReadObjectSameQueryTest");
        this.addTest((TestCase)test);
    }

    public void addReadObjectParameterizedSQLTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)ReadObjectvsParameterizedSQLTest.this.employee);
                ReadObjectQuery query = new ReadObjectQuery(Employee.class);
                ExpressionBuilder builder = new ExpressionBuilder();
                query.setSelectionCriteria(builder.get("firstName").equal((Object)ReadObjectvsParameterizedSQLTest.this.employee.getFirstName()).and(builder.get("lastName").equal((Object)ReadObjectvsParameterizedSQLTest.this.employee.getLastName())));
                query.bindAllParameters();
                query.cacheStatement();
                this.getSession().executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("ReadObjectParameterizedSQLTest");
        test.setAllowableDecrease(30.0);
        this.addTest((TestCase)test);
    }

    public void addReadObjectParameterizedSQLSameQueryTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)ReadObjectvsParameterizedSQLTest.this.employee);
                Vector<String> arguments = new Vector<String>(2);
                arguments.add(ReadObjectvsParameterizedSQLTest.this.employee.getFirstName());
                arguments.add(ReadObjectvsParameterizedSQLTest.this.employee.getLastName());
                this.getSession().executeQuery((DatabaseQuery)ReadObjectvsParameterizedSQLTest.this.bindQuery, arguments);
            }
        };
        test.setName("ReadObjectParameterizedSQLSameQueryTest");
        test.setAllowableDecrease(40.0);
        this.addTest((TestCase)test);
    }

    public void addReadObjectPreparedStatementTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                DatabaseAccessor.shouldUseDynamicStatements = false;
                this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)ReadObjectvsParameterizedSQLTest.this.employee);
                ReadObjectQuery query = new ReadObjectQuery(Employee.class);
                query.dontBindAllParameters();
                ExpressionBuilder builder = new ExpressionBuilder();
                query.setSelectionCriteria(builder.get("firstName").equal((Object)ReadObjectvsParameterizedSQLTest.this.employee.getFirstName()).and(builder.get("lastName").equal((Object)ReadObjectvsParameterizedSQLTest.this.employee.getLastName())));
                this.getSession().executeQuery((DatabaseQuery)query);
                DatabaseAccessor.shouldUseDynamicStatements = true;
            }
        };
        test.setName("ReadObjectPreparedStatementTest");
        test.setAllowableDecrease(-30.0);
        this.addTest((TestCase)test);
    }

    public void addReadObjectDynamicTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)ReadObjectvsParameterizedSQLTest.this.employee);
                ReadObjectQuery query = new ReadObjectQuery(Employee.class);
                ExpressionBuilder builder = new ExpressionBuilder();
                query.setSelectionCriteria(builder.get("firstName").equal((Object)ReadObjectvsParameterizedSQLTest.this.employee.getFirstName()).and(builder.get("lastName").equal((Object)ReadObjectvsParameterizedSQLTest.this.employee.getLastName())));
                query.dontBindAllParameters();
                this.getSession().executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("ReadObjectDynamicTest");
        test.setAllowableDecrease(-20.0);
        this.addTest((TestCase)test);
    }
}

