/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.feature.MessageLoggingEfficiencyTestClass;

public class MessageLoggingEfficiencyTest
extends AutoVerifyTestCase {
    SessionLog oldLog;
    protected Exception caughtException = null;

    public MessageLoggingEfficiencyTest() {
        this.setDescription("Tests that Message Logging does not call toString on objects unless Debugging is enabled");
    }

    public void setup() {
        this.caughtException = null;
        this.oldLog = this.getSession().getSessionLog();
        DefaultSessionLog newLog = new DefaultSessionLog();
        newLog.setLevel(3);
        this.getSession().setSessionLog((SessionLog)newLog);
    }

    public void test() {
        Session s = this.getSession();
        UnitOfWork uow = s.acquireUnitOfWork();
        MessageLoggingEfficiencyTestClass testClass = new MessageLoggingEfficiencyTestClass();
        try {
            uow.registerNewObject((Object)testClass);
        }
        catch (TestErrorException tee) {
            this.caughtException = tee;
        }
        catch (ValidationException vE) {
            // empty catch block
        }
        try {
            uow.registerExistingObject((Object)testClass);
        }
        catch (TestErrorException tee) {
            this.caughtException = tee;
        }
        catch (ValidationException vE) {
            // empty catch block
        }
        try {
            uow.registerObject((Object)testClass);
        }
        catch (TestErrorException tee) {
            this.caughtException = tee;
        }
        catch (ValidationException vE) {
            // empty catch block
        }
        try {
            uow.mergeClone((Object)testClass);
        }
        catch (TestErrorException tee) {
            this.caughtException = tee;
        }
        catch (NullPointerException npE) {
            // empty catch block
        }
    }

    public void verify() throws Exception {
        if (this.caughtException != null) {
            throw this.caughtException;
        }
    }

    public void reset() {
        this.getSession().setSessionLog(this.oldLog);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

