/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import java.util.HashSet;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inheritance.AAA;
import org.eclipse.persistence.testing.models.jpa.inheritance.Bus;
import org.eclipse.persistence.testing.models.jpa.inheritance.Car;
import org.eclipse.persistence.testing.models.jpa.inheritance.Company;
import org.eclipse.persistence.testing.models.jpa.inheritance.ComputerPK;
import org.eclipse.persistence.testing.models.jpa.inheritance.DDD;
import org.eclipse.persistence.testing.models.jpa.inheritance.Desktop;
import org.eclipse.persistence.testing.models.jpa.inheritance.Engineer;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.Laptop;
import org.eclipse.persistence.testing.models.jpa.inheritance.PerformanceTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.Person;
import org.eclipse.persistence.testing.models.jpa.inheritance.SeniorEngineer;
import org.eclipse.persistence.testing.models.jpa.inheritance.SportsCar;
import org.eclipse.persistence.testing.models.jpa.inheritance.TireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.VehicleDirectory;

public class EntityManagerJUnitTestCase
extends JUnitTestCase {
    public EntityManagerJUnitTestCase() {
    }

    public EntityManagerJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EntityManagerJUnitTestCase.class);
        return suite;
    }

    public void testSetup() {
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistPolymorphicRelationship() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Person p = new Person();
        p.setName("Evil Knievel");
        SportsCar c = new SportsCar();
        c.setDescription("Ferrari");
        c.setMaxSpeed(200);
        p.setCar((Car)c);
        try {
            em.persist((Object)c);
            em.persist((Object)p);
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            EntityManagerJUnitTestCase.fail((String)("Error persisting polymorphic relationship: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testAssociationWithEmbeddedIdSubclassEntityInJoinedStrategy() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ComputerPK desktopPK;
            Desktop desktop;
            Engineer engineer = new Engineer();
            em.persist((Object)engineer);
            ComputerPK laptopPK = new ComputerPK("Dell", Integer.valueOf(10001));
            Laptop laptop = (Laptop)em.find(Laptop.class, (Object)laptopPK);
            if (laptop == null) {
                laptop = new Laptop(laptopPK);
                em.persist((Object)laptop);
            }
            if ((desktop = (Desktop)em.find(Desktop.class, (Object)(desktopPK = new ComputerPK("IBM", Integer.valueOf(10002))))) == null) {
                desktop = new Desktop(desktopPK);
                em.persist((Object)desktop);
            }
            engineer.getLaptops().add(laptop);
            engineer.getDesktops().add(desktop);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testUpateTireInfo() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        TireInfo tireInfo = new TireInfo();
        tireInfo.setPressure(Integer.valueOf(35));
        em.persist((Object)tireInfo);
        this.commitTransaction(em);
        this.beginTransaction(em);
        TireInfo localTire = (TireInfo)em.find(TireInfo.class, (Object)tireInfo.getId());
        EntityManagerJUnitTestCase.assertTrue((String)"TireInfo was not persisted with the proper pressure", (boolean)localTire.getPressure().equals(35));
        localTire.setPressure(Integer.valueOf(40));
        this.commitTransaction(em);
        em.clear();
        localTire = (TireInfo)em.find(TireInfo.class, (Object)tireInfo.getId());
        EntityManagerJUnitTestCase.assertTrue((String)"TireInfo was not updated", (boolean)localTire.getPressure().equals(40));
    }

    public void testMapKeyInheritance() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        VehicleDirectory directory = new VehicleDirectory();
        directory.setName("MyVehicles");
        em.persist((Object)directory);
        Company company = new Company();
        company.setName("A Blue Company");
        em.persist((Object)company);
        em.flush();
        Car car = new Car();
        car.setDescription("a Blue Car");
        car.setOwner(company);
        em.persist((Object)car);
        directory.getVehicleDirectory().put(car.getOwner(), car);
        company.getVehicles().add(car);
        try {
            em.flush();
        }
        catch (RuntimeException e) {
            EntityManagerJUnitTestCase.fail((String)("Exception was thrown while flushing a MapKey with inheritance. " + e.getMessage()));
        }
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveInheritedManyToMany() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            SeniorEngineer eng = new SeniorEngineer();
            eng.setName("Vela");
            em.persist((Object)eng);
            Laptop laptop = new Laptop();
            ComputerPK pk = new ComputerPK("Dell", Integer.valueOf(2111));
            laptop.setComputerPK(pk);
            em.persist((Object)laptop);
            eng.getLaptops().add(laptop);
            em.flush();
            em.remove((Object)eng);
            em.flush();
        }
        catch (PersistenceException ex) {
            if (ex.getCause() instanceof DatabaseException) {
                EntityManagerJUnitTestCase.fail((String)"SQLException thrown when removing an object that inherits a ManyToMany");
            } else {
                EntityManagerJUnitTestCase.fail((String)"UnexpectedException thrown");
            }
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGenericCollectionOnSuperclass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Bus bus = new Bus();
            bus.setDescription("a fast bus");
            PerformanceTireInfo tire = new PerformanceTireInfo();
            tire.setPressure(Integer.valueOf(100));
            bus.getTires().add(tire);
            em.persist((Object)bus);
            em.flush();
            em.clear();
            this.clearCache();
            bus = (Bus)em.find(Bus.class, (Object)bus.getId());
            EntityManagerJUnitTestCase.assertNotNull((String)"Bus is null.", (Object)bus);
            EntityManagerJUnitTestCase.assertTrue((String)"Bus has no tires.", (bus.getTires().size() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddToUninstantiatedSet() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        AAA a = new AAA();
        em.persist((Object)a);
        DDD d = new DDD();
        em.persist((Object)d);
        HashSet<DDD> ds = new HashSet<DDD>();
        ds.add(d);
        a.setDdds(ds);
        d.setAaa(a);
        this.commitTransaction(em);
        this.clearCache();
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            a = (AAA)em.getReference(AAA.class, (Object)a.getId());
            a.getDdds().add(d);
            d.setAaa(a);
            this.commitTransaction(em);
            EntityManagerJUnitTestCase.assertTrue((String)"The collection contains too many elements", (a.getDdds().size() == 1 ? 1 : 0) != 0);
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            a = (AAA)em.find(AAA.class, (Object)a.getId());
            d = (DDD)em.find(DDD.class, (Object)d.getId());
            em.remove((Object)a);
            em.remove((Object)d);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazySetInstantiationLazy() {
        if (!this.isWeavingEnabled()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        CollectionMapping mapping = (CollectionMapping)EntityManagerJUnitTestCase.getServerSession().getProject().getClassDescriptor(AAA.class).getMappingForAttributeName("ddds");
        Boolean lazyIndirection = mapping.shouldUseLazyInstantiationForIndirectCollection();
        mapping.setUseLazyInstantiationForIndirectCollection(Boolean.valueOf(true));
        this.beginTransaction(em);
        AAA a = new AAA();
        em.persist((Object)a);
        DDD d = new DDD();
        em.persist((Object)d);
        HashSet<DDD> ds = new HashSet<DDD>();
        ds.add(d);
        a.setDdds(ds);
        d.setAaa(a);
        this.commitTransaction(em);
        this.clearCache();
        try {
            em = this.createEntityManager();
            a = (AAA)em.find(AAA.class, (Object)a.getId());
            a.getDdds().add(new DDD());
            EntityManagerJUnitTestCase.assertTrue((String)"Lazy instantiation was not enabled for IndirectSet.", (((IndirectSet)a.getDdds()).getAddedElements().size() == 1 ? 1 : 0) != 0);
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            a = (AAA)em.find(AAA.class, (Object)a.getId());
            d = (DDD)em.find(DDD.class, (Object)d.getId());
            em.remove((Object)a);
            em.remove((Object)d);
            this.commitTransaction(em);
            mapping.setUseLazyInstantiationForIndirectCollection(lazyIndirection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazySetInstantiationEager() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        AAA a = new AAA();
        em.persist((Object)a);
        DDD d = new DDD();
        em.persist((Object)d);
        HashSet<DDD> ds = new HashSet<DDD>();
        ds.add(d);
        a.setDdds(ds);
        d.setAaa(a);
        this.commitTransaction(em);
        this.clearCache();
        try {
            em = this.createEntityManager();
            a = (AAA)em.find(AAA.class, (Object)a.getId());
            a.getDdds().add(new DDD());
            EntityManagerJUnitTestCase.assertTrue((String)"Lazy instantiation was not disabled for IndirectSet.", (((IndirectSet)a.getDdds()).getAddedElements().size() == 0 ? 1 : 0) != 0);
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            a = (AAA)em.find(AAA.class, (Object)a.getId());
            d = (DDD)em.find(DDD.class, (Object)d.getId());
            em.remove((Object)a);
            em.remove((Object)d);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyListInstantiationLazy() {
        if (!this.isWeavingEnabled()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("ListCo");
        em.persist((Object)company);
        Car car = new Car();
        em.persist((Object)car);
        company.getVehicles().add(car);
        car.setOwner(company);
        this.commitTransaction(em);
        this.clearCache();
        try {
            em = this.createEntityManager();
            company = (Company)em.find(Company.class, (Object)company.getId());
            company.getVehicles().add(new Car());
            EntityManagerJUnitTestCase.assertTrue((String)"Lazy instantiation was not enabled for IndirectList.", (((IndirectList)company.getVehicles()).getAddedElements().size() == 1 ? 1 : 0) != 0);
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            company = (Company)em.find(Company.class, (Object)company.getId());
            car = (Car)em.find(Car.class, (Object)car.getId());
            em.remove((Object)company);
            em.remove((Object)car);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyListInstantiationEager() {
        EntityManager em = this.createEntityManager();
        CollectionMapping mapping = (CollectionMapping)EntityManagerJUnitTestCase.getServerSession().getProject().getClassDescriptor(Company.class).getMappingForAttributeName("vehicles");
        Boolean lazyIndirection = mapping.shouldUseLazyInstantiationForIndirectCollection();
        mapping.setUseLazyInstantiationForIndirectCollection(Boolean.valueOf(false));
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("ListCo");
        em.persist((Object)company);
        Car car = new Car();
        em.persist((Object)car);
        company.getVehicles().add(car);
        car.setOwner(company);
        this.commitTransaction(em);
        this.clearCache();
        try {
            em = this.createEntityManager();
            company = (Company)em.find(Company.class, (Object)company.getId());
            company.getVehicles().add(new Car());
            EntityManagerJUnitTestCase.assertTrue((String)"Lazy instantiation was not disabled for IndirectList.", (((IndirectList)company.getVehicles()).getAddedElements().size() == 0 ? 1 : 0) != 0);
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            company = (Company)em.find(Company.class, (Object)company.getId());
            car = (Car)em.find(Car.class, (Object)car.getId());
            em.remove((Object)company);
            em.remove((Object)car);
            this.commitTransaction(em);
            mapping.setUseLazyInstantiationForIndirectCollection(lazyIndirection);
        }
    }
}

