/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups.BaseFetchGroupTests;

public class NestedNamedFetchGroupTests
extends BaseFetchGroupTests {
    public NestedNamedFetchGroupTests() {
    }

    public NestedNamedFetchGroupTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("NestedNamedFetchGroupTests");
        suite.addTest((Test)new NestedNamedFetchGroupTests("testSetup"));
        suite.addTest((Test)new NestedNamedFetchGroupTests("dynamicFetchGroup_EmployeeAddress"));
        suite.addTest((Test)new NestedNamedFetchGroupTests("dynamicFetchGroup_Employee_NullAddress"));
        suite.addTest((Test)new NestedNamedFetchGroupTests("dynamicFetchGroup_EmployeeAddressNullPhone"));
        suite.addTest((Test)new NestedNamedFetchGroupTests("dynamicFetchGroup_EmployeeAddressEmptyPhone"));
        suite.addTest((Test)new NestedNamedFetchGroupTests("dynamicHierarchicalFetchGroup"));
        return suite;
    }

    @Override
    public void setUp() {
        super.setUp();
        try {
            new BaseFetchGroupTests.PhoneCustomizer().customize(this.phoneDescriptor);
            this.reprepareReadQueries(this.employeeDescriptor);
            this.reprepareReadQueries(this.phoneDescriptor);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        NestedNamedFetchGroupTests.assertConfig(this.phoneDescriptor, defaultPhoneFG, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void dynamicFetchGroup_EmployeeAddress() throws Exception {
        EntityManager em = NestedNamedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Male);
            FetchGroup fg = new FetchGroup();
            fg.addAttribute("firstName");
            fg.addAttribute("lastName");
            fg.addAttribute("address");
            fg.addAttribute("address.city");
            fg.addAttribute("address.postalCode");
            query.setHint("eclipselink.fetch-group", (Object)fg);
            List emps = query.getResultList();
            NestedNamedFetchGroupTests.assertNotNull((Object)emps);
            for (Employee emp : emps) {
                FetchGroupTracker tracker = (FetchGroupTracker)emp;
                NestedNamedFetchGroupTests.assertNotNull((Object)tracker._persistence_getFetchGroup());
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("endTime"));
                emp.getSalary();
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("endTime"));
                FetchGroupTracker addrTracker = (FetchGroupTracker)emp.getAddress();
                NestedNamedFetchGroupTests.assertNotNull((String)"Address does not have a FetchGroup", (Object)addrTracker._persistence_getFetchGroup());
                NestedNamedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("city"));
                NestedNamedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("postalCode"));
                NestedNamedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("street"));
                NestedNamedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("country"));
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    FetchGroupTracker phoneTracker = (FetchGroupTracker)phone;
                    NestedNamedFetchGroupTests.assertNotNull((String)"PhoneNumber does not have a FetchGroup", (Object)phoneTracker._persistence_getFetchGroup());
                    NestedNamedFetchGroupTests.assertTrue((boolean)phoneTracker._persistence_isAttributeFetched("number"));
                    NestedNamedFetchGroupTests.assertFalse((boolean)phoneTracker._persistence_isAttributeFetched("areaCode"));
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @org.junit.Test
    public void dynamicFetchGroup_Employee_NullAddress() throws Exception {
        EntityManager em = NestedNamedFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
        query.setParameter("GENDER", (Object)Employee.Gender.Male);
        FetchGroup empGroup = new FetchGroup();
        empGroup.addAttribute("firstName");
        empGroup.addAttribute("lastName");
        empGroup.addAttribute("address");
        FetchGroup addressGroup = new FetchGroup();
        addressGroup.addAttribute("city");
        addressGroup.addAttribute("postalCode");
        empGroup.addAttribute("address");
        query.setHint("eclipselink.fetch-group", (Object)empGroup);
        List emps = query.getResultList();
        NestedNamedFetchGroupTests.assertNotNull((Object)emps);
        for (Employee emp : emps) {
            FetchGroupTracker tracker = (FetchGroupTracker)emp;
            NestedNamedFetchGroupTests.assertNotNull((Object)tracker._persistence_getFetchGroup());
            NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
            NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
            NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
            NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
            NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
            NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("startTime"));
            NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("endTime"));
            emp.getSalary();
            NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("salary"));
            NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("startTime"));
            NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("endTime"));
            FetchGroupTracker addrTracker = (FetchGroupTracker)emp.getAddress();
            NestedNamedFetchGroupTests.assertNull((String)"Address has an unexpected FetchGroup", (Object)addrTracker._persistence_getFetchGroup());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                FetchGroupTracker phoneTracker = (FetchGroupTracker)phone;
                NestedNamedFetchGroupTests.assertNotNull((String)"PhoneNumber does not have a FetchGroup", (Object)phoneTracker._persistence_getFetchGroup());
                NestedNamedFetchGroupTests.assertTrue((boolean)phoneTracker._persistence_isAttributeFetched("number"));
                NestedNamedFetchGroupTests.assertFalse((boolean)phoneTracker._persistence_isAttributeFetched("areaCode"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void dynamicFetchGroup_EmployeeAddressNullPhone() throws Exception {
        EntityManager em = NestedNamedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Male);
            FetchGroup empGroup = new FetchGroup();
            empGroup.addAttribute("firstName");
            empGroup.addAttribute("lastName");
            empGroup.addAttribute("address");
            FetchGroup addressGroup = new FetchGroup();
            addressGroup.addAttribute("city");
            addressGroup.addAttribute("postalCode");
            empGroup.addAttribute("address", addressGroup);
            FetchGroup fullPhone = this.phoneDescriptor.getFetchGroupManager().createFullFetchGroup();
            fullPhone.addAttribute("owner.id");
            empGroup.addAttribute("phoneNumbers", fullPhone);
            query.setHint("eclipselink.fetch-group", (Object)empGroup);
            List emps = query.getResultList();
            NestedNamedFetchGroupTests.assertNotNull((Object)emps);
            for (Employee emp : emps) {
                FetchGroupTracker tracker = (FetchGroupTracker)emp;
                NestedNamedFetchGroupTests.assertNotNull((Object)tracker._persistence_getFetchGroup());
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("endTime"));
                emp.getSalary();
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("endTime"));
                FetchGroupTracker addrTracker = (FetchGroupTracker)emp.getAddress();
                NestedNamedFetchGroupTests.assertNotNull((String)"Address does not have a FetchGroup", (Object)addrTracker._persistence_getFetchGroup());
                NestedNamedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("city"));
                NestedNamedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("postalCode"));
                NestedNamedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("street"));
                NestedNamedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("country"));
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    FetchGroupTracker phoneTracker = (FetchGroupTracker)phone;
                    NestedNamedFetchGroupTests.assertNull((String)"PhoneNumber has a FetchGroup", (Object)phoneTracker._persistence_getFetchGroup());
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void dynamicFetchGroup_EmployeeAddressEmptyPhone() throws Exception {
        EntityManager em = NestedNamedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Male);
            FetchGroup empGroup = new FetchGroup();
            empGroup.addAttribute("firstName");
            empGroup.addAttribute("lastName");
            empGroup.addAttribute("address");
            FetchGroup addressGroup = new FetchGroup();
            addressGroup.addAttribute("city");
            addressGroup.addAttribute("postalCode");
            empGroup.addAttribute("address", addressGroup);
            FetchGroup ownerId = new FetchGroup();
            ownerId.addAttribute("owner.id");
            empGroup.addAttribute("phoneNumbers", ownerId);
            query.setHint("eclipselink.fetch-group", (Object)empGroup);
            List emps = query.getResultList();
            NestedNamedFetchGroupTests.assertNotNull((Object)emps);
            for (Employee emp : emps) {
                FetchGroupTracker tracker = (FetchGroupTracker)emp;
                NestedNamedFetchGroupTests.assertNotNull((Object)tracker._persistence_getFetchGroup());
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("endTime"));
                emp.getSalary();
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("endTime"));
                FetchGroupTracker addrTracker = (FetchGroupTracker)emp.getAddress();
                NestedNamedFetchGroupTests.assertNotNull((String)"Address does not have a FetchGroup", (Object)addrTracker._persistence_getFetchGroup());
                NestedNamedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("city"));
                NestedNamedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("postalCode"));
                NestedNamedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("street"));
                NestedNamedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("country"));
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    FetchGroupTracker phoneTracker = (FetchGroupTracker)phone;
                    NestedNamedFetchGroupTests.assertNotNull((String)"PhoneNumber does not have a FetchGroup", (Object)phoneTracker._persistence_getFetchGroup());
                    NestedNamedFetchGroupTests.assertFalse((boolean)phoneTracker._persistence_isAttributeFetched("number"));
                    NestedNamedFetchGroupTests.assertFalse((boolean)phoneTracker._persistence_isAttributeFetched("areaCode"));
                    phone.getNumber();
                    NestedNamedFetchGroupTests.assertTrue((boolean)phoneTracker._persistence_isAttributeFetched("number"));
                    NestedNamedFetchGroupTests.assertTrue((boolean)phoneTracker._persistence_isAttributeFetched("areaCode"));
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @org.junit.Test
    public void dynamicHierarchicalFetchGroup() throws Exception {
        EntityManager em = NestedNamedFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
        query.setParameter("GENDER", (Object)Employee.Gender.Male);
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("firstName");
        fg.addAttribute("lastName");
        fg.addAttribute("salary");
        fg.addAttribute("gender");
        fg.addAttribute("manager.firstName");
        fg.addAttribute("manager.lastName");
        fg.addAttribute("manager.salary");
        fg.addAttribute("manager.gender");
        fg.addAttribute("manager.manager.firstName");
        fg.addAttribute("manager.manager.lastName");
        fg.addAttribute("manager.manager.salary");
        fg.addAttribute("manager.manager.gender");
        AttributeItem mgrItem = fg.getItem("manager");
        NestedNamedFetchGroupTests.assertNotNull((Object)mgrItem);
        NestedNamedFetchGroupTests.assertNotNull((Object)mgrItem.getGroup());
        AttributeItem mgrMgrItem = fg.getItem("manager.manager");
        NestedNamedFetchGroupTests.assertNotNull((Object)mgrMgrItem);
        NestedNamedFetchGroupTests.assertNotNull((Object)mgrMgrItem.getGroup());
        query.setHint("eclipselink.fetch-group", (Object)fg);
        List emps = query.getResultList();
        int numSelect = this.getQuerySQLTracker(em).getTotalSQLSELECTCalls();
        ArrayList<Employee> loadedEmps = new ArrayList<Employee>();
        loadedEmps.addAll(emps);
        for (Employee emp : emps) {
            if (!loadedEmps.contains(emp)) {
                NestedNamedFetchGroupTests.assertFetched((Object)emp, fg);
            }
            NestedNamedFetchGroupTests.assertNotFetchedAttribute(emp, "startDate");
            loadedEmps.add(emp);
        }
    }
}

