/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.HashMap;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMRemoveAndFlushTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];
    public Integer[] projIDs = new Integer[3];
    public HashMap persistedItems = new HashMap(4);

    public EMRemoveAndFlushTest() {
        this.setDescription("Test remove and flush in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        this.persistedItems.clear();
        Employee employee = ModelExamples.employeeExample1();
        Project project = ModelExamples.projectExample1();
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)employee);
            this.getEntityManager().persist((Object)project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
        this.empIDs[0] = employee.getId();
        this.projIDs[0] = project.getId();
    }

    public void test() {
        try {
            this.beginTransaction();
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            this.getEntityManager().remove((Object)employee);
            Project project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
            this.getEntityManager().remove((Object)project);
            this.getEntityManager().flush();
            ((JpaEntityManager)this.getEntityManager()).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.getEntityManager().clear();
            this.persistedItems.put("after flush Employee", this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]));
            this.persistedItems.put("after flush Project", this.getEntityManager().find(Project.class, (Object)this.projIDs[0]));
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
    }

    public void verify() {
        if (this.persistedItems.get("after flush Employee") != null) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " was not deleted");
        }
        if (this.persistedItems.get("after flush Project") != null) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " was not deleted");
        }
    }
}

