/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class JoinedAttributeTestHelper {
    public static String executeQueriesAndCompareResults(ObjectLevelReadQuery controlQuery, ObjectLevelReadQuery queryWithJoins, AbstractSession session) {
        session.logMessage("JoinedAttributeTestHelper: executing queryWithJoins:");
        session.getIdentityMapAccessor().initializeAllIdentityMaps();
        Object result = session.executeQuery((DatabaseQuery)queryWithJoins);
        session.logMessage("JoinedAttributeTestHelper: getting control result:");
        Object controlResult = JoinedAttributeTestHelper.getControlResultsFromControlQuery(controlQuery, queryWithJoins, session);
        String errorMsg = "";
        errorMsg = controlResult instanceof Collection ? JoinedAttributeTestHelper.compareCollections((Collection)controlResult, (Collection)result, controlQuery.getDescriptor(), session) : JoinedAttributeTestHelper.compareObjects(controlResult, result, session);
        return errorMsg;
    }

    public static Object getControlResultsFromControlQuery(ObjectLevelReadQuery controlQuery, ObjectLevelReadQuery queryWithJoins, AbstractSession session) {
        int valueHolderPolicy = 1;
        session.getIdentityMapAccessor().initializeAllIdentityMaps();
        Object controlResult = session.executeQuery((DatabaseQuery)controlQuery);
        boolean isCollection = false;
        Collection<Object> collectionResult = null;
        if (controlResult instanceof Collection) {
            collectionResult = (Vector<Object>)controlResult;
            isCollection = true;
        } else {
            collectionResult = new Vector<Object>(1);
            collectionResult.add(controlResult);
        }
        HashSet<CacheKey> excluded = new HashSet<CacheKey>();
        for (Object e : collectionResult) {
            boolean remove = false;
            for (Expression joinExpression : queryWithJoins.getJoinedAttributeManager().getJoinedAttributeExpressions()) {
                QueryKeyExpression queryKeyExpression;
                joinExpression.getBuilder().setSession(session);
                joinExpression.getBuilder().setQueryClass(queryWithJoins.getReferenceClass());
                Object value = joinExpression.valueFromObject(e, session, null, valueHolderPolicy, false);
                if (!joinExpression.isQueryKeyExpression() || (queryKeyExpression = (QueryKeyExpression)joinExpression).shouldUseOuterJoin()) continue;
                if (value == null) {
                    remove = true;
                    break;
                }
                if (!(value instanceof Collection)) continue;
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    remove = true;
                    break;
                }
                if (queryKeyExpression.shouldQueryToManyRelationship()) continue;
                Iterator collectionIterator = collection.iterator();
                while (collectionIterator.hasNext()) {
                    if (collectionIterator.next() != null) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                break;
            }
            if (!remove) continue;
            excluded.add(new CacheKey(session.getId(e)));
        }
        session.getIdentityMapAccessor().initializeAllIdentityMaps();
        controlResult = session.executeQuery((DatabaseQuery)controlQuery);
        isCollection = false;
        collectionResult = null;
        if (controlResult instanceof Collection) {
            collectionResult = (Collection)controlResult;
            isCollection = true;
        } else {
            collectionResult = new Vector(1);
            collectionResult.add(controlResult);
        }
        Iterator iterator = collectionResult.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (excluded.contains(new CacheKey(session.getId(e)))) {
                iterator.remove();
                continue;
            }
            for (Expression joinExpression : queryWithJoins.getJoinedAttributeManager().getJoinedAttributeExpressions()) {
                joinExpression.valueFromObject(e, session, null, valueHolderPolicy, false);
            }
        }
        session.getIdentityMapAccessor().initializeAllIdentityMaps();
        if (isCollection) {
            return collectionResult;
        }
        return controlResult;
    }

    public static String compareCollections(Collection col1, Collection col2, ClassDescriptor desc, AbstractSession session) {
        IdentityHashMap processed = new IdentityHashMap();
        return JoinedAttributeTestHelper.compareCollections(col1, col2, desc, session, processed);
    }

    public static String compareObjects(Object obj1, Object obj2, AbstractSession session) {
        IdentityHashMap processed = new IdentityHashMap();
        return JoinedAttributeTestHelper.compareObjects(obj1, obj2, session, processed);
    }

    protected static String compareCollections(Collection col1, Collection col2, ClassDescriptor desc, AbstractSession session, Map processed) {
        if (col1 == null && col2 == null) {
            return "";
        }
        String errorMsg = "";
        if (col1 != null) {
            if (processed.containsKey(col1)) {
                return "";
            }
            processed.put(col1, col1);
            if (col2 == null) {
                errorMsg = ": " + col1.toString() + "!= null ;  ";
                return errorMsg;
            }
        }
        if (col2 != null) {
            if (processed.containsKey(col2)) {
                return "";
            }
            processed.put(col2, col2);
            if (col1 == null) {
                errorMsg = ": null !=" + col2.toString() + ";  ";
                return errorMsg;
            }
        }
        if (col1.size() != col2.size()) {
            errorMsg = ": size1==" + Integer.toString(col1.size()) + "!= size2==" + Integer.toString(col2.size()) + ";  ";
            return errorMsg;
        }
        if (desc != null) {
            HashMap map1 = new HashMap(col1.size());
            HashMap map2 = new HashMap(col2.size());
            ObjectBuilder builder = desc.getObjectBuilder();
            Iterator it1 = col1.iterator();
            Iterator it2 = col2.iterator();
            while (it1.hasNext()) {
                Object obj1 = it1.next();
                Object obj2 = it2.next();
                Object pk1 = builder.extractPrimaryKeyFromObject(obj1, session);
                Object pk2 = builder.extractPrimaryKeyFromObject(obj2, session);
                map1.put(pk1, obj1);
                map2.put(pk2, obj2);
            }
            for (Map.Entry entry : map1.entrySet()) {
                Object obj2;
                Object pk = entry.getKey();
                Object obj1 = entry.getValue();
                String objErrorMsg = JoinedAttributeTestHelper.compareObjects(obj1, obj2 = map2.get(pk), session, processed);
                if (objErrorMsg.length() <= 0) continue;
                errorMsg = errorMsg + "PK = " + pk.toString() + ": " + Helper.getShortClassName(obj1.getClass()) + objErrorMsg + "  ";
            }
        } else if (!((Object)col1).equals(col2)) {
            errorMsg = errorMsg + "Collections " + col1.toString() + " and " + col2.toString() + " are not equal; ";
        }
        return errorMsg;
    }

    protected static String compareMaps(Map map1, Map map2, AbstractSession session, Map processed) {
        if (map1 == null && map2 == null) {
            return "";
        }
        String errorMsg = "";
        if (map1 != null) {
            if (processed.containsKey(map1)) {
                return "";
            }
            processed.put(map1, map1);
            if (map2 == null) {
                errorMsg = ": " + map1.toString() + "!= null ;  ";
                return errorMsg;
            }
        }
        if (map2 != null) {
            if (processed.containsKey(map2)) {
                return "";
            }
            processed.put(map2, map2);
            if (map1 == null) {
                errorMsg = ": null !=" + map2.toString() + ";  ";
                return errorMsg;
            }
        }
        if (map1.size() != map2.size()) {
            errorMsg = ": size1==" + Integer.toString(map1.size()) + "!= size2==" + Integer.toString(map2.size()) + ";  ";
            return errorMsg;
        }
        for (Map.Entry entry : map1.entrySet()) {
            Object obj2;
            Object key = entry.getKey();
            Object obj1 = entry.getValue();
            String objErrorMsg = JoinedAttributeTestHelper.compareObjects(obj1, obj2 = map2.get(key), session, processed);
            if (objErrorMsg.length() <= 0) continue;
            errorMsg = errorMsg + "Key = " + key.toString() + ": " + Helper.getShortClassName(obj1.getClass()) + objErrorMsg + "  ";
        }
        return errorMsg;
    }

    protected static String compareObjects(Object obj1, Object obj2, AbstractSession session, Map processed) {
        if (obj1 == null && obj2 == null) {
            return "";
        }
        String errorMsg = "";
        if (obj1 != null) {
            if (processed.containsKey(obj1)) {
                return "";
            }
            processed.put(obj1, obj1);
            if (obj2 == null) {
                errorMsg = ": " + obj1.toString() + "!= null;  ";
                return errorMsg;
            }
        }
        if (obj2 != null) {
            if (processed.containsKey(obj2)) {
                return "";
            }
            processed.put(obj2, obj2);
            if (obj1 == null) {
                errorMsg = ": null !=" + obj2.toString() + ";  ";
                return errorMsg;
            }
        }
        if (obj1.getClass() != obj2.getClass()) {
            errorMsg = ": " + obj1.getClass().getName() + "!=" + obj2.getClass().getName() + "; ";
            return errorMsg;
        }
        ClassDescriptor desc = session.getDescriptor(obj1);
        if (desc == null) {
            if (!obj1.equals(obj2)) {
                errorMsg = ": " + obj1.toString() + "!=" + obj2.toString() + ";  ";
            }
            return errorMsg;
        }
        Vector mappings = desc.getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            String mappingErrorMsg = JoinedAttributeTestHelper.compareAttributes(obj1, obj2, mapping, session, processed);
            errorMsg = errorMsg + mappingErrorMsg;
        }
        return errorMsg;
    }

    protected static String compareAttributes(Object obj1, Object obj2, DatabaseMapping mapping, AbstractSession session, Map processed) {
        String errorMsg = "";
        if (mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping frm = (ForeignReferenceMapping)mapping;
            Object value1 = frm.getAttributeValueFromObject(obj1);
            Object value2 = frm.getAttributeValueFromObject(obj2);
            boolean isInstantiated1 = frm.getIndirectionPolicy().objectIsInstantiated(value1);
            boolean isInstantiated2 = frm.getIndirectionPolicy().objectIsInstantiated(value2);
            if (!isInstantiated1 && !isInstantiated2) {
                return "";
            }
            if (isInstantiated1 && !isInstantiated2) {
                if (!frm.isOneToOneMapping() || !(value1 instanceof ValueHolder) || ((ValueHolder)value1).getValue() != null) {
                    errorMsg = ":  indirection instantiated != indirection NOT instantiated; ";
                }
            } else if (!isInstantiated1 && isInstantiated2) {
                if (!frm.isOneToOneMapping() || !(value2 instanceof ValueHolder) || ((ValueHolder)value2).getValue() != null) {
                    errorMsg = ": indirection NOT instantiated != indirection instantiated; ";
                }
            } else {
                Class containerClass;
                value1 = frm.getRealAttributeValueFromObject(obj1, session);
                value2 = frm.getRealAttributeValueFromObject(obj2, session);
                errorMsg = frm.isCollectionMapping() ? (Collection.class.isAssignableFrom(containerClass = ((CollectionMapping)frm).getContainerPolicy().getContainerClass()) ? errorMsg + JoinedAttributeTestHelper.compareCollections((Collection)value1, (Collection)value2, frm.getReferenceDescriptor(), session, processed) : (Map.class.isAssignableFrom(containerClass) ? errorMsg + JoinedAttributeTestHelper.compareMaps((Map)value1, (Map)value2, session, processed) : errorMsg + mapping.toString() + " container class implements neither Collection nor Map - can't processl; ")) : errorMsg + JoinedAttributeTestHelper.compareObjects(value1, value2, session, processed);
            }
        } else if (!mapping.compareObjects(obj1, obj2, session)) {
            Object value2;
            Object value1 = mapping.getAttributeValueFromObject(obj1);
            if (value1 == null) {
                value1 = new String("null");
            }
            if ((value2 = mapping.getAttributeValueFromObject(obj2)) == null) {
                value2 = new String("null");
            }
            errorMsg = ": " + value1.toString() + "!=" + value2.toString() + "; ";
        }
        if (errorMsg.length() > 0) {
            errorMsg = "." + mapping.getAttributeName() + errorMsg;
        }
        return errorMsg;
    }
}

