/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.channel;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.jms.Activator;
import org.eclipse.ecf.provider.comm.AsynchEvent;
import org.eclipse.ecf.provider.comm.ConnectionEvent;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.IConnectionListener;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.jms.channel.ECFMessage;
import org.eclipse.ecf.provider.jms.channel.JMSMessage;
import org.eclipse.ecf.provider.jms.channel.JmsTopicSession;
import org.eclipse.ecf.provider.jms.channel.SynchRequestMessage;
import org.eclipse.ecf.provider.jms.channel.SynchResponseMessage;
import org.eclipse.ecf.provider.jms.identity.JMSID;

public abstract class AbstractJMSChannel
extends SocketAddress
implements ISynchAsynchConnection {
    private static final long serialVersionUID = 4516462369458730752L;
    private static long correlationID = 0L;
    protected Connection connection = null;
    protected Session session = null;
    protected JmsTopicSession jmsTopicSession = null;
    protected ID localContainerID;
    private boolean started = false;
    protected ISynchAsynchEventHandler handler;
    protected int keepAlive = -1;
    private Map properties = new HashMap();
    protected List<IConnectionListener> connectionListeners = new ArrayList<IConnectionListener>();
    protected boolean isStopping = false;
    protected Object waitResponse = new Object();
    protected String correlation = null;
    protected Serializable reply = null;
    protected boolean waitDone;

    public AbstractJMSChannel(ISynchAsynchEventHandler hand, int keepAlive, Map properties) {
        this.handler = hand;
        Assert.isNotNull((Object)this.handler);
        this.localContainerID = hand.getEventHandlerID();
        Assert.isNotNull((Object)this.localContainerID);
        this.keepAlive = keepAlive;
        if (properties != null) {
            this.properties = properties;
        }
    }

    public AbstractJMSChannel(ISynchAsynchEventHandler hand, int keepAlive) {
        this(hand, keepAlive, null);
    }

    public abstract Object connect(ID var1, Object var2, int var3) throws ECFException;

    public abstract Object sendSynch(ID var1, byte[] var2) throws IOException;

    protected abstract ConnectionFactory createJMSConnectionFactory(JMSID var1) throws IOException;

    protected abstract void handleSynchRequest(String var1, ECFMessage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireListenersConnect(ConnectionEvent event) {
        ArrayList<IConnectionListener> toNotify = null;
        List<IConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            toNotify = new ArrayList<IConnectionListener>(this.connectionListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            ((IConnectionListener)i.next()).handleConnectEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireListenersDisconnect(ConnectionEvent event) {
        ArrayList<IConnectionListener> toNotify = null;
        List<IConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            toNotify = new ArrayList<IConnectionListener>(this.connectionListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            ((IConnectionListener)i.next()).handleConnectEvent(event);
        }
    }

    public ID getLocalID() {
        return this.localContainerID;
    }

    protected boolean isActive() {
        return this.isConnected() && this.isStarted() && !this.isStopping();
    }

    protected void onJMSException(JMSException except) {
        if (this.isActive()) {
            this.handler.handleDisconnectEvent(new DisconnectEvent((IAsynchConnection)this, (Throwable)except, null));
        }
    }

    protected boolean isStopping() {
        return this.isStopping;
    }

    protected Serializable createConnectRequestData(Object data) {
        if (data instanceof Serializable) {
            return (Serializable)data;
        }
        return null;
    }

    protected Serializable setupJMS(JMSID targetID, Object data) throws ECFException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"setupJMS");
        try {
            ConnectionFactory factory = this.createJMSConnectionFactory(targetID);
            this.connection = factory.createConnection();
            this.connection.setClientID(this.getLocalID().getName());
            this.connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException arg0) {
                    AbstractJMSChannel.this.onJMSException(arg0);
                }
            });
            this.session = this.connection.createSession(false, 1);
            this.jmsTopicSession = new JmsTopicSession(this.session, targetID.getTopicOrQueueName());
            this.jmsTopicSession.getConsumer().setMessageListener((MessageListener)new TopicReceiver());
            this.isStopping = false;
            this.connection.start();
            Serializable connectData = this.createConnectRequestData(data);
            Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"setup", (Object)connectData);
            return connectData;
        }
        catch (Exception e) {
            this.disconnect();
            Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/throwing", this.getClass(), (String)"setupJMS");
            ECFException t = new ECFException("JMS Connect or Setup Exception", (Throwable)e);
            t.setStackTrace(e.getStackTrace());
            throw t;
        }
    }

    public void sendAsynch(ID recipient, Object obj) throws IOException {
        this.sendAsync(recipient, (Serializable)obj);
    }

    public void sendAsynch(ID recipient, byte[] obj) throws IOException {
        this.sendAsync(recipient, (Serializable)obj);
    }

    private void sendAsync(ID recipient, Serializable obj) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"sendAsynch", (Object[])new Object[]{recipient, obj});
        if (!this.isActive()) {
            throw new ConnectException("Not connected");
        }
        try {
            this.createAndSendMessage(new JMSMessage(this.getConnectionID(), this.getLocalID(), recipient, obj), null);
        }
        catch (JMSException e) {
            this.throwIOException("sendAsynch", "Exception in sendAsynch", e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"sendAsynch");
    }

    protected void onTopicException(JMSException except) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"onTopicException", (Object[])new Object[]{except});
        if (this.isActive()) {
            this.handler.handleDisconnectEvent(new DisconnectEvent((IAsynchConnection)this, (Throwable)except, null));
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"onTopicException");
    }

    protected void throwIOException(String method, String msg, Throwable t) throws IOException {
        Trace.throwing((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", this.getClass(), (String)method, (Throwable)t);
        IOException e = new IOException(String.valueOf(msg) + ": " + t.getMessage());
        if (t != null) {
            e.setStackTrace(t.getStackTrace());
        }
        throw e;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void addListener(IConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeListener(IConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"disconnect");
        this.stop();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.jms", 4, "connection close", (Throwable)e));
            }
            this.connection = null;
        }
        Object object = this.waitResponse;
        synchronized (object) {
            this.waitResponse.notifyAll();
        }
        this.fireListenersDisconnect(new ConnectionEvent((IConnection)this, null));
        this.connectionListeners.clear();
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"disconnect");
    }

    public void stop() {
        this.started = false;
    }

    public void start() {
        this.started = true;
    }

    protected void handleTopicMessage(Object data) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"handleTopicMessage", (Object[])new Object[]{data});
        if (this.isActive()) {
            try {
                this.handler.handleAsynchEvent(new AsynchEvent((IAsynchConnection)this, data));
            }
            catch (IOException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", this.getClass(), (String)"handleTopicMessage", (Throwable)e);
                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.jms", 4, "Exception on handleTopicMessage", (Throwable)e));
            }
        } else {
            Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)"handleTopicMessage: channel not active...ignoring message");
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"handleTopicMessage");
    }

    protected Serializable sendAndWait(Serializable obj) throws IOException {
        return this.sendAndWait(obj, this.keepAlive);
    }

    protected Message createMessage(Serializable obj, String jmsCorrelationId) throws JMSException {
        BytesMessage msg = this.session.createBytesMessage();
        try {
            msg.writeObject((Object)SOContainer.serialize((Serializable)obj));
        }
        catch (IOException e) {
            JMSException t = new JMSException("Could not serialized obj=" + obj);
            t.setStackTrace(e.getStackTrace());
            throw t;
        }
        if (jmsCorrelationId != null) {
            msg.setJMSCorrelationID(jmsCorrelationId);
        }
        return msg;
    }

    protected void sendMessage(Message message) throws JMSException {
        this.jmsTopicSession.getProducer().send(message);
    }

    protected void createAndSendMessage(Serializable object, String jmsCorrelationId) throws JMSException {
        this.sendMessage(this.createMessage(object, jmsCorrelationId));
    }

    protected synchronized void updateCorrelation() {
        if (correlationID == Long.MAX_VALUE) {
            correlationID = 0L;
        }
        this.correlation = String.valueOf(correlationID++);
    }

    protected String getCorrelation() {
        return this.correlation;
    }

    protected void resetCorrelation() {
        this.correlation = null;
    }

    protected void setReply(Serializable reply) {
        this.reply = reply;
    }

    protected void waitForReply(long waitDuration) throws IOException {
        long waittimeout = System.currentTimeMillis() + waitDuration;
        this.waitDone = false;
        while (!this.waitDone && waittimeout - System.currentTimeMillis() > 0L) {
            try {
                this.waitResponse.wait(waitDuration / 10L);
            }
            catch (InterruptedException e) {
                this.traceAndLogExceptionCatch(4, "handleTopicMessage", e);
                return;
            }
        }
        this.waitDone = true;
        if (this.reply == null) {
            throw new IOException("timeout waiting for response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable sendAndWait(Serializable obj, int waitDuration) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"sendAndWait", (Object[])new Object[]{obj, new Integer(waitDuration)});
        Object object = this.waitResponse;
        synchronized (object) {
            try {
                this.setReply(null);
                this.updateCorrelation();
                this.createAndSendMessage(obj, this.correlation);
                this.waitForReply(waitDuration);
            }
            catch (JMSException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", this.getClass(), (String)"sendAndWait", (Throwable)e);
                this.throwIOException("sendAndWait", "JMSException in sendAndWait", e);
            }
            Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"sendAndWait", (Object)this.reply);
            return this.reply;
        }
    }

    protected void traceAndLogExceptionCatch(int code, String method, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", this.getClass(), (String)method, (Throwable)e);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.jms", code, method, e));
    }

    protected String getConnectionID() {
        String res = null;
        try {
            if (this.connection == null) {
                return this.getLocalID().getName();
            }
            res = this.connection.getClientID();
            if (res == null) {
                res = this.getLocalID().getName();
            }
            return res;
        }
        catch (Exception e) {
            this.traceAndLogExceptionCatch(4, "getConnectionID", e);
            return null;
        }
    }

    protected abstract Object readObject(byte[] var1) throws IOException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(byte[] bytes, String correlationId) {
        block15: {
            try {
                Object o = this.readObject(bytes);
                if (o instanceof ECFMessage) {
                    ECFMessage ecfmsg = (ECFMessage)o;
                    ID fromID = ecfmsg.getSenderID();
                    if (fromID == null) {
                        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)("onMessage: fromID=null...ignoring ECFMessage " + ecfmsg));
                        return;
                    }
                    if (fromID.equals((Object)this.getLocalID())) {
                        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)("onMessage:  fromID=localID...ignoring ECFMessage " + ecfmsg));
                        return;
                    }
                    ID targetID = ecfmsg.getTargetID();
                    if (targetID == null) {
                        if (ecfmsg instanceof JMSMessage) {
                            this.handleTopicMessage(((JMSMessage)ecfmsg).getData());
                        } else {
                            Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)"onMessage.received invalid message to group");
                        }
                        break block15;
                    }
                    if (targetID.equals((Object)this.getLocalID())) {
                        if (ecfmsg instanceof JMSMessage) {
                            this.handleTopicMessage(((JMSMessage)ecfmsg).getData());
                            break block15;
                        }
                        if (ecfmsg instanceof SynchRequestMessage) {
                            this.handleSynchRequest(correlationId, ecfmsg);
                            break block15;
                        }
                        if (ecfmsg instanceof SynchResponseMessage) {
                            String c = this.getCorrelation();
                            if (c == null || !c.equals(correlationId)) break block15;
                            Object object = this.waitResponse;
                            synchronized (object) {
                                this.setReply(ecfmsg);
                                this.waitDone = true;
                                this.resetCorrelation();
                                this.waitResponse.notify();
                                break block15;
                            }
                        }
                        Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)("onMessage.msg invalid message to " + targetID));
                        break block15;
                    }
                    Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)("onMessage.msg ECFMessage " + ecfmsg + " not intended for " + targetID));
                    break block15;
                }
                Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)("onMessage: received non-ECFMessage...ignoring " + o));
            }
            catch (Exception e) {
                this.traceAndLogExceptionCatch(4, "onMessage: Unexpected Exception", e);
            }
        }
    }

    protected final class TopicReceiver
    implements MessageListener {
        public void onMessage(Message msg) {
            if (msg instanceof BytesMessage) {
                BytesMessage bm = (BytesMessage)msg;
                byte[] bytes = null;
                String correlationId = null;
                try {
                    bytes = new byte[(int)bm.getBodyLength()];
                    bm.readBytes(bytes);
                    correlationId = bm.getJMSCorrelationID();
                }
                catch (JMSException e) {
                    AbstractJMSChannel.this.traceAndLogExceptionCatch(4, "onMessage: Unexpected Exception", e);
                }
                AbstractJMSChannel.this.handleMessage(bytes, correlationId);
            } else {
                Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)("onMessage: received non-bytes message...ignoring " + msg));
            }
        }
    }
}

