/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.remoteservice.util.EndpointDescriptionPropertiesUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class EndpointDescription
extends org.osgi.service.remoteserviceadmin.EndpointDescription {
    private String ecfid;
    private Long timestamp;
    private String idNamespace;
    private ID containerID;
    private Long rsId;
    private List<String> asyncInterfaces;
    private ID connectTargetID;
    private ID[] idFilter;
    private String rsFilter;
    private Map overrides;

    public EndpointDescription(ServiceReference reference, Map<String, Object> properties) {
        super(reference, properties);
        this.verifyECFProperties();
    }

    public EndpointDescription(Map<String, Object> properties) {
        super(properties);
        this.verifyECFProperties();
    }

    private void verifyECFProperties() {
        this.ecfid = this.verifyStringProperty("ecf.endpoint.id");
        if (this.ecfid == null) {
            LogUtility.logWarning("verifyECFProperties", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionreader", EndpointDescription.class, "ECFEndpointDescription property ecf.endpoint.id not set.  Using OSGI endpoint.id value");
            this.ecfid = this.getId();
        }
        this.timestamp = this.verifyLongProperty("ecf.endpoint.ts");
        if (this.timestamp == null) {
            LogUtility.logWarning("verifyECFProperties", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionreader", EndpointDescription.class, "ECFEndpointDescription property ecf.endpoint.ts not set.  Using OSGI endpoint.service.id");
            this.timestamp = this.getServiceId();
        }
        this.idNamespace = this.verifyStringProperty("ecf.endpoint.id.ns");
        this.containerID = this.verifyIDProperty(this.idNamespace, this.ecfid);
        this.rsId = this.verifyLongProperty("ecf.rsvc.id");
        if (this.rsId == null) {
            this.rsId = this.getServiceId();
        }
        this.connectTargetID = this.verifyIDProperty("ecf.endpoint.connecttarget.id");
        this.idFilter = this.verifyIDFilter();
        this.rsFilter = this.verifyStringProperty("ecf.endpoint.rsfilter");
        this.asyncInterfaces = this.verifyAsyncInterfaces();
    }

    private List<String> verifyAsyncInterfaces() {
        List originalInterfaces;
        String[] matchingInterfaces;
        Object asyncObjectClass;
        ArrayList<String> resultInterfaces = new ArrayList<String>();
        Object noAsyncProxy = this.getProperties().get("ecf.rsvc.async.noproxy");
        if (noAsyncProxy == null && (asyncObjectClass = this.getProperties().get("ecf.exported.async.interfaces")) != null && (matchingInterfaces = PropertiesUtil.getMatchingInterfaces((originalInterfaces = this.getInterfaces()).toArray(new String[originalInterfaces.size()]), asyncObjectClass)) != null) {
            int i = 0;
            while (i < matchingInterfaces.length) {
                String asyncInterface = this.convertInterfaceToAsync(matchingInterfaces[i]);
                if (asyncInterface != null && !resultInterfaces.contains(asyncInterface)) {
                    resultInterfaces.add(asyncInterface);
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(resultInterfaces);
    }

    private Long verifyLongProperty(String propName) {
        return EndpointDescriptionPropertiesUtil.verifyLongProperty(this.getProperties(), (String)propName);
    }

    private String verifyStringProperty(String propName) {
        return EndpointDescriptionPropertiesUtil.verifyStringProperty(this.getProperties(), (String)propName);
    }

    private ID verifyIDProperty(String idNamespace, String idName) {
        return EndpointDescriptionPropertiesUtil.verifyIDProperty((String)idNamespace, (String)idName);
    }

    private ID verifyIDProperty(String namePropName) {
        return EndpointDescriptionPropertiesUtil.verifyIDProperty((String)this.idNamespace, (String)this.verifyStringProperty(namePropName));
    }

    private ID[] verifyIDFilter() {
        return EndpointDescriptionPropertiesUtil.verifyIDArray(this.getProperties(), (String)"ecf.endpoint.idfilter.ids", (String)this.getIdNamespace());
    }

    private void addInterfaceVersions(List<String> interfaces, Map<String, Version> result) {
        if (interfaces == null) {
            return;
        }
        for (String intf : interfaces) {
            int index = intf.lastIndexOf(46);
            if (index == -1) continue;
            String packageName = intf.substring(0, index);
            result.put(intf, this.getPackageVersion(packageName));
        }
    }

    public Map<String, Version> getInterfaceVersions() {
        HashMap<String, Version> result = new HashMap<String, Version>();
        this.addInterfaceVersions(this.getInterfaces(), result);
        this.addInterfaceVersions(this.getAsyncInterfaces(), result);
        return result;
    }

    public String getEndpointId() {
        return this.ecfid;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Long getRemoteServiceId() {
        return this.rsId;
    }

    public ID getContainerID() {
        return this.containerID;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public ID getConnectTargetID() {
        return this.connectTargetID;
    }

    public ID[] getIDFilter() {
        return this.idFilter;
    }

    public String getRemoteServiceFilter() {
        return this.rsFilter;
    }

    void setPropertiesOverrides(Map propertiesOverrides) {
        this.overrides = PropertiesUtil.mergeProperties(super.getProperties(), (Map<String, Object>)propertiesOverrides);
    }

    public boolean isSameService(org.osgi.service.remoteserviceadmin.EndpointDescription other) {
        if (this == other) {
            return true;
        }
        String frameworkId = this.getFrameworkUUID();
        if (frameworkId == null) {
            return false;
        }
        return this.getId().equals(other.getId()) && this.getServiceId() == other.getServiceId() && frameworkId.equals(other.getFrameworkUUID());
    }

    public Map<String, Object> getProperties() {
        if (this.overrides != null) {
            return this.overrides;
        }
        return super.getProperties();
    }

    private String convertInterfaceToAsync(String interfaceName) {
        if (interfaceName == null) {
            return null;
        }
        String asyncProxyName = (String)this.getProperties().get("ecf.rsvc.async.proxy_" + interfaceName);
        if (asyncProxyName != null) {
            return asyncProxyName;
        }
        if (interfaceName.endsWith("Async")) {
            return interfaceName;
        }
        return String.valueOf(interfaceName) + "Async";
    }

    public List<String> getAsyncInterfaces() {
        return this.asyncInterfaces;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ECFEndpointDescription[");
        sb.append(this.getProperties()).append("]");
        return sb.toString();
    }
}

