/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionWriter;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugRemoteServiceAdminListener
implements RemoteServiceAdminListener {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final int EXPORT_MASK = 7;
    public static final int IMPORT_MASK = 13;
    public static final int ALL_MASK = 15;
    protected final PrintWriter writer;
    protected int eventMask = 15;
    protected boolean writeEndpoint;
    protected EndpointDescriptionWriter edWriter;

    public DebugRemoteServiceAdminListener(PrintWriter writer, int eventMask, boolean writeEndpoint) {
        Assert.isNotNull((Object)writer);
        this.writer = writer;
        this.eventMask = eventMask;
        this.writeEndpoint = writeEndpoint;
        if (this.writeEndpoint) {
            this.edWriter = new EndpointDescriptionWriter();
        }
    }

    public DebugRemoteServiceAdminListener(PrintWriter writer, int mask) {
        this(writer, mask, true);
    }

    public DebugRemoteServiceAdminListener(PrintWriter writer) {
        this(writer, 15);
    }

    public DebugRemoteServiceAdminListener(int mask, boolean writeEndpoint) {
        this(new PrintWriter(System.out), mask, writeEndpoint);
    }

    public DebugRemoteServiceAdminListener(int mask) {
        this(mask, true);
    }

    public DebugRemoteServiceAdminListener() {
        this(15);
    }

    public int getEventMask() {
        return this.eventMask;
    }

    public void setEventMask(int eventMask) {
        this.eventMask = eventMask;
    }

    protected boolean allow(int type, int mask) {
        return (type & mask) > 0;
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        if (!(event instanceof RemoteServiceAdmin.RemoteServiceAdminEvent)) {
            return;
        }
        if (this.allow(event.getType(), this.eventMask)) {
            this.printEvent((RemoteServiceAdmin.RemoteServiceAdminEvent)event);
        }
    }

    protected String eventTypeToString(int type) {
        switch (type) {
            case 6: {
                return "EXPORT_ERROR";
            }
            case 2: {
                return "EXPORT_REGISTRATION";
            }
            case 3: {
                return "EXPORT_UNREGISTRATION";
            }
            case 10: {
                return "EXPORT_UPDATE";
            }
            case 7: {
                return "EXPORT_WARNING";
            }
            case 5: {
                return "IMPORT_ERROR";
            }
            case 1: {
                return "IMPORT_REGISTRATION";
            }
            case 4: {
                return "IMPORT_UNREGISTRATION";
            }
            case 9: {
                return "IMPORT_UPDATE";
            }
            case 8: {
                return "IMPORT_WARNING";
            }
        }
        return "UNKNOWN";
    }

    protected void writeRemoteReference(StringBuffer buf, ServiceReference<?> ref, ID containerID, long remoteServiceID) {
        this.writer.println(buf.append(ref).append(";cID=").append(containerID).append(";rsId=").append(remoteServiceID).toString());
    }

    protected void printEvent(RemoteServiceAdmin.RemoteServiceAdminEvent event) {
        ID cID = event.getContainerID();
        StringBuffer buf = new StringBuffer(sdf.format(new Date())).append(";").append(this.eventTypeToString(event.getType()));
        switch (event.getType()) {
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                RemoteServiceAdmin.ExportReference exRef = (RemoteServiceAdmin.ExportReference)event.getExportReference();
                if (exRef == null) break;
                this.writeRemoteReference(buf.append(";exportedSR="), exRef.getExportedService(), cID, exRef.getRemoteServiceId());
                if (!this.writeEndpoint) break;
                this.writeEndpoint(exRef.getEndpointDescription());
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                RemoteServiceAdmin.ImportReference imRef = (RemoteServiceAdmin.ImportReference)event.getImportReference();
                if (imRef == null) break;
                this.writeRemoteReference(buf.append(";importedSR="), imRef.getImportedService(), cID, imRef.getRemoteServiceId());
                if (!this.writeEndpoint) break;
                this.writeEndpoint(imRef.getEndpointDescription());
                break;
            }
            case 5: 
            case 6: {
                this.writer.println(buf.toString());
                Throwable t = event.getException();
                if (t == null) break;
                t.printStackTrace(this.writer);
            }
        }
        this.writer.flush();
    }

    protected void writeEndpoint(EndpointDescription endpointDescription) {
        try {
            this.writer.println("--Endpoint Description---");
            this.edWriter.writeEndpointDescription(this.writer, endpointDescription);
            this.writer.println("---End Endpoint Description");
        }
        catch (Exception e) {
            LogUtility.logError("writeEndpoint", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/exceptions/catching", this.getClass(), "Could not write endpoint description", e);
        }
    }
}

