/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ecf.core.RemoteShare;
import org.eclipse.team.internal.ecf.core.TeamSynchronization;
import org.eclipse.team.internal.ecf.ui.Messages;
import org.eclipse.team.internal.ecf.ui.subscriber.RemoteSubscriberParticipant;
import org.eclipse.team.internal.ecf.ui.wizards.RemotePeerSynchronizeWizardPage;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class RemotePeerSynchronizeWizard
extends Wizard {
    private RemotePeerSynchronizeWizardPage page;

    public RemotePeerSynchronizeWizard() {
        this.setWindowTitle(Messages.RemotePeerSynchronizeWizard_WindowTitle);
    }

    public void addPages() {
        this.page = new RemotePeerSynchronizeWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        ID containerId = this.page.getContainerId();
        RemoteShare share = TeamSynchronization.getShare((ID)containerId);
        IRosterEntry entry = this.page.getRosterEntry();
        IUser remoteUser = entry.getUser();
        ID ownId = entry.getRoster().getUser().getID();
        IResource[] resources = this.page.getSelectedResources();
        RemoteSubscriberParticipant participant = RemotePeerSynchronizeWizard.getSubscriberParticipant(share, ownId, remoteUser.getID());
        participant.setResources(resources);
        TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        if (resources.length == 1) {
            participant.refresh(resources, NLS.bind((String)Messages.SynchronizeWithHandler_RemoteSynchronizationTaskName, (Object)remoteUser.getNickname()), NLS.bind((String)Messages.SynchronizeWithHandler_RemoteSynchronizationResourceDescription, (Object)resources[0].getName(), (Object)remoteUser.getNickname()), null);
        } else {
            participant.refresh(resources, NLS.bind((String)Messages.SynchronizeWithHandler_RemoteSynchronizationTaskName, (Object)remoteUser.getNickname()), NLS.bind((String)Messages.SynchronizeWithHandler_RemoteSynchronizationResourcesDescription, (Object)remoteUser.getNickname()), null);
        }
        return true;
    }

    public static RemoteSubscriberParticipant getSubscriberParticipant(RemoteShare share, ID ownId, ID remoteId) {
        return new RemoteSubscriberParticipant(share, ownId, remoteId);
    }
}

