/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.SOContext;

public class SOConfig
implements ISharedObjectConfig {
    protected SOContainer container = null;
    protected ID sharedObjectID;
    protected ID homeContainerID;
    protected boolean isActive;
    protected Map properties;
    protected SOContext context;

    public SOConfig(ID sharedObjectID, ID homeContainerID, SOContainer cont, Map dict) {
        this.sharedObjectID = sharedObjectID;
        this.homeContainerID = homeContainerID;
        this.isActive = false;
        this.properties = dict;
        this.container = cont;
    }

    protected void makeActive(IQueueEnqueue queue) {
        this.isActive = true;
        this.context = this.container.getID().equals((Object)this.homeContainerID) ? this.container.createSharedObjectContext(this, queue) : this.container.createRemoteSharedObjectContext(this, queue);
    }

    protected synchronized void makeInactive() {
        if (this.isActive) {
            this.context.makeInactive();
            this.context = null;
            this.isActive = false;
        }
    }

    public ID getSharedObjectID() {
        return this.sharedObjectID;
    }

    public ID getHomeContainerID() {
        return this.homeContainerID;
    }

    public ISharedObjectContext getContext() {
        if (this.isActive) {
            return this.context;
        }
        return null;
    }

    public Map getProperties() {
        if (this.properties == null) {
            return new HashMap();
        }
        return this.properties;
    }
}

