/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;

public class PollingInputStream
extends FilterInputStream {
    private int numAttempts;
    private IProgressMonitor monitor;
    private boolean cancellable;
    private String readTimeoutMessage = "Timeout while reading input stream";
    private String closeTimeoutMessage = "Timeout while closing input stream";

    public PollingInputStream(InputStream in, int numAttempts, IProgressMonitor monitor) {
        super(in);
        this.numAttempts = numAttempts;
        this.monitor = monitor;
        this.cancellable = true;
    }

    public PollingInputStream(InputStream in, int numAttempts, IProgressMonitor monitor, String readTimeoutMessage, String closeTimeoutMessage) {
        super(in);
        this.numAttempts = numAttempts;
        this.monitor = monitor;
        this.cancellable = true;
        if (readTimeoutMessage != null) {
            this.readTimeoutMessage = readTimeoutMessage;
        }
        if (closeTimeoutMessage != null) {
            this.closeTimeoutMessage = closeTimeoutMessage;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void close() throws InterruptedIOException {
        block23: {
            block22: {
                attempts = 0;
                try {
                    try {
                        this.readPendingInput();
                        break block22;
                    }
                    catch (IOException e) {
                        this.logError(e.getMessage(), e);
                        stop = false;
                        ** while (!stop)
                    }
                }
                catch (Throwable var3_15) {
                    stop = false;
                    ** while (!stop)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                        stop = true;
                    }
                    catch (InterruptedIOException e) {
                        if (this.checkCancellation()) {
                            throw new OperationCanceledException();
                        }
                        if (++attempts != this.numAttempts) continue;
                        throw new InterruptedIOException(this.closeTimeoutMessage);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    continue;
lbl23:
                    // 1 sources

                    break block23;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                        stop = true;
                    }
                    catch (InterruptedIOException e) {
                        if (this.checkCancellation()) {
                            throw new OperationCanceledException();
                        }
                        if (++attempts != this.numAttempts) continue;
                        throw new InterruptedIOException(this.closeTimeoutMessage);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    continue;
                }
lbl40:
                // 1 sources

                throw var3_15;
            }
            stop = false;
            while (!stop) {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                    stop = true;
                }
                catch (InterruptedIOException e) {
                    if (this.checkCancellation()) {
                        throw new OperationCanceledException();
                    }
                    if (++attempts != this.numAttempts) continue;
                    throw new InterruptedIOException(this.closeTimeoutMessage);
                }
                catch (IOException var5_14) {
                    // empty catch block
                }
            }
        }
    }

    private void logError(String message, IOException e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, message, (Throwable)e));
        }
    }

    public int read() throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read();
            }
            catch (InterruptedIOException e) {
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(this.readTimeoutMessage);
            }
            break;
        }
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read(buffer, off, len);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred == 0) continue;
                return e.bytesTransferred;
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(this.readTimeoutMessage);
            }
            break;
        }
    }

    public long skip(long count) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.skip(count);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred == 0) continue;
                return e.bytesTransferred;
                if (++attempts != this.numAttempts) continue;
                throw new InterruptedIOException(this.readTimeoutMessage);
            }
            break;
        }
    }

    protected void readPendingInput() throws IOException {
        int available;
        byte[] buffer = new byte[2048];
        while ((available = this.in.available()) >= 1) {
            if (available > buffer.length) {
                available = buffer.length;
            }
            if (this.in.read(buffer, 0, available) >= 1) continue;
        }
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private boolean checkCancellation() {
        if (this.cancellable) {
            return this.monitor.isCanceled();
        }
        return false;
    }
}

