/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.osgi.framework.ServiceObjects;
import org.osgi.test.common.context.CloseableBundleContext;
import org.osgi.test.common.exceptions.Exceptions;

public class CloseableServiceObjects<S>
implements AutoCloseable,
InvocationHandler {
    private static final Map<Method, BiFunction<Object, Object[], Object>> methods = Arrays.stream(ServiceObjects.class.getMethods()).collect(Collectors.toMap(Function.identity(), method -> {
        try {
            return CloseableBundleContext.invoker(CloseableServiceObjects.class.getMethod(method.getName(), method.getParameterTypes()), CloseableServiceObjects::closeableServiceObjects);
        }
        catch (NoSuchMethodException e) {
            return CloseableBundleContext.invoker(method, CloseableServiceObjects::realServiceObjects);
        }
    }));
    private final ServiceObjects<S> serviceObjects;
    private final Map<S, Integer> instances = Collections.synchronizedMap(new IdentityHashMap());

    public static <S> ServiceObjects<S> proxy(ServiceObjects<S> serviceObjects) {
        return (ServiceObjects)Proxy.newProxyInstance(CloseableBundleContext.PROXY_CLASS_LOADER, new Class[]{ServiceObjects.class, AutoCloseable.class}, new CloseableServiceObjects<S>(serviceObjects));
    }

    public CloseableServiceObjects(ServiceObjects<S> serviceObjects) {
        this.serviceObjects = serviceObjects;
    }

    @Override
    public void close() {
        this.instances.forEach((service, useCount) -> {
            for (int i = useCount.intValue(); i > 0; --i) {
                this.serviceObjects.ungetService(service);
            }
        });
        this.instances.clear();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BiFunction<Object, Object[], Object> invoker = methods.get(method);
        if (invoker == null) {
            throw new IllegalArgumentException();
        }
        return invoker.apply(proxy, args);
    }

    private static CloseableServiceObjects<?> closeableServiceObjects(Object proxy) {
        InvocationHandler invocationHandler;
        try {
            invocationHandler = Proxy.getInvocationHandler(proxy);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (invocationHandler instanceof CloseableServiceObjects) {
            return (CloseableServiceObjects)invocationHandler;
        }
        return null;
    }

    private static ServiceObjects<?> realServiceObjects(Object proxy) {
        CloseableServiceObjects<?> closeableServiceObjects = CloseableServiceObjects.closeableServiceObjects(proxy);
        if (closeableServiceObjects == null) {
            return null;
        }
        ServiceObjects real = closeableServiceObjects.serviceObjects;
        while ((closeableServiceObjects = CloseableServiceObjects.closeableServiceObjects(real)) != null) {
            real = closeableServiceObjects.serviceObjects;
        }
        return real;
    }

    private static Void delegatedClose(Object proxy, Object[] args) {
        CloseableServiceObjects.closeableServiceObjects(proxy).close();
        return null;
    }

    private static String delegatedToString(Object proxy, Object[] args) {
        return "CloseableServiceObjects[" + System.identityHashCode(proxy) + "]:" + CloseableServiceObjects.realServiceObjects(proxy).toString();
    }

    private static int delegatedHashCode(Object proxy, Object[] args) {
        return CloseableServiceObjects.realServiceObjects(proxy).hashCode();
    }

    private static boolean delegatedEquals(Object proxy, Object[] args) {
        ServiceObjects<?> serviceObjects = CloseableServiceObjects.realServiceObjects(proxy);
        ServiceObjects<?> real = CloseableServiceObjects.realServiceObjects(args[0]);
        if (real != null) {
            return serviceObjects.equals(real);
        }
        return serviceObjects.equals(args[0]);
    }

    public S getService() {
        Object service = this.serviceObjects.getService();
        this.instances.merge(service, 1, (oldValue, dummy) -> oldValue + 1);
        return (S)service;
    }

    public void ungetService(S service) {
        this.instances.compute(service, (key, oldValue) -> {
            if (oldValue == null) {
                throw new AssertionError((Object)("Attempt to ungetService " + service + " but there are no outstanding references to this object"));
            }
            return oldValue == 1 ? null : Integer.valueOf(oldValue - 1);
        });
        this.serviceObjects.ungetService(service);
    }

    static {
        try {
            methods.put(AutoCloseable.class.getMethod("close", new Class[0]), CloseableServiceObjects::delegatedClose);
            methods.put(Object.class.getMethod("toString", new Class[0]), CloseableServiceObjects::delegatedToString);
            methods.put(Object.class.getMethod("hashCode", new Class[0]), CloseableServiceObjects::delegatedHashCode);
            methods.put(Object.class.getMethod("equals", Object.class), CloseableServiceObjects::delegatedEquals);
        }
        catch (NoSuchMethodException e) {
            throw Exceptions.duck(e);
        }
    }
}

