/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class AutoboxingCleanUpCore
extends AbstractMultiFix {
    private static final String VALUE_OF_METHOD = "valueOf";

    public AutoboxingCleanUpCore() {
        this(Collections.emptyMap());
    }

    public AutoboxingCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.use_autoboxing");
        Map<String, String> requiredOptions = null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.use_autoboxing")) {
            return new String[]{MultiFixMessages.AutoboxingCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.use_autoboxing")) {
            return "Integer i = 0;\nCharacter c = '*';\n";
        }
        return "Integer i = Integer.valueOf(0);\nCharacter c = Character.valueOf('*');\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.use_autoboxing")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation visited) {
                if (ASTNodes.usesGivenSignature(visited, Boolean.class.getCanonicalName(), AutoboxingCleanUpCore.VALUE_OF_METHOD, Boolean.TYPE.getSimpleName()) || ASTNodes.usesGivenSignature(visited, Byte.class.getCanonicalName(), AutoboxingCleanUpCore.VALUE_OF_METHOD, Byte.TYPE.getSimpleName()) || ASTNodes.usesGivenSignature(visited, Character.class.getCanonicalName(), AutoboxingCleanUpCore.VALUE_OF_METHOD, Character.TYPE.getSimpleName()) || ASTNodes.usesGivenSignature(visited, Short.class.getCanonicalName(), AutoboxingCleanUpCore.VALUE_OF_METHOD, Short.TYPE.getSimpleName()) || ASTNodes.usesGivenSignature(visited, Integer.class.getCanonicalName(), AutoboxingCleanUpCore.VALUE_OF_METHOD, Integer.TYPE.getSimpleName()) || ASTNodes.usesGivenSignature(visited, Long.class.getCanonicalName(), AutoboxingCleanUpCore.VALUE_OF_METHOD, Long.TYPE.getSimpleName()) || ASTNodes.usesGivenSignature(visited, Float.class.getCanonicalName(), AutoboxingCleanUpCore.VALUE_OF_METHOD, Float.TYPE.getSimpleName()) || ASTNodes.usesGivenSignature(visited, Double.class.getCanonicalName(), AutoboxingCleanUpCore.VALUE_OF_METHOD, Double.TYPE.getSimpleName())) {
                    ITypeBinding primitiveType = visited.resolveMethodBinding().getParameterTypes()[0];
                    ITypeBinding wrapperClass = visited.resolveMethodBinding().getDeclaringClass();
                    ITypeBinding actualResultType = ASTNodes.getTargetType((Expression)visited);
                    ITypeBinding actualParameterType = ((Expression)visited.arguments().get(0)).resolveTypeBinding();
                    if (actualParameterType != null && actualResultType != null && (actualResultType.equals((Object)primitiveType) || actualResultType.equals((Object)wrapperClass)) || Objects.equals(actualParameterType, wrapperClass)) {
                        SuperConstructorInvocation superConstructorInvocation;
                        SuperMethodInvocation superMethodInvocation;
                        MethodInvocation methodInvocation;
                        ClassInstanceCreation classInstanceCreation;
                        ASTNode parent = visited.getParent();
                        if (parent instanceof ClassInstanceCreation && visited.getLocationInParent() == ClassInstanceCreation.ARGUMENTS_PROPERTY ? this.hasConflictingMethodOrConstructor(visited, (classInstanceCreation = (ClassInstanceCreation)parent).resolveConstructorBinding(), classInstanceCreation.arguments()) : (parent instanceof MethodInvocation && visited.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY ? this.hasConflictingMethodOrConstructor(visited, (methodInvocation = (MethodInvocation)parent).resolveMethodBinding(), methodInvocation.arguments()) : (parent instanceof SuperMethodInvocation && visited.getLocationInParent() == SuperMethodInvocation.ARGUMENTS_PROPERTY ? this.hasConflictingMethodOrConstructor(visited, (superMethodInvocation = (SuperMethodInvocation)parent).resolveMethodBinding(), superMethodInvocation.arguments()) : parent instanceof SuperConstructorInvocation && visited.getLocationInParent() == SuperConstructorInvocation.ARGUMENTS_PROPERTY && this.hasConflictingMethodOrConstructor(visited, (superConstructorInvocation = (SuperConstructorInvocation)parent).resolveConstructorBinding(), superConstructorInvocation.arguments())))) {
                            return true;
                        }
                        rewriteOperations.add(new AutoboxingOperation((ASTNode)visited, primitiveType, wrapperClass, actualParameterType, actualResultType));
                        return false;
                    }
                }
                return true;
            }

            private boolean hasConflictingMethodOrConstructor(MethodInvocation visited, IMethodBinding binding, List<Expression> arguments) {
                int argumentIndex = arguments.indexOf(visited);
                if (argumentIndex < 0 || binding.getParameterTypes().length <= argumentIndex) {
                    return true;
                }
                ITypeBinding[] argumentTypes = (ITypeBinding[])binding.getParameterTypes().clone();
                argumentTypes[argumentIndex] = visited.getExpression().resolveTypeBinding();
                return ASTNodes.hasConflictingMethodOrConstructor(visited.getParent(), binding, argumentTypes);
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.AutoboxingCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[rewriteOperations.size()]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class AutoboxingOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final ASTNode node;
        private final ITypeBinding primitiveType;
        private final ITypeBinding wrapperClass;
        private final ITypeBinding actualParameterType;
        private final ITypeBinding actualResultType;

        public AutoboxingOperation(ASTNode node, ITypeBinding primitiveType, ITypeBinding wrapperClass, ITypeBinding actualParameterType, ITypeBinding actualResultType) {
            this.node = node;
            this.primitiveType = primitiveType;
            this.wrapperClass = wrapperClass;
            this.actualParameterType = actualParameterType;
            this.actualResultType = actualResultType;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.AutoboxingCleanup_description, cuRewrite);
            Expression arg0 = (Expression)rewrite.createCopyTarget((ASTNode)((Expression)((MethodInvocation)this.node).arguments().get(0)));
            if (!(this.primitiveType == null || this.primitiveType.equals((Object)this.actualParameterType) || this.primitiveType.equals((Object)this.actualResultType) || this.wrapperClass != null && this.wrapperClass.equals((Object)this.actualParameterType))) {
                CastExpression newCastExpression = ast.newCastExpression();
                newCastExpression.setType((Type)ast.newPrimitiveType(PrimitiveType.toCode((String)this.primitiveType.getName())));
                newCastExpression.setExpression(arg0);
                ASTNodes.replaceButKeepComment(rewrite, this.node, (ASTNode)newCastExpression, group);
            } else {
                ASTNodes.replaceButKeepComment(rewrite, this.node, (ASTNode)arg0, group);
            }
        }
    }
}

