/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.structure.property.IPropertiesMenuContributor;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.AccessorUtils;
import org.eclipse.wb.internal.core.model.property.accessor.IExposableExpressionAccessor;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.dialogfields.AbstractValidationTitleAreaDialog;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class ExposePropertySupport
implements IPropertiesMenuContributor {
    public static final IPropertiesMenuContributor INSTANCE = new ExposePropertySupport();

    private ExposePropertySupport() {
    }

    public void contributeMenu(IMenuManager manager, Property property) throws Exception {
        if (property instanceof GenericPropertyImpl) {
            GenericPropertyImpl genericProperty = (GenericPropertyImpl)property;
            IExposableExpressionAccessor accessor = AccessorUtils.getExposableExpressionAccessor(property);
            if (accessor != null) {
                manager.insertAfter("org.eclipse.wb.component-properties.group.edit", (IAction)new ExposePropertyAction(genericProperty, accessor));
            }
        }
    }

    private static class ExposePropertyAction
    extends Action {
        private final GenericPropertyImpl m_property;
        private final IExposableExpressionAccessor m_exposableAccessor;
        private final JavaInfo m_javaInfo;
        private final AstEditor m_editor;
        private final TypeDeclaration m_typeDeclaration;
        private final String m_propertyTypeName;
        private String m_exposedName;
        private String m_exposedGetter;
        private String m_exposedSetter;
        private String m_exposedSetterParameter;

        public ExposePropertyAction(GenericPropertyImpl property, IExposableExpressionAccessor exposableAccessor) {
            this.setImageDescriptor(DesignerPlugin.getImageDescriptor((String)"actions/expose/exposeProperty.png"));
            this.setText(ModelMessages.ExposePropertyAction_text);
            this.setToolTipText(ModelMessages.ExposePropertyAction_tooltip);
            this.m_property = property;
            this.m_exposableAccessor = exposableAccessor;
            this.m_javaInfo = this.m_property.getJavaInfo();
            this.m_editor = this.m_javaInfo.getEditor();
            this.m_typeDeclaration = JavaInfoUtils.getTypeDeclaration(this.m_javaInfo);
            this.m_propertyTypeName = ReflectionUtils.getFullyQualifiedName(this.m_exposableAccessor.getValueClass(this.m_javaInfo), (boolean)false);
        }

        public void run() {
            final ExposeDialog dialog = new ExposeDialog();
            if (dialog.open() == 0) {
                ExecutionUtils.run((ObjectInfo)this.m_javaInfo, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        this.expose(dialog.isPublic());
                    }
                });
            }
        }

        private void setExposedName(String exposedName) {
            this.m_exposedName = exposedName;
            this.m_exposedGetter = "get" + StringUtils.capitalize((String)this.m_exposedName);
            this.m_exposedSetter = "set" + StringUtils.capitalize((String)this.m_exposedName);
            List<VariableDeclaration> variables = AstNodeUtils.getVariableDeclarationsAll((ASTNode)this.m_editor.getAstUnit());
            this.m_exposedSetterParameter = CodeUtils.generateUniqueName(this.m_property.getTitle(), name -> {
                for (VariableDeclaration variable : variables) {
                    if (!variable.getName().getIdentifier().equals(name)) continue;
                    return false;
                }
                return true;
            });
        }

        private String validate(String exposedName) {
            this.setExposedName(exposedName);
            IStatus status = JavaConventions.validateIdentifier((String)this.m_exposedName);
            if (status.getSeverity() == 4) {
                return status.getMessage();
            }
            String signature = this.m_exposedGetter + "()";
            if (AstNodeUtils.getMethodBySignature(this.m_typeDeclaration, signature) != null) {
                return MessageFormat.format(ModelMessages.ExposePropertyAction_validateMethodAlreadyExists, signature);
            }
            signature = this.m_exposedSetter + "(" + this.m_propertyTypeName + ")";
            if (AstNodeUtils.getMethodBySignature(this.m_typeDeclaration, signature) != null) {
                return MessageFormat.format(ModelMessages.ExposePropertyAction_validateMethodAlreadyExists, signature);
            }
            return null;
        }

        private String getPreviewSource(boolean isPublic) throws Exception {
            String modifierSource = isPublic ? "public" : "protected";
            String propertyTypeName = CodeUtils.getShortClass(this.m_propertyTypeName);
            String accessExpression = this.m_javaInfo.getVariableSupport().getName() + ".";
            Object source = "";
            source = (String)source + "...\n";
            source = (String)source + MessageFormat.format("\t{0} {1} {2}() '{'\n", modifierSource, propertyTypeName, this.m_exposedGetter);
            source = (String)source + MessageFormat.format("\t\treturn {0}{1};\n", accessExpression, this.m_exposableAccessor.getGetterCode(this.m_javaInfo));
            source = (String)source + "\t}\n";
            source = (String)source + MessageFormat.format("\t{0} void {1}({2} {3}) '{'\n", modifierSource, this.m_exposedSetter, propertyTypeName, this.m_exposedSetterParameter);
            source = (String)source + MessageFormat.format("\t\t{0}{1};\n", accessExpression, this.m_exposableAccessor.getSetterCode(this.m_javaInfo, this.m_exposedSetterParameter));
            source = (String)source + "\t}\n";
            source = (String)source + "...\n";
            return source;
        }

        private void expose(boolean isPublic) throws Exception {
            BodyDeclarationTarget methodTarget = new BodyDeclarationTarget(this.m_typeDeclaration, false);
            String modifierSource = isPublic ? "public" : "protected";
            Object header = modifierSource + " " + this.m_propertyTypeName + " " + this.m_exposedGetter + "()";
            String body = TemplateUtils.resolve(methodTarget, "return {0}.{1};", new Object[]{this.m_javaInfo, this.m_exposableAccessor.getGetterCode(this.m_javaInfo)});
            this.m_editor.addMethodDeclaration((String)header, List.of(body), methodTarget);
            header = MessageFormat.format("{0} void {1}({2} {3})", modifierSource, this.m_exposedSetter, this.m_propertyTypeName, this.m_exposedSetterParameter);
            body = TemplateUtils.resolve(methodTarget, "{0}.{1};", new Object[]{this.m_javaInfo, this.m_exposableAccessor.getSetterCode(this.m_javaInfo, this.m_exposedSetterParameter)});
            this.m_editor.addMethodDeclaration((String)header, List.of(body), methodTarget);
        }

        private class ExposeDialog
        extends AbstractValidationTitleAreaDialog {
            private StringDialogField m_nameField;
            private SelectionButtonDialogFieldGroup m_modifierField;
            private SourceViewer m_previewViewer;
            private Composite m_fieldsContainer;

            public ExposeDialog() {
                super(DesignerPlugin.getShell(), (AbstractUIPlugin)DesignerPlugin.getDefault(), ModelMessages.ExposePropertyAction_dialogShellTitle, ModelMessages.ExposePropertyAction_dialogTitle, DesignerPlugin.getImage((String)"actions/expose/expose_banner.gif"), ModelMessages.ExposePropertyAction_dialogMessage);
                this.setShellStyle(67680);
            }

            protected void createControls(Composite container) {
                this.m_fieldsContainer = container;
                GridLayoutFactory.create((Composite)container).columns(2);
                this.m_nameField = new StringDialogField();
                this.doCreateField((DialogField)this.m_nameField, ModelMessages.ExposePropertyAction_dialogPropertyLabel);
                String exposedName = ExposePropertyAction.this.m_javaInfo.getVariableSupport().getComponentName() + StringUtils.capitalize((String)ExposePropertyAction.this.m_property.getTitle());
                this.m_nameField.setText(exposedName);
                this.m_modifierField = new SelectionButtonDialogFieldGroup(16, new String[]{"&public", "pro&tected"}, 1, 16);
                this.doCreateField((DialogField)this.m_modifierField, ModelMessages.ExposePropertyAction_dialogModifier);
                new Label(container, 0).setText(ModelMessages.ExposePropertyAction_dialogPreview);
                this.m_previewViewer = JdtUiUtils.createJavaSourceViewer(container, 2560);
                GridDataFactory.create((Control)this.m_previewViewer.getControl()).spanH(2).hintVC(9).grab().fill();
            }

            protected String validate() throws Exception {
                String message = ExposePropertyAction.this.validate(this.m_nameField.getText());
                if (message != null) {
                    JdtUiUtils.setJavaSourceForViewer(this.m_previewViewer, ModelMessages.ExposePropertyAction_dialogNoPreview);
                    return message;
                }
                boolean isPublic = this.isPublic();
                JdtUiUtils.setJavaSourceForViewer(this.m_previewViewer, ExposePropertyAction.this.getPreviewSource(isPublic));
                return null;
            }

            public boolean isPublic() {
                return this.m_modifierField.getSelection()[0] == 0;
            }

            protected final void doCreateField(DialogField dialogField, String labelText) {
                dialogField.setLabelText(labelText);
                dialogField.setDialogFieldListener(this.m_validateListener);
                DialogFieldUtils.fillControls((Composite)this.m_fieldsContainer, (DialogField)dialogField, (int)2, (int)40);
            }
        }
    }
}

