/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IndentationObject;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class CommentIndentationStrategy
extends DefaultIndentationStrategy {
    public CommentIndentationStrategy() {
    }

    public CommentIndentationStrategy(IndentationObject indentationObject) {
        this.setIndentationObject(indentationObject);
    }

    @Override
    public void placeMatchingBlanks(IStructuredDocument document, StringBuilder result, int lineNumber, int forOffset) throws BadLocationException {
        IPHPScriptRegion scriptRegion;
        if (lineNumber == 0) {
            return;
        }
        IRegion previousLine = document.getLineInformation(lineNumber - 1);
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(previousLine.getOffset());
        if (sdRegion == null) {
            return;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(previousLine.getOffset());
        if (tRegion == null) {
            return;
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(previousLine.getOffset());
            regionStart += tRegion.getStart();
        }
        if (tRegion instanceof IPHPScriptRegion && regionStart + (tRegion = (scriptRegion = (IPHPScriptRegion)tRegion).getPHPToken(previousLine.getOffset() - regionStart)).getTextEnd() <= previousLine.getOffset()) {
            tRegion = scriptRegion.getPHPToken(tRegion.getEnd());
        }
        if (PHPPartitionTypes.isPHPMultiLineCommentStartRegion(tRegion.getType()) || PHPPartitionTypes.isPHPDocStartRegion(tRegion.getType())) {
            blanks = FormatterUtils.getLineBlanks((IDocument)document, previousLine);
            result.append(blanks);
            result.append(" ");
        } else if (PHPPartitionTypes.isPHPMultiLineCommentRegion(tRegion.getType()) || PHPPartitionTypes.isPHPDocRegion(tRegion.getType())) {
            blanks = FormatterUtils.getLineBlanks((IDocument)document, previousLine);
            --lineNumber;
            while (lineNumber > 0 && blanks.length() == previousLine.getLength()) {
                previousLine = document.getLineInformation(--lineNumber);
                blanks = FormatterUtils.getLineBlanks((IDocument)document, previousLine);
            }
            result.append(blanks);
        } else {
            super.placeMatchingBlanks(document, result, lineNumber, forOffset);
        }
    }
}

