/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.ui.internal.utility.SynchronousUiCommandContext;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.ColumnMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.MappedByRelationship;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.MappingRelationship;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmManagedType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.jpa2.context.DerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MapsIdDerivedIdentityStrategy2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsIdAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.IdAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.AddAttributeCommand;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.AddPersistentAttributeInOrmXMLCommand;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.AddPersistentTypeToOrmXmlCommand;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.CreateEntityTypeHierarchy;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.DeleteAttributeCommand;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.RenameAttributeCommand;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.RenameEntityCommand;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.SetMappedByNewValueCommand;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddHasReferenceRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddInheritedEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.AbstractRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasCollectionReferenceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasSingleReferenceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IBidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IUnidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IsARelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.swt.widgets.Display;

public class JpaArtifactFactory {
    private static final JpaArtifactFactory INSTANCE = new JpaArtifactFactory();
    private static final int MAX_NUM_OF_ITERATIONS = 25;
    private static final int PAUSE_DURATION = 200;

    public static synchronized JpaArtifactFactory instance() {
        return INSTANCE;
    }

    public void rearrangeIsARelations(IJPAEditorFeatureProvider fp) {
        Collection<IsARelation> isARels = this.produceAllMissingIsARelations(fp);
        this.addIsARelations(fp, isARels);
        fp.removeAllRedundantIsARelations();
    }

    public void rearrangeIsARelationsInTransaction(final IJPAEditorFeatureProvider fp) {
        final Collection<IsARelation> isARels = this.produceAllMissingIsARelations(fp);
        if (!fp.existRedundantIsARelations() && isARels.size() == 0) {
            return;
        }
        TransactionalEditingDomain ted = fp.getTransactionalEditingDomain();
        if (ted == null) {
            return;
        }
        RecordingCommand rc = new RecordingCommand(ted){

            protected void doExecute() {
                JpaArtifactFactory.this.addIsARelations(fp, isARels);
                fp.removeAllRedundantIsARelations();
            }
        };
        ted.getCommandStack().execute((Command)rc);
    }

    public Collection<IsARelation> produceAllMissingIsARelations(IJPAEditorFeatureProvider fp) {
        Collection<PersistentType> persistentTypes = fp.getPersistentTypes();
        HashSet<IsARelation> res = new HashSet<IsARelation>();
        Iterator<PersistentType> it = persistentTypes.iterator();
        HashSet<IsARelation> allExistingIsARelations = fp.getAllExistingIsARelations();
        while (it.hasNext()) {
            IsARelation newRel;
            PersistentType jpt = it.next();
            PersistentType superclass = fp.getFirstSuperclassBelongingToTheDiagram(jpt);
            if (superclass == null || allExistingIsARelations.contains(newRel = new IsARelation(jpt, superclass))) continue;
            res.add(newRel);
        }
        return res;
    }

    public void addOneToOneUnidirectionalRelation(IFeatureProvider fp, PersistentType jpt, PersistentAttribute attribute) {
        this.addOneToOneRelation(fp, jpt, attribute, null, null, 1);
    }

    public void addOneToOneBidirectionalRelation(IFeatureProvider fp, PersistentType jpt1, PersistentAttribute attribute1, PersistentType jpt2, PersistentAttribute attribute2) {
        this.addOneToOneRelation(fp, jpt1, attribute1, jpt2, attribute2, 2);
    }

    public void addOneToManyUnidirectionalRelation(IFeatureProvider fp, PersistentType jpt, PersistentAttribute attribute, boolean isMap) {
        this.addOneToManyRelation(fp, jpt, attribute, null, null, 1, isMap);
    }

    public void addOneToManyBidirectionalRelation(IFeatureProvider fp, PersistentType jpt1, PersistentAttribute attribute1, PersistentType jpt2, PersistentAttribute attribute2, boolean isMap) {
        this.addOneToManyRelation(fp, jpt1, attribute1, jpt2, attribute2, 2, isMap);
    }

    public void addManyToOneBidirectionalRelation(IFeatureProvider fp, PersistentType jpt1, PersistentAttribute attribute1, PersistentType jpt2, PersistentAttribute attribute2, boolean isMap) {
        this.addManyToOneRelation(fp, jpt1, attribute1, jpt2, attribute2, 2, isMap);
    }

    public void addOneToOneRelation(IFeatureProvider fp, PersistentType ownerJPT, PersistentAttribute ownerAttibute, PersistentType referencedJPT, PersistentAttribute referencedAttribute, int direction) {
        this.setMappingKeyToAttribute(fp, ownerJPT, ownerAttibute, "oneToOne");
        if (direction == 2) {
            PersistentAttribute resolvedAttribute = this.setMappingKeyToAttribute(fp, referencedJPT, referencedAttribute, "oneToOne");
            String mappedByAttr = this.getMappeByAttribute(fp, ownerJPT, ownerAttibute);
            this.setMappedByAttribute(resolvedAttribute, referencedJPT, mappedByAttr);
        }
    }

    public void addManyToOneRelation(IFeatureProvider fp, PersistentType manySideJPT, PersistentAttribute manySideAttribute, PersistentType singleSideJPT, PersistentAttribute singleSideAttibute, int direction, boolean isMap) {
        this.setMappingKeyToAttribute(fp, manySideJPT, manySideAttribute, "manyToOne");
        if (direction == 1) {
            return;
        }
        PersistentAttribute resolvedSingleSideAttribute = this.setMappingKeyToAttribute(fp, singleSideJPT, singleSideAttibute, "oneToMany");
        String mappedByAttr = this.getMappeByAttribute(fp, manySideJPT, manySideAttribute);
        this.setMappedByAttribute(resolvedSingleSideAttribute, singleSideJPT, mappedByAttr);
        if (isMap && this.getORMPersistentAttribute(singleSideAttibute) == null) {
            singleSideAttibute.getJavaPersistentAttribute().getResourceAttribute().addAnnotation(MapKeyAnnotation.ANNOTATION_NAME);
        }
    }

    public void addOneToManyRelation(IFeatureProvider fp, PersistentType singleSideJPT, PersistentAttribute singleSideAttibute, PersistentType manySideJPT, PersistentAttribute manySideAttribute, int direction, boolean isMap) {
        PersistentAttribute resolvedSingleSideAttribute = this.setMappingKeyToAttribute(fp, singleSideJPT, singleSideAttibute, "oneToMany");
        if (direction == 2) {
            this.setMappingKeyToAttribute(fp, manySideJPT, manySideAttribute, "manyToOne");
            String mappedByAttr = this.getMappeByAttribute(fp, manySideJPT, manySideAttribute);
            this.setMappedByAttribute(resolvedSingleSideAttribute, singleSideJPT, mappedByAttr);
        } else {
            this.addJoinColumnIfNecessary(resolvedSingleSideAttribute, singleSideJPT);
        }
        if (isMap && this.getORMPersistentAttribute(singleSideAttibute) == null) {
            singleSideAttibute.getJavaPersistentAttribute().getResourceAttribute().addAnnotation(MapKeyAnnotation.ANNOTATION_NAME);
        }
    }

    private String getMappeByAttribute(IFeatureProvider fp, PersistentType ownerSideJPT, PersistentAttribute ownerSideAttribute) {
        HasReferanceRelation ref;
        String mappedByAttr = ownerSideAttribute.getName();
        if (this.isEmbeddable(ownerSideJPT) && (ref = INSTANCE.findFisrtHasReferenceRelationByEmbeddable(ownerSideJPT, (IJPAEditorFeatureProvider)fp)) != null) {
            PersistentAttribute embeddingAttribute = ref.getEmbeddedAnnotatedAttribute();
            mappedByAttr = String.valueOf(embeddingAttribute.getName()) + "." + ownerSideAttribute.getName();
        }
        return mappedByAttr;
    }

    private void setMappedByAttribute(PersistentAttribute resolvedAttr, PersistentType type1, String jpaName) {
        this.setMappedByRelationAttribute(resolvedAttr, jpaName);
        PersistentAttribute ormAttribute = this.getORMPersistentAttribute(resolvedAttr);
        if (ormAttribute != null) {
            this.setMappedByRelationAttribute(ormAttribute, jpaName);
        }
    }

    private void setMappedByRelationAttribute(PersistentAttribute resolvedAttr, String jpaName) {
        AttributeMapping mapping = resolvedAttr.getMapping();
        if (!(mapping instanceof RelationshipMapping)) {
            return;
        }
        RelationshipMapping relationshipMappin = (RelationshipMapping)resolvedAttr.getMapping();
        MappedByRelationship mappedByRel = (MappedByRelationship)relationshipMappin.getRelationship();
        SpecifiedMappedByRelationshipStrategy mappedByStrategy = mappedByRel.getMappedByStrategy();
        mappedByStrategy.setMappedByAttribute(jpaName);
    }

    private PersistentAttribute setMappingKeyToAttribute(IFeatureProvider fp, PersistentType jpt, PersistentAttribute jpa, String mappingKey) {
        PersistentAttribute resolvedManySideAttribute = jpt.getAttributeNamed(jpa.getName());
        PersistentAttribute ormAttr = this.addOrmPersistentAttribute(jpt, resolvedManySideAttribute, mappingKey);
        if (ormAttr == null || ormAttr.isVirtual()) {
            resolvedManySideAttribute.getJavaPersistentAttribute().setMappingKey(mappingKey);
        }
        return jpa;
    }

    private void addJoinColumnIfNecessary(PersistentAttribute jpa, PersistentType jpt) {
        if (JPAEditorUtil.checkJPAFacetVersion(jpa.getJpaProject(), "1.0") || JPADiagramPropertyPage.shouldOneToManyUnidirBeOldStyle(jpa.getJpaProject().getProject())) {
            return;
        }
        PersistentAttribute[] ids = this.getIds(jpt);
        if (ids.length == 0) {
            return;
        }
        SpecifiedJoinColumnRelationshipStrategy strategy = this.getJoinColumnStrategy(jpa);
        if (strategy == null) {
            return;
        }
        String tableName = this.getTableName(jpt);
        if (ids.length == 1) {
            if (this.isSimpleId(ids[0])) {
                String idColName = this.getColumnName(ids[0]);
                this.addJoinColumn(jpa, tableName, strategy, idColName);
            } else {
                Hashtable<String, String> atNameToColName = this.getOverriddenColNames(ids[0]);
                PersistenceUnit pu = this.getPersistenceUnit(jpt);
                String embeddableTypeName = this.getRelTypeName(ids[0]);
                Embeddable emb = pu.getEmbeddable(embeddableTypeName);
                for (AttributeMapping am : emb.getAllAttributeMappings()) {
                    SpecifiedPersistentAttribute at = am.getPersistentAttribute();
                    String idColName = atNameToColName.get(at.getName());
                    idColName = idColName != null ? idColName : this.getColumnName((PersistentAttribute)at);
                    this.addJoinColumn(jpa, tableName, strategy, idColName);
                }
            }
        } else {
            PersistentAttribute[] persistentAttributeArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                PersistentAttribute idAt = persistentAttributeArray[n2];
                String idColName = this.getColumnName(idAt);
                this.addJoinColumn(jpa, tableName, strategy, idColName);
                ++n2;
            }
        }
    }

    private SpecifiedJoinColumnRelationshipStrategy getJoinColumnStrategy(PersistentAttribute jpa) {
        SpecifiedRelationshipStrategy strategy;
        AttributeMapping attributeMapping = this.getAttributeMapping(jpa);
        if (attributeMapping instanceof RelationshipMapping && (strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy()) instanceof SpecifiedJoinColumnRelationshipStrategy) {
            return (SpecifiedJoinColumnRelationshipStrategy)strategy;
        }
        return null;
    }

    private void addJoinColumn(PersistentAttribute jpa, String tableName, SpecifiedJoinColumnRelationshipStrategy strategy, String idColName) {
        String name = String.valueOf(tableName) + "_" + idColName;
        SpecifiedJoinColumn joinColumn = strategy.addSpecifiedJoinColumn();
        joinColumn.setSpecifiedName(name);
        joinColumn.setSpecifiedReferencedColumnName(idColName);
    }

    private Hashtable<String, String> getOverriddenColNames(PersistentAttribute embIdAt) {
        AttributeOverrideContainer attributeOverrideContainer;
        AttributeMapping attributeMapping = this.getAttributeMapping(embIdAt);
        Hashtable<String, String> res = new Hashtable<String, String>();
        if (attributeMapping instanceof EmbeddedIdMapping && (attributeOverrideContainer = ((EmbeddedIdMapping)attributeMapping).getAttributeOverrideContainer()).getSpecifiedOverridesSize() > 0) {
            for (AttributeOverride attributeOverride : attributeOverrideContainer.getSpecifiedOverrides()) {
                res.put(attributeOverride.getName(), attributeOverride.getColumn().getName());
            }
        }
        return res;
    }

    public void addManyToOneUnidirectionalRelation(IFeatureProvider fp, PersistentType jpt, PersistentAttribute attribute) {
        this.addManyToOneRelation(fp, jpt, attribute, null, null, 1, false);
    }

    public void addManyToManyBidirectionalRelation(IFeatureProvider fp, PersistentType jpt1, PersistentAttribute attribute1, PersistentType jpt2, PersistentAttribute attribute2, boolean isMap) {
        this.addManyToManyRelation(fp, jpt1, attribute1, jpt2, attribute2, 2, isMap);
    }

    public void addManyToManyUnidirectionalRelation(IFeatureProvider fp, PersistentType annotatedJPT, PersistentAttribute annotatedAttribute, boolean isMap) {
        this.addManyToManyRelation(fp, annotatedJPT, annotatedAttribute, null, null, 1, isMap);
    }

    public void addManyToManyRelation(IFeatureProvider fp, PersistentType ownerSideJPT, PersistentAttribute ownerSideAttribute, PersistentType inverseSideJPT, PersistentAttribute inverseSideAttibute, int direction, boolean isMap) {
        PersistentAttribute resolvedOwnerSideAttribute = this.setMappingKeyToAttribute(fp, ownerSideJPT, ownerSideAttribute, "manyToMany");
        if (isMap && this.getORMPersistentAttribute(resolvedOwnerSideAttribute) == null) {
            resolvedOwnerSideAttribute.getJavaPersistentAttribute().getResourceAttribute().addAnnotation(MapKeyAnnotation.ANNOTATION_NAME);
        }
        if (direction == 2) {
            PersistentAttribute resolvedInverseSideAttribute = this.setMappingKeyToAttribute(fp, inverseSideJPT, inverseSideAttibute, "manyToMany");
            String mappedByAttr = this.getMappeByAttribute(fp, ownerSideJPT, ownerSideAttribute);
            this.setMappedByAttribute(resolvedInverseSideAttribute, inverseSideJPT, mappedByAttr);
            if (isMap && this.getORMPersistentAttribute(resolvedInverseSideAttribute) == null) {
                resolvedInverseSideAttribute.getJavaPersistentAttribute().getResourceAttribute().addAnnotation(MapKeyAnnotation.ANNOTATION_NAME);
            }
        }
    }

    public void restoreEntityClass(PersistentType jpt, IJPAEditorFeatureProvider fp) {
        fp.restoreEntity(jpt);
    }

    public void forceSaveEntityClass(final PersistentType jpt, IJPAEditorFeatureProvider fp) {
        final ICompilationUnit cu = fp.getCompilationUnit(jpt);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        if (cu.isWorkingCopy()) {
                            cu.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        cu.save((IProgressMonitor)new NullProgressMonitor(), true);
                    }
                    catch (JavaModelException e) {
                        if (!cu.getResource().getProject().isAccessible() || !cu.getResource().isAccessible()) break block3;
                        JPADiagramEditorPlugin.logError("Cannot save entity '" + jpt.getName() + "'", e);
                    }
                }
            }
        });
    }

    public boolean deleteEntityClass(PersistentType jpt, IJPAEditorFeatureProvider fp) {
        ICompilationUnit cu = fp.getCompilationUnit(jpt);
        try {
            JPAEditorUtil.discardWorkingCopy(cu);
            cu.delete(true, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot delete the JPA entity class", e);
            return false;
        }
    }

    public void deletePersistenceTypeResource(PersistentType type) throws CoreException {
        JpaProject proj = type.getJpaProject();
        String typeName = type.getName();
        IResource entityResource = type.getResource();
        entityResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
        int cnt = 0;
        PersistentType jpt = this.getContextPersistentType(proj, typeName);
        while (jpt != null && cnt < 25) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Sleep interrupted", e);
            }
            ++cnt;
        }
    }

    public PersistentType getContextPersistentType(JpaProject jpaProject, String fullyQualifiedTypeName) {
        PersistenceUnit unit = this.getPersistenceUnit(jpaProject);
        for (ClassRef ref : unit.getClassRefs()) {
            JavaPersistentType jpt = ref.getJavaPersistentType();
            if (jpt == null || !jpt.getName().equals(fullyQualifiedTypeName)) continue;
            return ref.getJavaPersistentType();
        }
        return this.getOrmXmlPersistentTypeByName(jpaProject, fullyQualifiedTypeName);
    }

    public String getEntityName(PersistentType jpt) {
        if (jpt == null) {
            return "";
        }
        JavaResourceType jrpt = jpt.getJavaResourceType();
        if (jrpt == null) {
            return "";
        }
        String name = null;
        TypeMapping mapping = jpt.getMapping();
        if (mapping != null && Entity.class.isInstance(mapping)) {
            name = ((Entity)mapping).getSpecifiedName();
        }
        if (name == null) {
            name = jpt.getName();
        }
        return name;
    }

    public boolean hasEntitySpecifiedName(PersistentType jpt) {
        if (jpt == null) {
            return false;
        }
        TypeMapping jtm = this.getTypeMapping(jpt);
        if (jtm == null) {
            return false;
        }
        if (jtm instanceof Entity) {
            Entity mapping = (Entity)jtm;
            return mapping.getSpecifiedName() != null;
        }
        return false;
    }

    public boolean isAnyKindPersistentType(PersistentType jpt) {
        return this.isEntity(jpt) || this.isMappedSuperclass(jpt) || this.isEmbeddable(jpt);
    }

    public boolean isEntity(PersistentType jpt) {
        String mappingKey = this.getTypeMapping(jpt).getKey();
        return mappingKey == "entity";
    }

    public boolean isMappedSuperclass(PersistentType jpt) {
        String mappingKey = this.getTypeMapping(jpt).getKey();
        return mappingKey == "mappedSuperclass";
    }

    public boolean isEmbeddable(PersistentType jpt) {
        String mappingKey = this.getTypeMapping(jpt).getKey();
        return mappingKey == "embeddable";
    }

    public String getSpecifiedEntityName(PersistentType jpt) {
        TypeMapping jtm = this.getTypeMapping(jpt);
        if (jtm instanceof Entity) {
            Entity gje = (Entity)jtm;
            return gje.getSpecifiedName();
        }
        return jtm.getName();
    }

    public void renameEntity(PersistentType jpt, String newName) {
        TypeMapping jtm = this.getTypeMapping(jpt);
        if (jtm instanceof Entity) {
            Entity gje = (Entity)jtm;
            gje.setSpecifiedName(newName);
        }
    }

    public MappingFileRef getOrmXmlByForPersistentType(PersistentType type) {
        for (MappingFileRef mappingFileRef : type.getPersistenceUnit().getMappingFileRefs()) {
            if (mappingFileRef.getPersistentType(type.getName()) == null) continue;
            return mappingFileRef;
        }
        return null;
    }

    public PersistentType getOrmXmlPersistentTypeByName(JpaProject jpaProject, String fqnTypeName) {
        for (MappingFileRef mappingFileRef : this.getPersistenceUnit(jpaProject).getMappingFileRefs()) {
            PersistentType type = mappingFileRef.getPersistentType(fqnTypeName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public PersistentAttribute getORMPersistentAttribute(PersistentAttribute jpa) {
        PersistentType type = this.getOrmXmlPersistentTypeByName(jpa.getParent().getJpaProject(), jpa.getDeclaringPersistentType().getName());
        if (type == null) {
            return null;
        }
        for (PersistentAttribute attr : type.getAllAttributes()) {
            if (attr.getName() == null || !attr.getName().equals(jpa.getName())) continue;
            return attr;
        }
        return null;
    }

    public HasReferanceRelation findFisrtHasReferenceRelationByEmbeddable(PersistentType embeddable, IJPAEditorFeatureProvider fp) {
        HashSet<HasReferanceRelation> hasReferencesConnections = fp.getAllExistingHasReferenceRelations();
        for (HasReferanceRelation ref : hasReferencesConnections) {
            if (!ref.getEmbeddable().getName().equals(embeddable.getName()) || !this.isEntity(ref.getEmbeddingEntity())) continue;
            return ref;
        }
        return null;
    }

    public HashSet<PersistentType> findAllJPTWithTheGivenEmbeddedId(PersistentType embeddable, IJPAEditorFeatureProvider fp) {
        HashSet<PersistentType> embeddingEntities = new HashSet<PersistentType>();
        if (!this.isEmbeddable(embeddable)) {
            return embeddingEntities;
        }
        ListIterator lit = embeddable.getJpaProject().getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator();
        PersistenceUnit pu = (PersistenceUnit)lit.next();
        for (PersistentType jpt : pu.getPersistentTypes()) {
            if (jpt.getName().equals(embeddable.getName())) continue;
            for (PersistentAttribute jpa : jpt.getAttributes()) {
                if (!this.isEmbeddedId(jpa) || !JPAEditorUtil.getAttributeTypeNameWithGenerics(jpa).equals(embeddable.getName())) continue;
                embeddingEntities.add(jpt);
            }
        }
        return embeddingEntities;
    }

    public Set<HasReferanceRelation> findAllHasReferenceRelationsByEmbeddable(PersistentType embeddable, IJPAEditorFeatureProvider fp) {
        HashSet<HasReferanceRelation> allHasRefForEmbeddable = new HashSet<HasReferanceRelation>();
        HashSet<HasReferanceRelation> hasReferencesConnections = fp.getAllExistingHasReferenceRelations();
        for (HasReferanceRelation ref : hasReferencesConnections) {
            if (!ref.getEmbeddable().getName().equals(embeddable.getName()) && !ref.getEmbeddingEntity().getName().equals(embeddable.getName())) continue;
            allHasRefForEmbeddable.add(ref);
        }
        return allHasRefForEmbeddable;
    }

    public Set<HasReferanceRelation> findAllHasReferenceRelsByEmbeddableWithEntity(PersistentType embeddable, IJPAEditorFeatureProvider fp) {
        Set<HasReferanceRelation> allRefs = this.findAllHasReferenceRelationsByEmbeddable(embeddable, fp);
        HashSet<HasReferanceRelation> entityRefs = new HashSet<HasReferanceRelation>();
        for (HasReferanceRelation ref : allRefs) {
            if (!this.isEntity(ref.getEmbeddingEntity())) continue;
            entityRefs.add(ref);
        }
        return entityRefs;
    }

    public PersistentAttribute addAttribute(PersistentType jpt, PersistentType attributeType, String mapKeyType, String attributeName, String actName, boolean isCollection) {
        try {
            if (this.doesAttributeExist(jpt, actName)) {
                return jpt.resolveAttribute(attributeName);
            }
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannnot create a new attribute with name " + attributeName, e);
        }
        PersistentAttribute res = this.makeNewAttribute(jpt, attributeName, attributeType.getName(), actName, mapKeyType, null, null, isCollection);
        return res;
    }

    public boolean isCollection(AttributeMapping attributeMapping) {
        SpecifiedPersistentAttribute attribute = attributeMapping.getPersistentAttribute();
        String attributeType = attribute.getTypeName();
        if (attributeType == null) {
            PersistentType jpt = (PersistentType)attribute.getParent();
            JavaResourceType jrt = jpt.getJavaResourceType();
            jrt.getJavaResourceCompilationUnit().synchronizeWithJavaSource();
            attribute = jpt.getAttributeNamed(attribute.getName());
            attributeType = attribute.getTypeName();
        }
        return attributeType != null && (attributeType.equals("java.util.Collection") || attributeType.equals("java.util.List") || attributeType.equals("java.util.Set") || attributeType.equals("java.util.Map") || attributeType.endsWith("[]"));
    }

    public String createNewAttribute(PersistentType jpt, boolean isCollection, IJPAEditorFeatureProvider fp) {
        String newAttrName = this.genUniqueAttrName(jpt, "java.lang.String", fp);
        this.makeNewAttribute(jpt, newAttrName, "java.lang.String", newAttrName, "java.lang.String", null, null, isCollection);
        return newAttrName;
    }

    public PersistentAttribute makeNewAttribute(PersistentType jpt, String attrName, String attrTypeName, String actName, String mapKeyType, String[] attrTypes, List<String> annotations, boolean isCollection) {
        AddAttributeCommand createNewAttributeCommand = new AddAttributeCommand(jpt, attrTypeName, mapKeyType, attrName, actName, attrTypes, annotations, isCollection);
        try {
            this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)createNewAttributeCommand, SynchronousUiCommandContext.instance());
        }
        catch (InterruptedException e) {
            JPADiagramEditorPlugin.logError("Cannot create a new attribute with name " + attrName, e);
        }
        PersistentAttribute jpa = jpt.getAttributeNamed(attrName);
        if (jpa == null) {
            jpa = jpt.getAttributeNamed(actName);
        }
        return jpa;
    }

    public PersistentAttribute addOrmPersistentAttribute(PersistentType jpt, PersistentAttribute jpa, String mappingKey) {
        AddPersistentAttributeInOrmXMLCommand addpersAttrCommand = new AddPersistentAttributeInOrmXMLCommand(jpt, jpa, mappingKey);
        try {
            this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)addpersAttrCommand, SynchronousUiCommandContext.instance());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.getORMPersistentAttribute(jpa);
    }

    public void removeOrmPersistentAttribute(PersistentType jpt, String attributeName) {
        OrmPersistentType ormPersistentType;
        OrmPersistentAttribute ormReadOnlyAttribute;
        MappingFileRef ormXml = JpaArtifactFactory.instance().getOrmXmlByForPersistentType(jpt);
        if (ormXml != null && ormXml.getMappingFile() != null && (ormReadOnlyAttribute = (ormPersistentType = (OrmPersistentType)ormXml.getMappingFile().getPersistentType(jpt.getName())).getAttributeNamed(attributeName)) instanceof OrmSpecifiedPersistentAttribute) {
            ormPersistentType.removeAttributeFromXml((OrmSpecifiedPersistentAttribute)ormReadOnlyAttribute);
        }
        jpt.getJavaResourceType().getJavaResourceCompilationUnit().synchronizeWithJavaSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttribute(PersistentType jpt, String attributeName, IJPAEditorFeatureProvider fp) {
        PersistentType persistentType = jpt;
        synchronized (persistentType) {
            DeleteAttributeCommand deleteAttributeCommand = new DeleteAttributeCommand(jpt, attributeName, fp);
            try {
                this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)deleteAttributeCommand, SynchronousUiCommandContext.instance());
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Cannot delete attribute with name " + attributeName, e);
            }
        }
    }

    public String genUniqueAttrName(PersistentType jpt, String attrTypeName, IJPAEditorFeatureProvider fp) {
        String name2;
        ICompilationUnit ijl = fp.getCompilationUnit(jpt);
        IType type = null;
        type = ijl.findPrimaryType();
        HashSet<String> attrNames = new HashSet<String>();
        for (String name2 : jpt.getAttributeNames()) {
            attrNames.add(name2);
        }
        name2 = null;
        int i = 1;
        while (i < 10000000) {
            name2 = "attribute" + i;
            String attrNameWithCapitalLetter = JPAEditorUtil.capitalizeFirstLetter(name2);
            String getterName = "get" + attrNameWithCapitalLetter;
            String setterName = "set" + attrNameWithCapitalLetter;
            if (!attrNames.contains(name2)) {
                IField fld = type.getField(name2);
                IMethod getter = type.getMethod(getterName, new String[0]);
                IMethod setter1 = type.getMethod(setterName, new String[]{attrTypeName});
                IMethod setter2 = type.getMethod(setterName, new String[]{"QSet<Q" + attrTypeName + ";>;"});
                IMethod setter3 = type.getMethod(setterName, new String[]{"QCollection<Q" + attrTypeName + ";>;"});
                IMethod setter4 = type.getMethod(setterName, new String[]{"QSet;"});
                IMethod setter5 = type.getMethod(setterName, new String[]{"QCollection;"});
                if (!fld.exists() && !getter.exists() && !setter1.exists() && !setter2.exists() && !setter3.exists() && !setter4.exists() && !setter5.exists()) break;
            }
            ++i;
        }
        return name2;
    }

    public AttributeMapping getAttributeMapping(PersistentAttribute pa) {
        AttributeMapping mapping = null;
        if (pa != null) {
            PersistentAttribute rpa;
            PersistentType jpt = (PersistentType)pa.getParent();
            MappingFileRef ref = this.getOrmXmlByForPersistentType(jpt);
            mapping = ref != null ? ((rpa = ref.getPersistentType(jpt.getName()).getAttributeNamed(pa.getName())) != null ? rpa.getMapping() : pa.getMapping()) : pa.getMapping();
        }
        return mapping;
    }

    public TypeMapping getTypeMapping(PersistentType jpt) {
        TypeMapping typeMapping = null;
        if (jpt != null) {
            PersistentType pt;
            MappingFileRef ref = this.getOrmXmlByForPersistentType(jpt);
            typeMapping = ref != null ? ((pt = ref.getPersistentType(jpt.getName())) != null ? pt.getMapping() : jpt.getMapping()) : jpt.getMapping();
        }
        return typeMapping;
    }

    public List<String> getAnnotationStrings(PersistentAttribute persistentAttribite) {
        PersistentType jpt = (PersistentType)persistentAttribite.getParent();
        JavaResourceType jrt = jpt.getJavaResourceType();
        CompilationUnit jdtCU = jrt.getJavaResourceCompilationUnit().buildASTRoot();
        JavaResourceAttribute jrpt = persistentAttribite.getJavaPersistentAttribute().getResourceAttribute();
        LinkedList<String> res = new LinkedList<String>();
        for (Annotation an : jrpt.getTopLevelAnnotations()) {
            org.eclipse.jdt.core.dom.Annotation jdtAn = an.getAstAnnotation(jdtCU);
            res.add(jdtAn.toString());
        }
        return res;
    }

    private boolean isOwner(PersistentAttribute at) {
        AttributeMapping jam = this.getAttributeMapping(at);
        if (!(jam instanceof RelationshipMapping)) {
            return false;
        }
        return ((RelationshipMapping)jam).isRelationshipOwner();
    }

    private Collection<IRelation> produceAllIRelations(PersistentType newJPT, IJPAEditorFeatureProvider fp) {
        Collection<IRelation> res = this.produceIRelations(newJPT, null, fp);
        Iterator<IRelation> it = res.iterator();
        HashSet<PersistentType> checkedEntities = new HashSet<PersistentType>();
        while (it.hasNext()) {
            IRelation rel = it.next();
            checkedEntities.add(rel.getOwner());
            checkedEntities.add(rel.getInverse());
        }
        EList shapes = fp.getDiagramTypeProvider().getDiagram().getChildren();
        for (Shape sh : shapes) {
            PersistentType jpt = (PersistentType)fp.getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (jpt == null) continue;
            Collection<IRelation> rels = this.produceIRelations(jpt, newJPT, fp);
            res.addAll(rels);
        }
        return res;
    }

    public Collection<HasReferanceRelation> produceAllEmbeddedRelations(PersistentType jpt, IJPAEditorFeatureProvider fp) {
        Collection<HasReferanceRelation> res = this.produceEmbRelations(jpt, null, fp);
        Iterator<HasReferanceRelation> it = res.iterator();
        HashSet<PersistentType> checkedEntities = new HashSet<PersistentType>();
        while (it.hasNext()) {
            HasReferanceRelation rel = it.next();
            checkedEntities.add(rel.getEmbeddable());
            checkedEntities.add(rel.getEmbeddingEntity());
        }
        EList shapes = fp.getDiagramTypeProvider().getDiagram().getChildren();
        for (Shape sh : shapes) {
            PersistentType embeddingEntity = (PersistentType)fp.getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (embeddingEntity == null) continue;
            Collection<HasReferanceRelation> rels = this.produceEmbRelations(embeddingEntity, jpt, fp);
            res.addAll(rels);
        }
        return res;
    }

    private Collection<HasReferanceRelation> produceEmbRelations(PersistentType embeddingEntity, PersistentType embeddable, IJPAEditorFeatureProvider fp) {
        HashSet<HasReferanceRelation> resSet = new HashSet<HasReferanceRelation>();
        HasReferanceRelation res = null;
        for (PersistentAttribute embeddingAttribute : embeddingEntity.getAttributes()) {
            try {
                PersistentType embeddableClass;
                AttributeMapping attributeMapping = this.getAttributeMapping(embeddingAttribute);
                if (!(attributeMapping instanceof EmbeddedMapping) && !(attributeMapping instanceof ElementCollectionMapping2_0) && !(attributeMapping instanceof EmbeddedIdMapping)) continue;
                String attributeTypeName = this.getRelTypeName(embeddingAttribute);
                if (embeddable != null && !attributeTypeName.equals(embeddable.getName()) || (embeddableClass = this.findJPT(embeddingAttribute, fp, this.getRelTypeName(embeddingAttribute))) == null || (res = this.produceEmbeddedRelation(embeddingAttribute, attributeMapping, embeddableClass, fp)) == null) continue;
                resSet.add(res);
            }
            catch (Exception exception) {
                throw new RuntimeException();
            }
        }
        return resSet;
    }

    public IRelation produceIRelation(PersistentAttribute persistentAttribite, PersistentType jpt2, IJPAEditorFeatureProvider fp) {
        IRelation res = null;
        AttributeMapping attributeMapping = this.getAttributeMapping(persistentAttribite);
        if (attributeMapping instanceof RelationshipMapping) {
            if (jpt2 != null && !this.getRelTypeName(persistentAttribite).equals(jpt2.getName())) {
                return res;
            }
            PersistentType relJPT = this.findJPT(persistentAttribite, fp, this.getRelTypeName(persistentAttribite));
            if (relJPT != null) {
                res = this.produceRelation(persistentAttribite, attributeMapping, relJPT, fp);
            }
        }
        return res;
    }

    public PersistentType findJPT(PersistentAttribute persistentAttribite, IJPAEditorFeatureProvider fp, String typeName) {
        if (persistentAttribite == null) {
            return null;
        }
        PersistentType relJPT = (PersistentType)fp.getBusinessObjectForKey(typeName);
        return relJPT;
    }

    private Collection<IRelation> produceIRelations(PersistentType newJPT, PersistentType jpt2, IJPAEditorFeatureProvider fp) {
        HashSet<IRelation> res = new HashSet<IRelation>();
        for (PersistentAttribute at : newJPT.getAttributes()) {
            IRelation rel;
            if (at.getJavaPersistentAttribute() == null || (rel = this.produceIRelation(at, jpt2, fp)) == null) continue;
            res.add(rel);
        }
        return res;
    }

    public PersistentType getJPT(String name, PersistenceUnit pu) {
        PersistentType jpt = pu.getPersistentType(name);
        int cnt = 0;
        while (jpt == null && cnt < 25) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Sleep interrupted", e);
            }
            jpt = pu.getPersistentType(name);
            ++cnt;
        }
        return jpt;
    }

    public Set<PersistentAttribute> getRelatedAttributes(PersistentType jpt) {
        HashSet<PersistentAttribute> res = new HashSet<PersistentAttribute>();
        Iterator it = jpt.getJpaProject().getJpaFiles().iterator();
        PersistenceUnit pu = INSTANCE.getPersistenceUnit(jpt.getJpaProject());
        while (it.hasNext()) {
            Set<PersistentAttribute> relAts;
            String name;
            PersistentType jpt1;
            JavaResourceCompilationUnit jrcu;
            JavaResourceAbstractType jrt;
            JpaFile jpaFile = (JpaFile)it.next();
            JptResourceModel rm = jpaFile.getResourceModel();
            if (rm == null || !JavaResourceCompilationUnit.class.isInstance(rm) || (jrt = (jrcu = (JavaResourceCompilationUnit)rm).getPrimaryType()) == null || (jpt1 = pu.getPersistentType(name = jrt.getTypeBinding().getQualifiedName())) == null || (relAts = this.getRelAttributes(jpt, jpt1)) == null) continue;
            res.addAll(relAts);
        }
        return res;
    }

    private Set<PersistentAttribute> getRelAttributes(PersistentType jpt, PersistentType relJPT) {
        HashSet<PersistentAttribute> res = new HashSet<PersistentAttribute>();
        for (PersistentAttribute at : relJPT.getAttributes()) {
            String relTypeName;
            AttributeMapping attributeMapping = this.getAttributeMapping(at);
            if (!(attributeMapping instanceof RelationshipMapping) && !(attributeMapping instanceof EmbeddedMapping) && !(attributeMapping instanceof EmbeddedIdMapping) && !(attributeMapping instanceof ElementCollectionMapping2_0) || (relTypeName = this.getRelTypeName(at)) == null || !relTypeName.equals(jpt.getName())) continue;
            res.add(at);
        }
        return res;
    }

    public void renameEntityClass(PersistentType jpt, String newEntityName) {
        RenameEntityCommand renameEntityCommand = new RenameEntityCommand(jpt, newEntityName);
        try {
            this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)renameEntityCommand, SynchronousUiCommandContext.instance());
        }
        catch (InterruptedException e) {
            JPADiagramEditorPlugin.logError("Cannot rename entity " + jpt.getName(), e);
        }
    }

    public PersistentAttribute renameAttribute(PersistentType jpt, String oldName, String newName, String inverseEntityName, IJPAEditorFeatureProvider fp) throws InterruptedException {
        newName = JPAEditorUtil.decapitalizeFirstLetter(newName);
        if (this.isMethodAnnotated(jpt)) {
            newName = JPAEditorUtil.produceValidAttributeName(newName);
        }
        newName = JPAEditorUtil.produceUniqueAttributeName(jpt, newName);
        PersistenceUnit pu = null;
        Object oldAt = null;
        oldAt = jpt instanceof OrmPersistentType ? ((OrmPersistentType)jpt).getJavaPersistentType().getAttributeNamed(oldName) : jpt.getAttributeNamed(oldName);
        if (oldAt == null) {
            return null;
        }
        if (oldAt.getParent() == null) {
            oldAt.getDeclaringPersistentType();
        }
        fp.addAddIgnore((PersistentType)oldAt.getParent(), newName);
        fp.addRemoveIgnore((PersistentType)oldAt.getParent(), oldName);
        String attributeTypeName = this.getRelTypeName((PersistentAttribute)oldAt);
        RenameAttributeCommand renameAttributeCommand = new RenameAttributeCommand(jpt, oldName, newName);
        this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)renameAttributeCommand, SynchronousUiCommandContext.instance());
        PersistentAttribute newAt = jpt.getAttributeNamed(newName);
        if (newAt == null) {
            return null;
        }
        fp.addRemoveIgnore(jpt, oldName);
        try {
            fp.replaceAttribute((PersistentAttribute)oldAt, newAt);
        }
        catch (Exception exception) {
            return newAt;
        }
        this.updateIRelationshipAttributes(jpt, inverseEntityName, fp, pu, (PersistentAttribute)oldAt, newAt, attributeTypeName);
        return newAt;
    }

    private void updateIRelationshipAttributes(PersistentType jpt, String inverseEntityName, IJPAEditorFeatureProvider fp, PersistenceUnit pu, PersistentAttribute oldAt, PersistentAttribute newAt, String typeName) throws InterruptedException {
        Set<IRelation> rels = fp.getRelationRelatedToAttribute(oldAt, typeName);
        for (IRelation rel : rels) {
            this.updateRelationship(jpt, inverseEntityName, fp, pu, oldAt, newAt, rel);
        }
        HashSet<PersistentType> embeddingEntities = this.findAllJPTWithTheGivenEmbeddedId(jpt, fp);
        if (embeddingEntities != null && !embeddingEntities.isEmpty()) {
            this.renameMapsIdAttributeValue(oldAt, newAt, embeddingEntities);
        }
    }

    private void updateRelationship(PersistentType jpt, String inverseEntityName, IJPAEditorFeatureProvider fp, PersistenceUnit pu, PersistentAttribute oldAt, PersistentAttribute newAt, IRelation rel) throws InterruptedException {
        String inverseAttributeName = null;
        PersistentType inverseJPT = null;
        if (IBidirectionalRelation.class.isInstance(rel)) {
            inverseJPT = rel.getInverse();
            if (inverseJPT != oldAt.getParent()) {
                pu = INSTANCE.getPersistenceUnit(jpt);
                inverseAttributeName = rel.getInverseAttributeName();
            }
            if (!inverseJPT.getResource().exists()) {
                inverseJPT = (PersistentType)pu.getManagedType(inverseEntityName);
            }
        }
        if (inverseAttributeName != null) {
            SetMappedByNewValueCommand changeMappedByValueCommand = new SetMappedByNewValueCommand(fp, pu, inverseJPT.getName(), inverseAttributeName, newAt.getName(), oldAt);
            this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)changeMappedByValueCommand, SynchronousUiCommandContext.instance());
        }
        if (rel != null) {
            JavaPersistentType idClassJPT;
            this.updateRelation(jpt, fp, rel);
            if (this.hasIDClass(jpt) && (idClassJPT = this.getIdClassJPT(jpt)) != null && idClassJPT.getAttributeNamed(oldAt.getName()) != null) {
                RenameAttributeCommand renameAttributeCommand = new RenameAttributeCommand((PersistentType)idClassJPT, oldAt.getName(), newAt.getName());
                this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)renameAttributeCommand, SynchronousUiCommandContext.instance());
            }
        }
    }

    private void renameMapsIdAttributeValue(PersistentAttribute oldAt, PersistentAttribute newAt, HashSet<PersistentType> embeddingEntities) {
        for (PersistentType embeddingEntity : embeddingEntities) {
            for (PersistentAttribute attr : embeddingEntity.getAttributes()) {
                MapsIdDerivedIdentityStrategy2_0 strategy;
                String attributeName;
                DerivedIdentity2_0 identity;
                AttributeMapping attributeMapping = this.getAttributeMapping(attr);
                if (!(attributeMapping instanceof SingleRelationshipMapping2_0) || !(identity = ((SingleRelationshipMapping2_0)attributeMapping).getDerivedIdentity()).usesMapsIdDerivedIdentityStrategy() || (attributeName = (strategy = identity.getMapsIdDerivedIdentityStrategy()).getSpecifiedIdAttributeName()) == null || !attributeName.equals(oldAt.getName())) continue;
                strategy.setSpecifiedIdAttributeName(newAt.getName());
                Annotation ann = attr.getJavaPersistentAttribute().getResourceAttribute().getAnnotation(MapsIdAnnotation2_0.ANNOTATION_NAME);
                if (ann == null) continue;
                ((MapsIdAnnotation2_0)ann).setValue(newAt.getName());
            }
        }
    }

    private JpaProjectManager getJpaProjectManager() {
        return (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
    }

    private void updateRelation(PersistentType jpt, IJPAEditorFeatureProvider fp, IRelation rel) {
        PictogramElement peRel;
        if (!(rel.getInverse().getResource().exists() && rel.getOwner().getResource().exists() || (peRel = fp.getPictogramElementForBusinessObject(rel)) == null || !(peRel instanceof Connection))) {
            Graphiti.getPeService().deletePictogramElement(peRel);
        }
        UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(fp);
        if (jpt.equals(rel.getInverse())) {
            updateFeature.reconnect(rel.getOwner());
        } else {
            updateFeature.reconnect(rel.getInverse());
        }
    }

    private IRelation produceRelation(PersistentAttribute persistentAttribite, AttributeMapping an, PersistentType relJPT, IJPAEditorFeatureProvider fp) {
        Hashtable<PersistentAttribute, AttributeMapping> ht = this.getRelAttributeAnnotation(persistentAttribite, relJPT, fp);
        if (ht == null) {
            return this.produceUniDirRelation((PersistentType)persistentAttribite.getParent(), persistentAttribite, an, relJPT, fp);
        }
        PersistentAttribute relAt = ht.keys().nextElement();
        AttributeMapping relAn = ht.get(relAt);
        return this.produceBiDirRelation((PersistentType)persistentAttribite.getParent(), persistentAttribite, an, relJPT, relAt, relAn, fp);
    }

    private HasReferanceRelation produceEmbeddedRelation(PersistentAttribute embeddingAttribute, AttributeMapping an, PersistentType embeddable, IJPAEditorFeatureProvider fp) {
        if (!JPAEditorUtil.getCompilationUnit((PersistentType)embeddingAttribute.getParent()).exists()) {
            return null;
        }
        PersistentType embeddingEntity = (PersistentType)embeddingAttribute.getParent();
        String embeddedAttributeName = embeddingAttribute.getName();
        HasReferanceRelation res = null;
        if (an instanceof EmbeddedMapping || an instanceof EmbeddedIdMapping) {
            if (!fp.doesEmbeddedRelationExist(embeddable, embeddingEntity, embeddedAttributeName, HasReferanceRelation.HasReferenceType.SINGLE)) {
                res = new HasSingleReferenceRelation(embeddingEntity, embeddable);
            }
        } else if (an instanceof ElementCollectionMapping2_0 && !fp.doesEmbeddedRelationExist(embeddable, embeddingEntity, embeddedAttributeName, HasReferanceRelation.HasReferenceType.COLLECTION)) {
            res = new HasCollectionReferenceRelation(embeddingEntity, embeddable);
        }
        if (res != null) {
            res.setEmbeddedAnnotatedAttribute(embeddingAttribute);
        }
        return res;
    }

    private Hashtable<PersistentAttribute, AttributeMapping> getRelAttributeAnnotation(PersistentAttribute jpa, PersistentType relJPT, IJPAEditorFeatureProvider fp) {
        PersistentType jpt = (PersistentType)jpa.getParent();
        for (PersistentAttribute relEntAt : relJPT.getAttributes()) {
            String mappedByAttr;
            MappingRelationship mappingRel;
            AttributeMapping attributeMapping = this.getAttributeMapping(relEntAt);
            if (!(attributeMapping instanceof RelationshipMapping) || !((mappingRel = ((RelationshipMapping)attributeMapping).getRelationship()) instanceof MappedByRelationship) || (mappedByAttr = ((MappedByRelationship)mappingRel).getMappedByStrategy().getMappedByAttribute()) == null) continue;
            String[] mappedByStrings = mappedByAttr.split("\\.");
            if (mappedByStrings.length > 1) {
                jpt = this.getInvolvedEntity(fp, jpt, relEntAt, mappedByStrings);
            } else {
                String mappedBy = ((MappedByRelationship)mappingRel).getMappedByStrategy().getMappedByAttribute();
                if (!jpa.getName().equals(mappedBy)) continue;
            }
            String relTypeName = this.getRelTypeName(relEntAt);
            if (relTypeName != null && jpt != null && !relTypeName.equals(jpt.getName())) continue;
            Hashtable<PersistentAttribute, AttributeMapping> ht = new Hashtable<PersistentAttribute, AttributeMapping>();
            ht.put(relEntAt, attributeMapping);
            return ht;
        }
        return null;
    }

    private PersistentType getInvolvedEntity(IJPAEditorFeatureProvider fp, PersistentType jpt, PersistentAttribute relEntAt, String[] mappedByStrings) {
        PersistentType embeddedJPT;
        String mappedBy = mappedByStrings[0];
        PersistentType involvedEntity = this.findJPT(relEntAt, fp, this.getRelTypeName(relEntAt));
        if (involvedEntity == null) {
            return involvedEntity;
        }
        PersistentAttribute embeddedAttribute = involvedEntity.getAttributeNamed(mappedBy);
        if (embeddedAttribute != null && (embeddedJPT = this.findJPT(embeddedAttribute, fp, this.getRelTypeName(embeddedAttribute))) != null && jpt != null && embeddedJPT.getName().equals(jpt.getName())) {
            jpt = involvedEntity;
        }
        return jpt;
    }

    private IUnidirectionalRelation produceUniDirRelation(PersistentType jpt, PersistentAttribute at, AttributeMapping an, PersistentType relJPT, IJPAEditorFeatureProvider fp) {
        if (!this.isOwner(at) || !JPAEditorUtil.getCompilationUnit((PersistentType)at.getParent()).exists()) {
            return null;
        }
        IUnidirectionalRelation res = this.createUniDirRelationshipDependsOnTheType(jpt, at, relJPT, fp, an);
        if (res != null) {
            res.setAnnotatedAttribute(at);
        }
        return res;
    }

    private IUnidirectionalRelation createUniDirRelationshipDependsOnTheType(PersistentType jpt, PersistentAttribute at, PersistentType relJPT, IJPAEditorFeatureProvider fp, AttributeMapping attributeMapping) {
        AbstractRelation res = null;
        String attrName = at.getName();
        if (attributeMapping instanceof OneToOneMapping) {
            if (!fp.doesRelationExist(jpt, relJPT, attrName, null, IRelation.RelType.ONE_TO_ONE, IRelation.RelDir.UNI)) {
                res = new OneToOneUniDirRelation(fp, jpt, relJPT, attrName, false, false);
            }
        } else if (attributeMapping instanceof OneToManyMapping) {
            if (!fp.doesRelationExist(jpt, relJPT, attrName, null, IRelation.RelType.ONE_TO_MANY, IRelation.RelDir.UNI)) {
                res = new OneToManyUniDirRelation(fp, jpt, relJPT, attrName, false);
            }
        } else if (attributeMapping instanceof ManyToOneMapping) {
            if (!fp.doesRelationExist(jpt, relJPT, attrName, null, IRelation.RelType.MANY_TO_ONE, IRelation.RelDir.UNI)) {
                res = new ManyToOneUniDirRelation(fp, jpt, relJPT, attrName, false, false);
            }
        } else if (attributeMapping instanceof ManyToManyMapping && !fp.doesRelationExist(jpt, relJPT, attrName, null, IRelation.RelType.MANY_TO_MANY, IRelation.RelDir.UNI)) {
            res = new ManyToManyUniDirRelation(fp, jpt, relJPT, attrName, false);
        }
        return res;
    }

    private IBidirectionalRelation produceBiDirRelation(PersistentType jpt, PersistentAttribute at, AttributeMapping an, PersistentType relJPT, PersistentAttribute relAt, AttributeMapping relAn, IJPAEditorFeatureProvider fp) {
        IBidirectionalRelation res;
        if (!this.attributeMappingsMatch(an, relAn)) {
            return null;
        }
        if (an instanceof OneToManyMapping) {
            return this.produceBiDirRelation(relJPT, relAt, relAn, jpt, at, an, fp);
        }
        if (!this.isOwner(at) && !this.isOwner(relAt)) {
            return null;
        }
        if (an instanceof ManyToOneMapping && (!this.isOwner(at) || this.isOwner(relAt))) {
            return null;
        }
        if (an instanceof ManyToManyMapping) {
            if (this.isOwner(at) && this.isOwner(relAt)) {
                return null;
            }
            if (!this.isOwner(at)) {
                return this.produceBiDirRelation(relJPT, relAt, relAn, jpt, at, an, fp);
            }
        }
        String ownerAttrName = at.getName();
        String inverseAttrName = relAt.getName();
        AttributeMapping m = this.getAttributeMapping(relAt);
        if (m != null && m instanceof RelationshipMapping) {
            RelationshipMapping relMapping = (RelationshipMapping)m;
            MappingRelationship mappingRel = relMapping.getRelationship();
            if (!(mappingRel instanceof MappedByRelationship)) {
                return null;
            }
            String mappedBy = ((MappedByRelationship)mappingRel).getMappedByStrategy().getMappedByAttribute();
            if (mappedBy == null) {
                return null;
            }
        }
        if ((res = this.createBiDirRelationshipDependsOnTheType(jpt, relJPT, fp, an, ownerAttrName, inverseAttrName)) != null) {
            res.setOwnerAnnotatedAttribute(at);
            res.setInverseAnnotatedAttribute(relAt);
        }
        return res;
    }

    private IBidirectionalRelation createBiDirRelationshipDependsOnTheType(PersistentType jpt, PersistentType relJPT, IJPAEditorFeatureProvider fp, AttributeMapping attributeMapping, String ownerAttrName, String inverseAttrName) {
        AbstractRelation res = null;
        if (attributeMapping instanceof OneToOneMapping) {
            if (!fp.doesRelationExist(jpt, relJPT, ownerAttrName, inverseAttrName, IRelation.RelType.ONE_TO_ONE, IRelation.RelDir.BI)) {
                res = new OneToOneBiDirRelation(fp, jpt, relJPT, ownerAttrName, inverseAttrName, false, relJPT, false);
            }
        } else if (attributeMapping instanceof ManyToOneMapping) {
            if (!fp.doesRelationExist(jpt, relJPT, ownerAttrName, inverseAttrName, IRelation.RelType.MANY_TO_ONE, IRelation.RelDir.BI)) {
                res = new ManyToOneBiDirRelation(fp, jpt, relJPT, ownerAttrName, inverseAttrName, false, relJPT, false);
            }
        } else if (attributeMapping instanceof ManyToManyMapping && !fp.doesRelationExist(jpt, relJPT, ownerAttrName, inverseAttrName, IRelation.RelType.MANY_TO_MANY, IRelation.RelDir.BI)) {
            res = new ManyToManyBiDirRelation(fp, jpt, relJPT, ownerAttrName, inverseAttrName, false, relJPT);
        }
        return res;
    }

    private boolean attributeMappingsMatch(AttributeMapping an1Name, AttributeMapping an2Name) {
        if (an1Name instanceof OneToOneMapping && an2Name instanceof OneToOneMapping) {
            return true;
        }
        if (an1Name instanceof OneToManyMapping && an2Name instanceof ManyToOneMapping) {
            return true;
        }
        if (an1Name instanceof ManyToOneMapping && an2Name instanceof OneToManyMapping) {
            return true;
        }
        return an1Name instanceof ManyToManyMapping && an2Name instanceof ManyToManyMapping;
    }

    private boolean doesAttributeExist(PersistentType jpt, String name) throws JavaModelException {
        boolean exists = false;
        if (jpt.resolveAttribute(name) != null) {
            return true;
        }
        return exists;
    }

    public PersistenceUnit getPersistenceUnit(JpaFile jpaFile) {
        JpaProject jpaProject = jpaFile.getJpaProject();
        if (jpaProject == null) {
            return null;
        }
        return this.getPersistenceUnit(jpaProject);
    }

    public PersistenceUnit getPersistenceUnit(JpaProject project) {
        if (project.getContextRoot().getPersistenceXml() == null) {
            return null;
        }
        return (PersistenceUnit)project.getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
    }

    public PersistenceUnit getPersistenceUnit(PersistentType jpt) {
        return jpt.getPersistenceUnit();
    }

    public boolean isMethodAnnotated(PersistentAttribute attr) {
        return attr.getAccess() == AccessType.PROPERTY;
    }

    public boolean isMethodAnnotated(PersistentType jpt) {
        ListIterator li = jpt.getAttributes().iterator();
        if (!li.hasNext()) {
            return false;
        }
        return this.isMethodAnnotated((PersistentAttribute)li.next());
    }

    public void remakeRelations(IJPAEditorFeatureProvider fp, ContainerShape cs, PersistentType jpt) {
        if (cs == null) {
            cs = (ContainerShape)fp.getPictogramElementForBusinessObject(jpt);
        }
        if (cs == null) {
            return;
        }
        this.removeOldRelations(fp, cs);
        this.addNewRelations(fp, jpt);
    }

    public String getTableName(PersistentType jpt) {
        if (jpt == null) {
            return null;
        }
        TypeMapping typeMapping = this.getTypeMapping(jpt);
        String tableName = typeMapping.getPrimaryTableName();
        return tableName;
    }

    public void setTableName(PersistentType jpt, String tableName) {
        if (jpt == null) {
            return;
        }
        TypeMapping typeMapping = this.getTypeMapping(jpt);
        if (typeMapping instanceof Entity) {
            ((Entity)typeMapping).getTable().setSpecifiedName(tableName);
        }
    }

    private void removeOldRelations(IJPAEditorFeatureProvider fp, ContainerShape cs) {
        HashSet<RemoveContext> ctxs = new HashSet<RemoveContext>();
        for (Connection conn : Graphiti.getPeService().getAllConnections((AnchorContainer)cs)) {
            RemoveContext ctx = new RemoveContext((PictogramElement)conn);
            ctxs.add(ctx);
        }
        for (RemoveContext ctx : ctxs) {
            RemoveRelationFeature ft = new RemoveRelationFeature(fp);
            ft.remove((IRemoveContext)ctx);
        }
    }

    public void addNewRelations(IJPAEditorFeatureProvider fp, PersistentType jpt) {
        this.addIRelationships(fp, jpt);
        this.addEmbeddedRelation(fp, jpt);
        this.rearrangeIsARelations(fp);
    }

    private void addEmbeddedRelation(IJPAEditorFeatureProvider fp, PersistentType jpt) {
        Collection<HasReferanceRelation> newEmbeddedRels = this.produceAllEmbeddedRelations(jpt, fp);
        for (HasReferanceRelation rel : newEmbeddedRels) {
            this.addNewEmbeddedRelation(fp, rel);
        }
    }

    private void addIRelationships(IJPAEditorFeatureProvider fp, PersistentType jpt) {
        HashSet<IRelation> selfRels = new HashSet<IRelation>();
        Collection<IRelation> newRels = this.produceAllIRelations(jpt, fp);
        for (IRelation rel : newRels) {
            if (rel.getOwner() == rel.getInverse()) {
                selfRels.add(rel);
                continue;
            }
            this.addNewRelation(fp, rel);
        }
        for (IRelation rel : selfRels) {
            this.addNewRelation(fp, rel);
        }
    }

    public void addIsARelations(IJPAEditorFeatureProvider fp, Collection<IsARelation> rels) {
        for (IsARelation rel : rels) {
            this.addNewIsARelation(fp, rel);
        }
    }

    private void addNewRelation(IJPAEditorFeatureProvider fp, IRelation rel) {
        AddConnectionContext ctx = new AddConnectionContext(JPAEditorUtil.getAnchor(rel.getOwner(), fp), JPAEditorUtil.getAnchor(rel.getInverse(), fp));
        ctx.setNewObject((Object)rel);
        ctx.setTargetContainer((ContainerShape)fp.getDiagramTypeProvider().getDiagram());
        AddRelationFeature ft = new AddRelationFeature(fp);
        ft.add((IAddContext)ctx);
    }

    private void addNewIsARelation(IJPAEditorFeatureProvider fp, IsARelation rel) {
        AddConnectionContext ctx = new AddConnectionContext(JPAEditorUtil.getAnchor(rel.getSubclass(), fp), JPAEditorUtil.getAnchor(rel.getSuperclass(), fp));
        ctx.setNewObject((Object)rel);
        ctx.setTargetContainer((ContainerShape)fp.getDiagramTypeProvider().getDiagram());
        AddInheritedEntityFeature ft = new AddInheritedEntityFeature(fp);
        ft.add((IAddContext)ctx);
    }

    private void addNewEmbeddedRelation(IJPAEditorFeatureProvider fp, HasReferanceRelation rel) {
        AddConnectionContext ctx = new AddConnectionContext(JPAEditorUtil.getAnchor(rel.getEmbeddingEntity(), fp), JPAEditorUtil.getAnchor(rel.getEmbeddable(), fp));
        ctx.setNewObject((Object)rel);
        ctx.setTargetContainer((ContainerShape)fp.getDiagramTypeProvider().getDiagram());
        AddHasReferenceRelationFeature ft = new AddHasReferenceRelationFeature(fp);
        ft.add((IAddContext)ctx);
    }

    public String getRelTypeName(PersistentAttribute persistentAttribute) {
        String relTypeName = null;
        if (persistentAttribute != null) {
            AttributeMapping an = this.getAttributeMapping(persistentAttribute);
            if (!this.isCollection(an)) {
                relTypeName = persistentAttribute.getTypeName();
            }
            if (persistentAttribute.getJavaPersistentAttribute() == null) {
                persistentAttribute.getTypeName();
                return relTypeName;
            }
            JavaResourceAttribute jra = persistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
            try {
                boolean isMap = jra.getTypeBinding().getQualifiedName().equals("java.util.Map");
                relTypeName = jra.getTypeBinding().getTypeArgumentName(isMap ? 1 : 0);
            }
            catch (Exception exception) {}
            if (relTypeName == null && an != null && an instanceof RelationshipMapping) {
                relTypeName = ((RelationshipMapping)an).getFullyQualifiedTargetEntity();
            }
            if (relTypeName == null) {
                relTypeName = JPAEditorUtil.getAttributeTypeName(jra);
            }
        }
        return relTypeName;
    }

    public JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    public boolean hasIDClass(PersistentType jpt) {
        String idClass;
        TypeMapping mapping = this.getTypeMapping(jpt);
        return mapping instanceof Entity && (idClass = ((Entity)mapping).getIdClassReference().getIdClassName()) != null;
    }

    public JavaPersistentType getIdClassJPT(PersistentType jpt) {
        JavaPersistentType idClassType = null;
        TypeMapping mapping = this.getTypeMapping(jpt);
        if (mapping instanceof Entity && (idClassType = ((Entity)mapping).getIdClassReference().getIdClass()) == null) {
            String idClassFqn = ((Entity)mapping).getIdClassReference().getFullyQualifiedIdClassName();
            PersistentType idClassPersistentType = jpt.getPersistenceUnit().getPersistentType(idClassFqn);
            idClassType = idClassPersistentType instanceof OrmPersistentType ? ((OrmPersistentType)idClassPersistentType).getJavaPersistentType() : (JavaPersistentType)idClassPersistentType;
        }
        return idClassType;
    }

    public String getIdType(PersistentType jpt) {
        JavaPersistentType idClassJPT = this.getIdClassJPT(jpt);
        if (idClassJPT != null) {
            return idClassJPT.getName();
        }
        PersistentAttribute[] ids = this.getIds(jpt);
        if (ids.length == 0) {
            return null;
        }
        String type = this.getRelTypeName(ids[0]);
        String wrapper = JPAEditorUtil.getPrimitiveWrapper(type);
        return wrapper != null ? wrapper : type;
    }

    public PersistentAttribute[] getIds(PersistentType jpt) {
        ArrayList<PersistentAttribute> res = new ArrayList<PersistentAttribute>();
        for (PersistentAttribute at : jpt.getAttributes()) {
            if (!this.isId(at)) continue;
            res.add(at);
        }
        PersistentAttribute[] ret = new PersistentAttribute[res.size()];
        return res.toArray(ret);
    }

    public boolean hasOrInheritsPrimaryKey(PersistentType jpt) {
        Iterable attributes = jpt.getAllAttributes();
        for (PersistentAttribute at : attributes) {
            if (!this.isId(at)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrimaryKey(PersistentType jpt) {
        for (PersistentAttribute at : jpt.getAttributes()) {
            if (!this.isId(at)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSimplePk(PersistentType jpt) {
        for (PersistentAttribute at : jpt.getAttributes()) {
            if (!this.isSimpleId(at) || this.hasIDClass(jpt)) continue;
            return true;
        }
        return false;
    }

    private PersistentAttribute getSimplePkAttribute(PersistentType jpt) {
        for (PersistentAttribute jpa : jpt.getAttributes()) {
            if (!this.isSimpleId(jpa)) continue;
            return jpa;
        }
        return null;
    }

    public boolean isId(PersistentAttribute jpa) {
        return this.isSimpleId(jpa) || this.isEmbeddedId(jpa);
    }

    public boolean isSimpleId(PersistentAttribute jpa) {
        AttributeMapping attributeMapping = this.getAttributeMapping(jpa);
        return attributeMapping.getKey() == "id";
    }

    private boolean hasEmbeddedPk(PersistentType jpt) {
        for (PersistentAttribute at : jpt.getAttributes()) {
            if (!this.isEmbeddedId(at)) continue;
            return true;
        }
        return false;
    }

    private PersistentAttribute getEmbeddedIdAttribute(PersistentType jpt) {
        for (PersistentAttribute jpa : jpt.getAttributes()) {
            if (!this.isEmbeddedId(jpa)) continue;
            return jpa;
        }
        return null;
    }

    public boolean isEmbeddedId(PersistentAttribute jpa) {
        AttributeMapping attributeMapping = this.getAttributeMapping(jpa);
        return attributeMapping.getKey() == "embeddedId";
    }

    public boolean isEmbeddedAttribute(PersistentAttribute jpa) {
        AttributeMapping attributeMapping = this.getAttributeMapping(jpa);
        return attributeMapping.getKey() == "embedded";
    }

    public String getColumnName(PersistentAttribute jpa) {
        String columnName = null;
        AttributeMapping attributeMapping = this.getAttributeMapping(jpa);
        if (attributeMapping instanceof ColumnMapping) {
            columnName = ((ColumnMapping)attributeMapping).getColumn().getName();
        }
        return columnName;
    }

    public IColorConstant getForeground(JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot) {
        IColorConstant foreground = IColorConstant.WHITE;
        if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.MappedSupeclass)) {
            foreground = JPAEditorConstants.MAPPED_SUPERCLASS_BORDER_COLOR;
        } else if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Entity)) {
            foreground = JPAEditorConstants.ENTITY_BORDER_COLOR;
        } else if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Embeddable)) {
            foreground = JPAEditorConstants.EMBEDDABLE_BORDER_COLOR;
        }
        return foreground;
    }

    public IColorConstant getBackground(JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot) {
        IColorConstant background = IColorConstant.WHITE;
        if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.MappedSupeclass)) {
            background = JPAEditorConstants.MAPPED_SUPERCLASS_BACKGROUND;
        } else if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Entity)) {
            background = JPAEditorConstants.ENTITY_BACKGROUND;
        } else if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Embeddable)) {
            background = JPAEditorConstants.EMBEDDABLE_BACKGROUND;
        }
        return background;
    }

    public String getRenderingStyle(JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot) {
        String renderingStyle = "";
        if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.MappedSupeclass)) {
            renderingStyle = "green-white-gloss";
        } else if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Entity)) {
            renderingStyle = "blue-white-gloss";
        } else if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Embeddable)) {
            renderingStyle = "violet-white-gloss";
        }
        return renderingStyle;
    }

    public JPAEditorConstants.DIAGRAM_OBJECT_TYPE determineDiagramObjectType(PersistentType jpt) {
        if (this.isEntity(jpt)) {
            return JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Entity;
        }
        if (this.isMappedSuperclass(jpt)) {
            return JPAEditorConstants.DIAGRAM_OBJECT_TYPE.MappedSupeclass;
        }
        if (this.isEmbeddable(jpt)) {
            return JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Embeddable;
        }
        throw new IllegalArgumentException();
    }

    public String generateIdName(PersistentType jpt) {
        String name;
        String genName = name = "id";
        int i = 0;
        while (i < 10000000) {
            if (!this.hasAttributeNamed(jpt, genName)) {
                return genName;
            }
            genName = String.valueOf(name) + "_" + i;
            ++i;
        }
        return genName;
    }

    private boolean hasAttributeNamed(PersistentType jpt, String name) {
        Iterable hier = jpt.getAllAttributeNames();
        for (String atName : hier) {
            if (!name.equals(atName)) continue;
            return true;
        }
        return false;
    }

    public String getMappedSuperclassPackageDeclaration(PersistentType jpt) throws JavaModelException {
        String packageName = null;
        IPackageDeclaration[] packages = JPAEditorUtil.getCompilationUnit(jpt).getPackageDeclarations();
        if (packages.length > 0) {
            IPackageDeclaration packageDecl = packages[0];
            packageName = packageDecl.getElementName();
        }
        return packageName;
    }

    public void buildHierarchy(PersistentType superclass, PersistentType subclass, boolean build) {
        CreateEntityTypeHierarchy createNewAttributeCommand = new CreateEntityTypeHierarchy(superclass, subclass, build);
        try {
            this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)createNewAttributeCommand, SynchronousUiCommandContext.instance());
        }
        catch (InterruptedException e) {
            JPADiagramEditorPlugin.logError("Cannot create hierarchy of entity type " + subclass.getName(), e);
        }
    }

    public void calculateDerivedIdAttribute(PersistentType ownerJPT, PersistentType inverseJPT, PersistentAttribute ownerAttr) {
        String attributeType = null;
        if (this.hasSimplePk(inverseJPT)) {
            PersistentAttribute jpa = this.getSimplePkAttribute(inverseJPT);
            attributeType = JPAEditorUtil.getAttributeTypeNameWithGenerics(jpa);
        } else if (this.hasIDClass(inverseJPT)) {
            attributeType = this.getIdClassJPT(inverseJPT).getName();
        } else if (this.hasEmbeddedPk(inverseJPT)) {
            attributeType = JPAEditorUtil.getAttributeTypeNameWithGenerics(this.getEmbeddedIdAttribute(inverseJPT));
        }
        this.addAppropriateDerivedIdAnnotation(ownerJPT, inverseJPT, ownerAttr, attributeType);
    }

    private void addAppropriateDerivedIdAnnotation(PersistentType ownerJPT, PersistentType inverseJPT, PersistentAttribute ownerAttr, String inverseIdClassFQN) {
        boolean isXmlDefined;
        String annotationName = null;
        String mapsIdValue = null;
        boolean bl = isXmlDefined = this.getORMPersistentAttribute(ownerAttr) != null;
        if (this.hasIDClass(ownerJPT)) {
            annotationName = IdAnnotation.ANNOTATION_NAME;
            JavaPersistentType composedJPT = this.getIdClassJPT(ownerJPT);
            this.addDerivedIdAnnotation(ownerJPT, inverseJPT, ownerAttr, (PersistentType)composedJPT, inverseIdClassFQN, annotationName, isXmlDefined);
        } else if (this.hasEmbeddedPk(ownerJPT)) {
            annotationName = MapsIdAnnotation2_0.ANNOTATION_NAME;
            PersistentAttribute embeddedIdAttribute = this.getEmbeddedIdAttribute(ownerJPT);
            String embbeddedIdAttrType = this.getRelTypeName(embeddedIdAttribute);
            PersistentType composedJPT = this.getPersistenceUnit(ownerJPT).getPersistentType(embbeddedIdAttrType);
            mapsIdValue = this.addDerivedIdAnnotation(ownerJPT, inverseJPT, ownerAttr, composedJPT, inverseIdClassFQN, annotationName, isXmlDefined);
        } else if (this.hasSimplePk(ownerJPT)) {
            annotationName = MapsIdAnnotation2_0.ANNOTATION_NAME;
            if (!isXmlDefined) {
                ownerAttr.getJavaPersistentAttribute().getResourceAttribute().addAnnotation(annotationName);
            }
            mapsIdValue = this.getSimplePkAttribute(inverseJPT).getName();
        } else {
            annotationName = IdAnnotation.ANNOTATION_NAME;
            if (!isXmlDefined) {
                ownerAttr.getJavaPersistentAttribute().getResourceAttribute().addAnnotation(annotationName);
            }
        }
        this.addDerivedIdMapping(ownerAttr, mapsIdValue, annotationName);
        this.addJoinColumnIfNecessary(ownerAttr, inverseJPT);
    }

    private String addDerivedIdAnnotation(PersistentType ownerJPT, PersistentType inverseJPT, PersistentAttribute ownerAttr, PersistentType ownerIdClass, String inverseIdClassFQN, String annotationName, boolean isXmlDefined) {
        if (ownerIdClass != null && !inverseIdClassFQN.equals(ownerIdClass.getName())) {
            Annotation ann;
            String attributeType = JPAEditorUtil.returnSimpleName(inverseIdClassFQN);
            this.addFieldInCompositeKeyClass(inverseJPT, ownerAttr, ownerIdClass, attributeType);
            if (!isXmlDefined && (ann = ownerAttr.getJavaPersistentAttribute().getResourceAttribute().addAnnotation(annotationName)) != null && ann instanceof MapsIdAnnotation2_0) {
                ((MapsIdAnnotation2_0)ann).setValue(ownerAttr.getName());
            }
        } else if (!isXmlDefined) {
            ownerAttr.getJavaPersistentAttribute().getResourceAttribute().addAnnotation(annotationName);
        }
        return ownerAttr.getName();
    }

    private void addDerivedIdMapping(PersistentAttribute attr, String idAttributeName, String annotationName) {
        AttributeMapping attributeMapping = this.getAttributeMapping(attr);
        if (attributeMapping instanceof SingleRelationshipMapping2_0) {
            DerivedIdentity2_0 identity = ((SingleRelationshipMapping2_0)attributeMapping).getDerivedIdentity();
            if (annotationName.equals(IdAnnotation.ANNOTATION_NAME)) {
                identity.getIdDerivedIdentityStrategy().setValue(true);
            } else {
                identity.getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName(idAttributeName);
            }
        }
    }

    private void addFieldInCompositeKeyClass(PersistentType inverseJPT, PersistentAttribute ownerAttr, PersistentType fqnClass, String attributeTypeName) {
        if (fqnClass != null && fqnClass.getAttributeNamed(ownerAttr.getName()) == null) {
            PersistentAttribute attr = this.makeNewAttribute(fqnClass, ownerAttr.getName(), attributeTypeName, ownerAttr.getName(), null, null, null, false);
            PersistentAttribute ormAttr = JpaArtifactFactory.instance().addOrmPersistentAttribute(fqnClass, attr, "basic");
            if (ormAttr == null || ormAttr.isVirtual()) {
                attr.getJavaPersistentAttribute().setMappingKey("basic");
            }
        }
    }

    public void addPersistentTypeToORMXml(JpaProject jpaProject, String entityName, String mapping) {
        AddPersistentTypeToOrmXmlCommand renameAttributeCommand = new AddPersistentTypeToOrmXmlCommand(jpaProject, mapping, entityName);
        try {
            this.getJpaProjectManager().execute((org.eclipse.jpt.common.utility.command.Command)renameAttributeCommand, SynchronousUiCommandContext.instance());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void deletePersistentTypeFromORMXml(JpaProject jpaProject, PersistentType jpt) {
        PersistenceUnit unit = JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
        if (unit.getMappingFileRefsSize() == 0) {
            return;
        }
        MappingFileRef fileRef = (MappingFileRef)unit.getMappingFileRefs().iterator().next();
        if (fileRef == null) {
            return;
        }
        MappingFile ref = fileRef.getMappingFile();
        OrmXml ormXml = (OrmXml)ref;
        OrmManagedType type = ormXml.getRoot().getManagedType(jpt.getName());
        if (type != null) {
            ormXml.getRoot().removeManagedType(type);
        }
    }

    public IType getType(IJavaProject javaProject, String fqnClass) {
        try {
            IType type = javaProject.findType(fqnClass);
            return type;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }
}

