/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.dltk.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.dltk.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.PHPUnitSearchEngine;
import org.eclipse.php.phpunit.model.PHPUnitValidator;
import org.eclipse.php.phpunit.ui.ElementSelectionDialog;
import org.eclipse.php.phpunit.ui.wizards.PHPUnitFilteredTypesSelectionDialog;
import org.eclipse.php.phpunit.ui.wizards.PHPUnitMethodSelectionDialog;
import org.eclipse.php.phpunit.ui.wizards.PHPUnitWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TestCaseWizardPage
extends PHPUnitWizardPage {
    private boolean isClassOrMethodElementToTest = true;
    private static final String PAGE_NAME = "TestCaseWizardPage";
    private static final String TEST_SUFFIX = "Test";
    private IModelElement fElementToTest;
    private StringButtonDialogField fElementToTestField;
    private Label fElementToTestFileNameLabel;
    private IType[] PHP_UNIT_CASE_BASE_CLASS_CACHE;

    public TestCaseWizardPage() {
        super(PAGE_NAME);
        this.setTitle(PHPUnitMessages.PHPUnitWizardPage_5);
        this.setDescription(PHPUnitMessages.PHPUnitWizardPage_6);
        this.fSuperClassDialogField.setText("PHPUnit_Framework_TestCase");
        ElementToTestFieldAdapter elementAdapter = new ElementToTestFieldAdapter();
        this.fElementToTestField = new StringButtonDialogField((IStringButtonAdapter)elementAdapter);
        this.fElementToTestField.setDialogFieldListener((IDialogFieldListener)elementAdapter);
        this.fElementToTestField.setLabelText(PHPUnitMessages.TestCaseWizardPage_0);
        this.fElementToTestField.setButtonLabel(PHPUnitMessages.TestCaseWizardPage_1);
        this.fElementToTestStatus = new StatusInfo();
    }

    private IModelElement chooseElementToTest() {
        Object[] resultArray;
        IContainer root = this.getTestContainer();
        if (root == null) {
            return null;
        }
        IProject project = this.getTestContainer().getProject();
        Object dialog = null;
        IDLTKSearchScope searchScope = SearchEngine.createSearchScope((IModelElement)DLTKCore.create((IProject)project), (int)1);
        if (this.isClassOrMethodElementToTest) {
            dialog = new PHPUnitFilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), searchScope, 0, new TypeSelectionExtension(){

                public ITypeInfoFilterExtension getFilterExtension() {
                    return new ITypeInfoFilterExtension(){

                        public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                            int modifiers = typeInfoRequestor.getModifiers();
                            return !PHPFlags.isInterface((int)modifiers) && !PHPFlags.isNamespace((int)modifiers) && !PHPFlags.isAbstract((int)modifiers);
                        }
                    };
                }
            }, PHPLanguageToolkit.getDefault());
            dialog.setInitialPattern(".");
        } else {
            IMethod[] staticMethods;
            LinkedList<IMethod> staticOrGlobalMethods = new LinkedList<IMethod>();
            IMethod[] globalFunctions = PHPModelAccess.getDefault().findMethods(null, ISearchEngine.MatchRule.PREFIX, 8192, 0, searchScope, (IProgressMonitor)new NullProgressMonitor());
            if (globalFunctions != null) {
                staticOrGlobalMethods.addAll(Arrays.asList(globalFunctions));
            }
            if ((staticMethods = PHPModelAccess.getDefault().findMethods(null, ISearchEngine.MatchRule.PREFIX, 128, 8208, searchScope, (IProgressMonitor)new NullProgressMonitor())) != null) {
                staticOrGlobalMethods.addAll(Arrays.asList(staticMethods));
            }
            IMethod[] methodScope = staticOrGlobalMethods.toArray(new IMethod[staticOrGlobalMethods.size()]);
            dialog = new PHPUnitMethodSelectionDialog(this.getShell(), methodScope);
        }
        dialog.setTitle(PHPUnitMessages.TestCaseWizardPage_2);
        dialog.setMessage(PHPUnitMessages.TestCaseWizardPage_3);
        if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
            return (IModelElement)resultArray[0];
        }
        return null;
    }

    @Override
    protected IType chooseSuperClass() {
        IContainer root = this.getTestContainer();
        if (root == null) {
            return null;
        }
        Shell shell = this.getShell();
        IProject project = root.getProject();
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        this.findTestCases(scriptProject);
        if (this.PHP_UNIT_CASE_BASE_CLASS_CACHE != null && this.PHP_UNIT_CASE_BASE_CLASS_CACHE.length > 0) {
            Object[] resultArray;
            ElementSelectionDialog dialog = new ElementSelectionDialog(shell, this.PHP_UNIT_CASE_BASE_CLASS_CACHE);
            dialog.setTitle(PHPUnitMessages.PHPUnitWizardPage_10);
            dialog.setMessage(PHPUnitMessages.PHPUnitWizardPage_11);
            if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
                return (IType)resultArray[0];
            }
        }
        return null;
    }

    private void findTestCases(IScriptProject scriptProject) {
        if (this.PHP_UNIT_CASE_BASE_CLASS_CACHE == null) {
            PHPUnitSearchEngine searchEngine = new PHPUnitSearchEngine(scriptProject);
            ArrayList elementsList = new ArrayList();
            try {
                IWizardContainer container = this.getContainer();
                if (container != null && this.getControl() != null) {
                    this.getWizard().getContainer().run(true, true, pm -> {
                        pm.beginTask(PHPUnitMessages.PHPUnitSearchEngine_Searching, -1);
                        List<IType> elements = searchEngine.findPHPUnitClassesByTestCase((IModelElement)scriptProject, true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)-1));
                        elementsList.addAll(elements);
                        pm.done();
                    });
                    if (!elementsList.isEmpty()) {
                        this.PHP_UNIT_CASE_BASE_CLASS_CACHE = elementsList.toArray(new IType[elementsList.size()]);
                    }
                }
            }
            catch (InterruptedException | InvocationTargetException e) {
                PHPUnitPlugin.log(e);
            }
        }
        ArrayList<IType> nonAbstractElementsList = new ArrayList<IType>();
        try {
            if (this.PHP_UNIT_CASE_BASE_CLASS_CACHE != null) {
                IType[] iTypeArray = this.PHP_UNIT_CASE_BASE_CLASS_CACHE;
                int n = this.PHP_UNIT_CASE_BASE_CLASS_CACHE.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (!PHPFlags.isAbstract((int)type.getFlags())) {
                        nonAbstractElementsList.add(type);
                    }
                    ++n2;
                }
            }
        }
        catch (ModelException e) {
            PHPUnitPlugin.log(e);
        }
    }

    @Override
    protected void superClassChanged() {
        super.superClassChanged();
        if (!this.fSuperClassStatus.isOK()) {
            return;
        }
        StatusInfo status = new StatusInfo();
        String elementName = this.getSuperClassName();
        IContainer root = this.getTestContainer();
        if (this.PHP_UNIT_CASE_BASE_CLASS_CACHE == null && root != null) {
            this.findTestCases(DLTKCore.create((IProject)root.getProject()));
        }
        boolean result = false;
        if (this.PHP_UNIT_CASE_BASE_CLASS_CACHE != null) {
            IType[] iTypeArray = this.PHP_UNIT_CASE_BASE_CLASS_CACHE;
            int n = this.PHP_UNIT_CASE_BASE_CLASS_CACHE.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (type.getElementName().equals(elementName)) {
                    result = true;
                }
                ++n2;
            }
            if (!result) {
                status.setError(PHPUnitMessages.PHPUnitWizardPage_21);
            }
        }
        this.fSuperClassStatus = status;
        this.updateStatus(this.getStatusList());
    }

    @Override
    protected void containerChanged() {
        super.containerChanged();
        if (this.getTestContainer() != null) {
            this.elementToTestChanged();
        }
    }

    @Override
    protected void createElementToTestControls(Composite composite, int nColumns) {
        this.createSeparator(composite, nColumns);
        new Label(composite, 0);
        Composite selectionContainer = new Composite(composite, 0);
        RowLayout rowLayout = new RowLayout();
        selectionContainer.setLayout((Layout)rowLayout);
        rowLayout.spacing = 10;
        Button clasOrFunctionElementToTestButton = new Button(selectionContainer, 16);
        clasOrFunctionElementToTestButton.setText(PHPUnitMessages.TestCaseWizardPage_5);
        clasOrFunctionElementToTestButton.setSelection(this.isClassOrMethodElementToTest);
        clasOrFunctionElementToTestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseWizardPage.this.isClassOrMethodElementToTest = true;
                TestCaseWizardPage.this.fElementToTest = null;
                TestCaseWizardPage.this.elementToTestChanged();
            }
        });
        Button newPHPBlockBtn = new Button(selectionContainer, 16);
        newPHPBlockBtn.setText(PHPUnitMessages.TestCaseWizardPage_4);
        newPHPBlockBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseWizardPage.this.isClassOrMethodElementToTest = false;
                TestCaseWizardPage.this.fElementToTest = null;
                TestCaseWizardPage.this.elementToTestChanged();
            }
        });
        new Label(composite, 0);
        this.fElementToTestField.doFillIntoGrid(composite, nColumns);
        Text text = this.fElementToTestField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        new Label(composite, 0);
        this.fElementToTestFileNameLabel = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.fElementToTestFileNameLabel.setLayoutData((Object)gridData);
        LayoutUtil.setWidthHint((Control)this.fElementToTestFileNameLabel, (int)this.getMaxFieldWidth());
        IModelElement elementToTest = this.getElementToTest();
        if (elementToTest != null) {
            this.setClassName(elementToTest.getElementName() + this.testSuffix());
        }
    }

    @Override
    protected void setFocus() {
        this.fElementToTestField.setFocus();
    }

    @Override
    protected String defaultSuperClass() {
        return "PHPUnit_Framework_TestCase";
    }

    private void elementToTestButtonPressed(DialogField field) {
        IModelElement codeData = this.chooseElementToTest();
        if (codeData != null) {
            this.setElementToTest(codeData);
        }
    }

    protected void elementToTestChanged() {
        String elementToTestName;
        StatusInfo status = new StatusInfo();
        Object element = this.fElementToTest;
        if (this.fElementToTest == null || !this.fElementToTest.getElementName().equals(this.fElementToTestField.getText())) {
            this.fElementToTest = null;
            element = this.fElementToTestField.getText();
        }
        Object finalElementToTest = element;
        try {
            if (this.getContainer() != null && this.getContainer().getCurrentPage() != null && this.getContainer().getCurrentPage().isPageComplete()) {
                this.getContainer().run(true, true, pm -> {
                    pm.beginTask(PHPUnitMessages.PHPUnitSearchEngine_Searching, -1);
                    int elementTypeToValidate = this.isClassOrMethodElementToTest ? 7 : 9;
                    this.fElementToTest = PHPUnitValidator.validateElement(finalElementToTest, this.getTestContainer() != null ? this.getTestContainer().getProject() : null, false, elementTypeToValidate, status);
                    pm.done();
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            PHPUnitPlugin.log(e);
        }
        String string = elementToTestName = this.fElementToTest != null ? this.fElementToTest.getPath().lastSegment() : "";
        if (this.fElementToTestFileNameLabel != null && !this.fElementToTestFileNameLabel.isDisposed()) {
            this.fElementToTestFileNameLabel.setText(elementToTestName);
        }
        this.fClassNameProposal = (this.fElementToTest != null ? this.fElementToTest.getElementName() : this.fElementToTestField.getText()) + this.testSuffix();
        if (!this.fClassNameManual && this.fClassNameDialogField != null) {
            this.fClassNameDialogField.setText(this.fClassNameProposal);
        }
        this.fElementToTestStatus = status;
        this.updateStatus(this.getStatusList());
    }

    private void elementToTestFieldChanged(DialogField field) {
        this.elementToTestChanged();
    }

    public IModelElement getElementToTest() {
        return this.fElementToTest;
    }

    public String getElementToTestName() {
        return this.fElementToTestField.getText().trim();
    }

    @Override
    protected IStatus[] getStatusList() {
        return new IStatus[]{this.fContainerStatus, this.fClassNameStatus, this.fFileNameStatus, this.fElementToTestStatus, this.fSuperClassStatus};
    }

    @Override
    public Object init(IStructuredSelection selection) {
        Object result = super.init(selection);
        if (result instanceof IType && !(result instanceof ISourceModule)) {
            this.setElementToTest((IModelElement)((IType)result));
        }
        return result;
    }

    public void setElementToTest(IModelElement codeData) {
        this.fElementToTest = codeData;
        String elementName = "";
        if (codeData != null) {
            elementName = codeData.getElementName();
        }
        this.fElementToTestField.setText(elementName);
    }

    @Override
    protected String testSuffix() {
        return TEST_SUFFIX;
    }

    @Override
    protected void invalidatCachedElements() {
        this.PHP_UNIT_CASE_BASE_CLASS_CACHE = null;
    }

    class ElementToTestFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        ElementToTestFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            TestCaseWizardPage.this.elementToTestButtonPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            TestCaseWizardPage.this.elementToTestFieldChanged(field);
        }
    }
}

