/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.narcissus;

import io.github.toolfactory.narcissus.Narcissus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

class LibraryLoader {
    public static final OperatingSystem OS;
    public static int archBits;
    public static String archName;
    public static String archType;

    LibraryLoader() {
    }

    static void loadLibraryFromJar(String libraryResourcePath) {
        File tempFile = null;
        boolean tempFileIsPosix = false;
        Exception exception = null;
        try (InputStream inputSream = Narcissus.class.getResourceAsStream(libraryResourcePath.startsWith("/") ? libraryResourcePath : "/" + libraryResourcePath);){
            if (inputSream == null) {
                throw new FileNotFoundException("Could not find library within jar: " + libraryResourcePath);
            }
            String filename = libraryResourcePath.substring(libraryResourcePath.lastIndexOf(47) + 1);
            int dotIdx = filename.indexOf(46);
            String baseName = dotIdx < 0 ? filename : filename.substring(0, dotIdx);
            String suffix = dotIdx < 0 ? ".so" : filename.substring(dotIdx);
            tempFile = File.createTempFile(baseName + "_", suffix);
            tempFile.deleteOnExit();
            try {
                if (tempFile.toPath().getFileSystem().supportedFileAttributeViews().contains("posix")) {
                    tempFileIsPosix = true;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            byte[] buffer = new byte[8192];
            try (FileOutputStream os = new FileOutputStream(tempFile);){
                int readBytes;
                while ((readBytes = inputSream.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, readBytes);
                }
            }
            System.load(tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            exception = e;
        }
        if (tempFile != null && tempFileIsPosix) {
            tempFile.delete();
        }
        if (exception != null) {
            throw new RuntimeException("Could not load library " + libraryResourcePath + " : " + exception);
        }
    }

    static {
        String osArch;
        archName = "";
        String osName = null;
        try {
            osName = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        OS = osName == null ? OperatingSystem.Unknown : (osName.contains("mac") || osName.contains("darwin") ? OperatingSystem.MacOSX : (osName.contains("win") ? OperatingSystem.Windows : (osName.contains("nux") ? OperatingSystem.Linux : (osName.contains("sunos") || osName.contains("solaris") ? OperatingSystem.Solaris : (osName.contains("bsd") ? OperatingSystem.Unix : (osName.contains("nix") || osName.contains("aix") ? OperatingSystem.Unix : OperatingSystem.Unknown))))));
        if (OS == OperatingSystem.MacOSX && "aarch64".equals(System.getProperty("os.arch"))) {
            archName = "arm";
        }
        if ((osArch = System.getProperty("os.arch")) != null && "aarch64".equals(osArch)) {
            archType = "arm64";
        } else {
            archBits = 64;
            String dataModel = System.getProperty("sun.arch.data.model");
            if (dataModel != null && dataModel.contains("32")) {
                archBits = 32;
                archType = "x86";
            } else if (osArch != null && (osArch.contains("86") && !osArch.contains("64") || osArch.contains("32"))) {
                archBits = 32;
                archType = "x86";
            } else {
                archType = "x64";
            }
        }
        if ("arm64".equals(archType)) {
            archBits = 64;
        }
    }

    static enum OperatingSystem {
        Windows,
        MacOSX,
        Linux,
        Solaris,
        BSD,
        Unix,
        Unknown;

    }
}

