/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch.setup;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.debug.ui.launch.setup.SetupWizardDialog;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

class WizardLoginPage
extends WizardPage
implements Listener {
    private static final String PREF_PROTOCOL = "setup.login.protocol";
    private static final String PREF_HOST = "setup.login.host";
    private static final String PREF_USER = "setup.login.user";
    private final SetupWizardDialog wizard;
    final String[] protocols = new String[]{"Telnet", "SSH"};
    Combo protocol;
    Button prefs;
    Text host;
    Text user;
    Text user_password;
    Text root_password;

    WizardLoginPage(SetupWizardDialog wizard) {
        super("LoginPage");
        this.wizard = wizard;
        this.setTitle("Remote TCF agent configuration");
        this.setDescription("Enter remote host login data");
    }

    public void handleEvent(Event event) {
        this.getContainer().updateButtons();
        IEclipsePreferences n = InstanceScope.INSTANCE.getNode("org.eclipse.tcf.debug.ui");
        n.put(PREF_PROTOCOL, this.protocol.getText());
        n.put(PREF_HOST, this.host.getText());
        n.put(PREF_USER, this.user.getText());
        this.root_password.setEnabled(!this.user.getText().equals("root"));
        this.prefs.setEnabled(this.protocol.getText().equals(this.protocols[1]));
    }

    public void createControl(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        composite.setLayout((Layout)gl);
        new Label(composite, 0).setText("Protocol:");
        this.protocol = new Combo(composite, 2056);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        this.protocol.setLayoutData((Object)gd);
        this.protocol.setItems(this.protocols);
        this.protocol.addListener(13, (Listener)this);
        this.prefs = new Button(composite, 8);
        this.prefs.setText("Preferences");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.widthHint = 100;
        this.prefs.setLayoutData((Object)gd);
        this.prefs.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent n) {
                WizardLoginPage.this.openProtocolPreferences(parent.getShell(), WizardLoginPage.this.prefs.getText());
            }
        });
        new Label(composite, 0).setText("Host:");
        this.host = new Text(composite, 2048);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 1;
        gd.widthHint = 200;
        this.host.setLayoutData((Object)gd);
        this.host.addListener(2, (Listener)this);
        new Label(composite, 0).setText("User:");
        this.user = new Text(composite, 2048);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 1;
        gd.widthHint = 200;
        this.user.setLayoutData((Object)gd);
        this.user.addListener(2, (Listener)this);
        new Label(composite, 0).setText("Password:");
        this.user_password = new Text(composite, 0x400800);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 1;
        gd.widthHint = 200;
        this.user_password.setLayoutData((Object)gd);
        this.user_password.addListener(2, (Listener)this);
        new Label(composite, 0).setText("Root password:");
        this.root_password = new Text(composite, 0x400800);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 1;
        gd.widthHint = 200;
        this.root_password.setLayoutData((Object)gd);
        this.root_password.addListener(2, (Listener)this);
        IEclipsePreferences d = DefaultScope.INSTANCE.getNode("org.eclipse.tcf.debug.ui");
        d.put(PREF_PROTOCOL, this.protocols[0]);
        IEclipsePreferences[] n = new IEclipsePreferences[]{InstanceScope.INSTANCE.getNode("org.eclipse.tcf.debug.ui"), d};
        IPreferencesService s = Platform.getPreferencesService();
        this.protocol.setText(s.get(PREF_PROTOCOL, "", (Preferences[])n));
        this.host.setText(s.get(PREF_HOST, "", (Preferences[])n));
        this.user.setText(s.get(PREF_USER, "", (Preferences[])n));
        this.root_password.setEnabled(!this.user.getText().equals("root"));
        this.prefs.setEnabled(this.protocol.getText().equals(this.protocols[1]));
        this.setControl((Control)composite);
    }

    private void openProtocolPreferences(Shell shell, String title) {
        try {
            PreferenceManager mgr = new PreferenceManager();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "preferencePages");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] e = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < e.length) {
                    String cnm;
                    String nm = e[j].getName();
                    if (nm.equals("page") && (cnm = e[j].getAttribute("class")) != null && cnm.startsWith("org.eclipse.jsch.")) {
                        String id = e[j].getAttribute("id");
                        if (id == null) {
                            id = cnm;
                        }
                        Bundle bundle = Platform.getBundle((String)extensions[i].getNamespaceIdentifier());
                        Class c = bundle.loadClass(cnm);
                        IPreferencePage page = (IPreferencePage)c.newInstance();
                        String pnm = e[j].getAttribute("name");
                        if (pnm != null) {
                            page.setTitle(pnm);
                        }
                        mgr.addToRoot((IPreferenceNode)new PreferenceNode(id, page));
                    }
                    ++j;
                }
                ++i;
            }
            PreferenceDialog dialog = new PreferenceDialog(shell, mgr);
            dialog.create();
            dialog.setMessage(title);
            dialog.open();
        }
        catch (Throwable err) {
            String msg = err.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = err.getClass().getName();
            }
            MessageBox mb = new MessageBox(shell, 33);
            mb.setText("Error");
            mb.setMessage("Cannot open preferences dialog:\n" + msg);
            mb.open();
        }
    }

    public IWizardPage getNextPage() {
        if (!(this.host.getText().length() <= 0 || this.user.getText().length() <= 0 || this.user_password.getText().length() <= 0 && !this.protocol.getText().equals("SSH") || this.root_password.isEnabled() && this.root_password.getText().length() <= 0)) {
            return this.wizard.getPage("LogPage");
        }
        return null;
    }
}

