/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.destroy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.destroy.IDestroyerDependencyCollector;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.CollaborationHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.OccurrenceSpecificationHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.UMLService;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.UMLTemporalHelper;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PartDecomposition;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDependencyCollector
implements IDestroyerDependencyCollector {
    private final ECrossReferenceAdapter crossReferenceAdapter;

    public ElementDependencyCollector(ECrossReferenceAdapter theCrossReferenceAdapter) {
        this.crossReferenceAdapter = theCrossReferenceAdapter;
    }

    @Override
    public Set<EObject> collectDependencies(EObject source) {
        DestroyDependencyCollectorSwitch collector = new DestroyDependencyCollectorSwitch(this.crossReferenceAdapter);
        collector.doSwitch(source);
        return collector.getDependentsToRemove();
    }

    static class DestroyDependencyCollectorSwitch
    extends UMLSwitch<Void> {
        private final ECrossReferenceAdapter crossReferenceAdapter;
        private final Set<EObject> dependentsToRemove = new HashSet<EObject>();

        DestroyDependencyCollectorSwitch(ECrossReferenceAdapter crossReferenceAdapter) {
            this.crossReferenceAdapter = crossReferenceAdapter;
        }

        private void safeAdd(Element value) {
            if (value != null) {
                this.dependentsToRemove.add((EObject)value);
            }
        }

        public Void caseNamedElement(NamedElement namedElementToDelete) {
            for (DirectedRelationship directedRelationship : namedElementToDelete.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getDependency())) {
                if (!directedRelationship.getSources().contains((Object)namedElementToDelete)) continue;
                this.dependentsToRemove.add((EObject)directedRelationship);
            }
            for (DirectedRelationship directedRelationship : namedElementToDelete.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getDependency())) {
                if (!directedRelationship.getTargets().contains((Object)namedElementToDelete)) continue;
                this.dependentsToRemove.add((EObject)directedRelationship);
            }
            return (Void)super.caseNamedElement(namedElementToDelete);
        }

        public Void caseActivityNode(ActivityNode activityNodeToDelete) {
            this.dependentsToRemove.addAll((Collection<EObject>)activityNodeToDelete.getOutgoings());
            this.dependentsToRemove.addAll((Collection<EObject>)activityNodeToDelete.getIncomings());
            return (Void)super.caseActivityNode(activityNodeToDelete);
        }

        public Void caseConnectorEnd(ConnectorEnd connectorEndToDelete) {
            Connector connector = (Connector)connectorEndToDelete.getOwner();
            if (connector.getEnds().size() <= 2) {
                this.dependentsToRemove.add((EObject)connector);
            }
            return (Void)super.caseConnectorEnd(connectorEndToDelete);
        }

        public Void caseProperty(Property propertyToDelete) {
            EReference[] refs = null;
            refs = new EReference[]{UMLPackage.eINSTANCE.getConnectorEnd_Role(), UMLPackage.eINSTANCE.getConnectorEnd_PartWithPort()};
            Collection<EObject> connectorEndRefs = UMLService.getReferencers((EObject)propertyToDelete, refs, this.crossReferenceAdapter);
            this.dependentsToRemove.addAll(connectorEndRefs);
            refs = new EReference[]{UMLPackage.eINSTANCE.getAssociation_MemberEnd()};
            Collection<EObject> associationRefs = UMLService.getReferencers((EObject)propertyToDelete, refs, this.crossReferenceAdapter);
            for (EObject association : associationRefs) {
                ArrayList remainingMembers = new ArrayList();
                remainingMembers.addAll(((Association)association).getMemberEnds());
                if (remainingMembers.size() > 2) continue;
                this.dependentsToRemove.add(association);
            }
            return (Void)super.caseProperty(propertyToDelete);
        }

        public Void caseElement(Element object) {
            object.getStereotypeApplications().stream().filter(EObject.class::isInstance).map(EObject.class::cast).forEach(this.dependentsToRemove::add);
            return (Void)super.caseElement(object);
        }

        public Void caseClassifier(Classifier classifierToDelete) {
            this.dependentsToRemove.addAll((Collection<EObject>)classifierToDelete.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization()));
            this.dependentsToRemove.addAll((Collection<EObject>)classifierToDelete.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization()));
            for (Association association : classifierToDelete.getAssociations()) {
                for (Property end : association.getMemberEnds()) {
                    if (end.getType() != classifierToDelete) continue;
                    this.dependentsToRemove.add((EObject)association);
                }
            }
            return (Void)super.caseClassifier(classifierToDelete);
        }

        public Void casePackage(Package object) {
            this.crossReferenceAdapter.getInverseReferences((EObject)object, true).stream().filter(s -> s.getEStructuralFeature() == UMLPackage.eINSTANCE.getPackageImport_ImportedPackage() || s.getEStructuralFeature() == UMLPackage.eINSTANCE.getPackageMerge_MergedPackage()).map(s -> s.getEObject()).forEach(this.dependentsToRemove::add);
            return (Void)super.casePackage(object);
        }

        public Void caseCollaboration(Collaboration collaborationToDelete) {
            this.dependentsToRemove.addAll(CollaborationHelper.getRelatedRoleBindings(collaborationToDelete, null, this.crossReferenceAdapter));
            return (Void)super.caseCollaboration(collaborationToDelete);
        }

        public Void caseIntervalConstraint(IntervalConstraint interval) {
            ValueSpecification valueSpecification = interval.getSpecification();
            if (valueSpecification instanceof Interval) {
                Interval value = (Interval)valueSpecification;
                for (ValueSpecification terminal : List.of(value.getMin(), value.getMax())) {
                    if (terminal == null || !UMLService.isOnlyUsage((EObject)terminal, (EObject)value, this.crossReferenceAdapter)) continue;
                    this.dependentsToRemove.add((EObject)terminal);
                }
            }
            return (Void)super.caseIntervalConstraint(interval);
        }

        public Void caseExecutionSpecification(ExecutionSpecification esToDelete) {
            OccurrenceSpecification osFinish;
            OccurrenceSpecification osStart = esToDelete.getStart();
            if (OccurrenceSpecificationHelper.shouldDestroyWithExecution(esToDelete, osStart, this.crossReferenceAdapter)) {
                this.dependentsToRemove.add((EObject)osStart);
            }
            if (OccurrenceSpecificationHelper.shouldDestroyWithExecution(esToDelete, osFinish = esToDelete.getFinish(), this.crossReferenceAdapter)) {
                this.dependentsToRemove.add((EObject)osFinish);
            }
            this.dependentsToRemove.addAll(UMLTemporalHelper.getTemporalElements((NamedElement)esToDelete, this.crossReferenceAdapter));
            return (Void)super.caseExecutionSpecification(esToDelete);
        }

        public Void caseMessage(Message messageToDelete) {
            this.safeAdd((Element)messageToDelete.getReceiveEvent());
            this.safeAdd((Element)messageToDelete.getSendEvent());
            this.dependentsToRemove.addAll(UMLTemporalHelper.getTemporalElements((NamedElement)messageToDelete, this.crossReferenceAdapter));
            return (Void)super.caseMessage(messageToDelete);
        }

        public Void caseLifeline(Lifeline lifelineToDelete) {
            for (InteractionFragment ift : lifelineToDelete.getCoveredBys()) {
                if (ift instanceof ExecutionSpecification) {
                    this.dependentsToRemove.add((EObject)ift);
                }
                if (ift instanceof OccurrenceSpecification) {
                    this.dependentsToRemove.add((EObject)ift);
                    if (ift instanceof MessageOccurrenceSpecification) {
                        MessageOccurrenceSpecification mos = (MessageOccurrenceSpecification)ift;
                        this.dependentsToRemove.add((EObject)mos.getMessage());
                    }
                }
                if (ift.getCovereds().size() != 1) continue;
                this.dependentsToRemove.add((EObject)ift);
            }
            PartDecomposition decomposition = lifelineToDelete.getDecomposedAs();
            if (decomposition != null && UMLService.isOnlyUsage((EObject)decomposition, (EObject)lifelineToDelete, this.crossReferenceAdapter)) {
                this.dependentsToRemove.add((EObject)decomposition);
            }
            return (Void)super.caseLifeline(lifelineToDelete);
        }

        public Void caseOccurrenceSpecification(OccurrenceSpecification osToDelete) {
            for (Optional<ExecutionSpecification> execution : List.of(OccurrenceSpecificationHelper.getExecutionFromStartOccurrence(osToDelete), OccurrenceSpecificationHelper.getExecutionFromFinishOccurrence(osToDelete))) {
                if (!execution.isPresent()) continue;
                this.dependentsToRemove.add((EObject)execution.get());
            }
            this.dependentsToRemove.addAll(UMLTemporalHelper.getTemporalElements((NamedElement)osToDelete, this.crossReferenceAdapter));
            this.dependentsToRemove.addAll((Collection<EObject>)osToDelete.getToBefores());
            this.dependentsToRemove.addAll((Collection<EObject>)osToDelete.getToAfters());
            return (Void)super.caseOccurrenceSpecification(osToDelete);
        }

        public Void caseMessageOccurrenceSpecification(MessageOccurrenceSpecification osToDelete) {
            this.safeAdd((Element)osToDelete.getMessage());
            return (Void)super.caseMessageOccurrenceSpecification(osToDelete);
        }

        public Void caseVertex(Vertex vertex) {
            this.dependentsToRemove.addAll((Collection<EObject>)vertex.getIncomings());
            this.dependentsToRemove.addAll((Collection<EObject>)vertex.getOutgoings());
            return (Void)super.caseVertex(vertex);
        }

        public Void caseAssociation(Association association) {
            EList ownedEnds = association.getOwnedEnds();
            for (Property end : association.getMemberEnds()) {
                if (ownedEnds.contains((Object)end)) {
                    this.dependentsToRemove.add((EObject)end);
                    continue;
                }
                if (end.getType() == null) continue;
                this.dependentsToRemove.add((EObject)end);
            }
            return (Void)super.caseAssociation(association);
        }

        public Void caseUseCase(UseCase useCase) {
            this.dependentsToRemove.addAll((Collection<EObject>)useCase.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getInclude()));
            this.dependentsToRemove.addAll((Collection<EObject>)useCase.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getInclude()));
            this.dependentsToRemove.addAll((Collection<EObject>)useCase.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getExtend()));
            this.dependentsToRemove.addAll((Collection<EObject>)useCase.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getExtend()));
            return (Void)super.caseUseCase(useCase);
        }

        public Set<EObject> getDependentsToRemove() {
            return this.dependentsToRemove;
        }

        public Void caseInteractionOperand(InteractionOperand interactionOperand) {
            CombinedFragment combinedFragment;
            if (interactionOperand.getOwner() instanceof CombinedFragment && (combinedFragment = (CombinedFragment)interactionOperand.getOwner()).getOperands().size() == 1 && combinedFragment.getOperands().contains((Object)interactionOperand)) {
                this.dependentsToRemove.add((EObject)combinedFragment);
            }
            return (Void)super.caseInteractionOperand(interactionOperand);
        }
    }
}

