/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.internal.viewpoint;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.sirius.editor.Activator;
import org.eclipse.papyrus.sirius.editor.internal.viewpoint.ExtendedViewPrototype;
import org.eclipse.papyrus.sirius.editor.representation.ICreateSiriusDiagramEditorCommand;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class SiriusDiagramViewPrototype
extends ViewPrototype
implements ExtendedViewPrototype<DSemanticDiagram> {
    private final ICreateSiriusDiagramEditorCommand command;

    public SiriusDiagramViewPrototype(SiriusDiagramPrototype prototype, ICreateSiriusDiagramEditorCommand command) {
        super((PapyrusRepresentationKind)prototype);
        this.command = command;
    }

    @Override
    public boolean canInstantianteOn(EObject selection) {
        DiagramDescription diagramDescription = this.getRepresentationKind().getDiagramDescription();
        return DialectManager.INSTANCE.canCreate(selection, (RepresentationDescription)diagramDescription, false);
    }

    public boolean isOwnerReassignable() {
        return true;
    }

    public boolean instantiateOn(EObject owner, String name, boolean openCreatedView) {
        return this.instantiateOn(owner, owner, name, openCreatedView) != null;
    }

    public boolean instantiateOn(EObject owner) {
        return this.instantiateOn(owner, null);
    }

    public boolean instantiateOn(EObject owner, String name) {
        if (this.command != null) {
            ServicesRegistry registry;
            try {
                registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(owner);
            }
            catch (ServiceException ex) {
                Activator.log.error("Unexpected Error", (Throwable)ex);
                return false;
            }
            try {
                ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
            }
            catch (ServiceException ex) {
                Activator.log.error("Unexpected Error", (Throwable)ex);
                return false;
            }
        }
        return this.instantiateOn(owner, name, true);
    }

    public EObject getOwnerOf(EObject view) {
        return ((DSemanticDiagram)view).eContainer();
    }

    public EObject getRootOf(EObject view) {
        return ((DSemanticDiagram)view).getTarget();
    }

    @Override
    public DSemanticDiagram instantiateOn(EObject semanticOwner, EObject graphicalOwner, String name, boolean openCreatedView) {
        return this.command.execute((ViewPrototype)this, name, semanticOwner, graphicalOwner, openCreatedView);
    }

    public Command getCommandChangeRoot(EObject view, final EObject target) {
        final DSemanticDiagram diagram = (DSemanticDiagram)view;
        final EObject previous = diagram.getTarget();
        return new AbstractCommand("Change diagram root element"){

            public void execute() {
                diagram.setTarget(target);
            }

            public void undo() {
                diagram.setTarget(previous);
            }

            public void redo() {
                diagram.setTarget(target);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public SiriusDiagramPrototype getRepresentationKind() {
        return (SiriusDiagramPrototype)this.representationKind;
    }

    public Command getCommandChangeOwner(EObject view, EObject target) {
        DSemanticDiagram diagram = (DSemanticDiagram)view;
        EObject previous = diagram.getTarget();
        return new AbstractCommand("Change diagram owner"){

            public void execute() {
            }

            public void undo() {
            }

            public void redo() {
            }

            protected boolean prepare() {
                return true;
            }
        };
    }
}

