/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.launch.debug;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.debug.core.adwp.ADWPCommand;
import org.eclipse.m2m.atl.debug.core.adwp.IntegerValue;
import org.eclipse.m2m.atl.debug.core.adwp.StringValue;
import org.eclipse.m2m.atl.debug.core.adwp.Value;
import org.eclipse.m2m.atl.engine.emfvm.ASMOperation;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.launch.ITool;
import org.eclipse.m2m.atl.engine.emfvm.launch.debug.ADWPDebuggee;
import org.eclipse.m2m.atl.engine.emfvm.launch.debug.LocalObjectReference;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;

public class NetworkDebugger
implements ITool {
    private ExecEnv execEnv;
    private AbstractStackFrame lastFrame;
    private Map<Integer, Command> commands = new HashMap<Integer, Command>();
    private boolean step;
    private boolean stepOver;
    private boolean finish;
    private boolean finished;
    private int depth;
    private Socket socket;
    private ADWPDebuggee debuggee;
    private List<String> breakpoints = new ArrayList<String>();

    public NetworkDebugger(final int port, boolean suspend) {
        new Command(this, 10, "get a property from an object"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)((Object)args.get(0));
                String propName = ((StringValue)args.get(1)).getValue();
                Value ret = o.get(propName);
                debuggee.sendMessage(101, cmd.getAck(), Arrays.asList(ret));
                return false;
            }
        };
        new Command(this, 11, "set a property to an object"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)((Object)args.get(0));
                String propName = ((StringValue)args.get(1)).getValue();
                Value value = (Value)args.get(2);
                o.set(propName, value);
                return false;
            }
        };
        new Command(this, 12, "call an operation on an object"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)((Object)args.get(0));
                String opName = ((StringValue)args.get(1)).getValue();
                int nbArgs = ((IntegerValue)args.get(2)).getValue();
                ArrayList<Value> realArgs = nbArgs == 0 ? new ArrayList<Value>() : args.subList(3, args.size());
                Value ret = o.call(opName, realArgs);
                debuggee.sendMessage(101, cmd.getAck(), Arrays.asList(ret));
                return false;
            }
        };
        new Command(this, 21, "executes a query in the current context"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                return false;
            }
        };
        new Command(this, 0, "resume program execution"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                return true;
            }
        };
        new Command(this, 1, "execute a single instruction; stepping into method calls"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                step = true;
                return true;
            }
        };
        new Command(this, 2, "execute a single instruction; stepping over method calls"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                stepOver = true;
                depth = 0;
                return true;
            }
        };
        new Command(this, 3, "run until after the execution of the current operation"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                finish = true;
                depth = 0;
                return true;
            }
        };
        new Command(this, 13, "set a breakpoint"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                List args = cmd.getArgs();
                String location = ((StringValue)args.get(0)).getValue();
                breakpoints.add(location);
                return false;
            }
        };
        new Command(this, 14, "unset a breakpoint"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                List args = cmd.getArgs();
                String location = ((StringValue)args.get(0)).getValue();
                breakpoints.remove(location);
                return false;
            }
        };
        new Command(this, 20, "disassemble current operation"){

            @Override
            public boolean doIt(ADWPCommand cmd, AbstractStackFrame frame) {
                ASMOperation op = (ASMOperation)((StackFrame)((LocalObjectReference)((Object)cmd.getArgs().get(0))).getObject()).getOperation();
                List instr = op.getInstructions();
                ArrayList<StringValue> msgArgs = new ArrayList<StringValue>();
                int k = 0;
                Iterator i = instr.iterator();
                while (i.hasNext()) {
                    String inst = i.next().toString();
                    if (inst.startsWith("load ")) {
                        inst = "load " + op.resolveVariableName(Integer.parseInt(inst.substring(5)), k);
                    } else if (inst.startsWith("store ")) {
                        inst = "store " + op.resolveVariableName(Integer.parseInt(inst.substring(6)), k);
                    }
                    msgArgs.add(StringValue.valueOf((String)inst));
                    ++k;
                }
                debuggee.sendMessage(102, cmd.getAck(), msgArgs);
                return false;
            }
        };
        if (suspend) {
            this.step = true;
        }
        Thread init = new Thread(){

            @Override
            public void run() {
                try {
                    ServerSocket server = new ServerSocket(port);
                    NetworkDebugger.this.socket = server.accept();
                    server.close();
                    NetworkDebugger.this.debuggee = new ADWPDebuggee(NetworkDebugger.this.socket.getInputStream(), NetworkDebugger.this.socket.getOutputStream());
                }
                catch (IOException ioe) {
                    ATLLogger.log((Level)Level.SEVERE, (String)ioe.getLocalizedMessage(), (Throwable)ioe);
                }
            }
        };
        if (suspend) {
            init.run();
        } else {
            init.start();
        }
    }

    public ExecEnv getExecEnv() {
        return this.execEnv;
    }

    public AbstractStackFrame getLastFrame() {
        return this.lastFrame;
    }

    public void enter(AbstractStackFrame frame) {
        if (this.stepOver || this.finish) {
            ++this.depth;
        }
    }

    public void leave(AbstractStackFrame frame) {
        if (this.depth == 0 && this.finish) {
            this.step = true;
            this.finished = true;
        }
        if ((this.stepOver || this.finish) && this.depth > 0) {
            --this.depth;
        }
    }

    public void step(AbstractStackFrame frame) {
        if (this.execEnv == null) {
            this.execEnv = frame.getExecEnv();
        }
        this.lastFrame = frame;
        if (this.stepOver && this.depth == 0) {
            this.stepOver = false;
            this.step = true;
        }
        if (this.step) {
            if (this.finished) {
                this.dialog(frame, "after finishing");
            } else {
                this.dialog(frame, "for stepping");
            }
        } else {
            int location = frame.getLocation();
            ASMOperation operation = (ASMOperation)frame.getOperation();
            String sourceLocation = operation.resolveLineNumber(location);
            if (this.breakpoints.contains(sourceLocation)) {
                this.dialog(frame, "for breakpoint");
            }
        }
    }

    public void terminated() {
        try {
            this.debuggee.sendMessage(103, 0, Collections.emptyList());
            this.socket.close();
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void error(AbstractStackFrame stackFrame, String msg, Exception e) {
        this.dialog(stackFrame, "ERROR: " + msg);
        if (e != null) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        } else if (msg != null) {
            ATLLogger.severe((String)("Message: " + msg));
        }
    }

    private void dialog(AbstractStackFrame stFrame, String msg) {
        boolean debug = false;
        AbstractStackFrame frame = stFrame;
        int location = frame.getLocation();
        ASMOperation operation = (ASMOperation)frame.getOperation();
        String opName = operation.getName();
        String sourceLocation = operation.resolveLineNumber(location);
        this.debuggee.sendMessage(100, 0, Arrays.asList(StringValue.valueOf((String)msg), LocalObjectReference.valueOf(frame, this), StringValue.valueOf((String)opName), IntegerValue.valueOf((int)location), StringValue.valueOf((String)sourceLocation)));
        boolean resume = false;
        do {
            ADWPCommand acmd = this.debuggee.readCommand();
            resume = false;
            this.step = false;
            this.stepOver = false;
            this.finish = false;
            this.finished = false;
            Command cmd = this.commands.get(acmd.getCode());
            if (cmd == null) {
                ATLLogger.warning((String)("unsupported command: " + acmd.getCode()));
                continue;
            }
            resume = cmd.doIt(acmd, frame);
        } while (!resume);
    }

    protected abstract class Command {
        private String description;

        public Command(int cmd, String description) {
            this.description = description;
            NetworkDebugger.this.commands.put(cmd, this);
        }

        public abstract boolean doIt(ADWPCommand var1, AbstractStackFrame var2);

        public String getDescription() {
            return this.description;
        }
    }
}

