/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class AnnotatedElementAnnotationElementAdapter<T>
implements AnnotationElementAdapter<T> {
    private final AnnotatedElement annotatedElement;
    private final DeclarationAnnotationElementAdapter<T> daea;

    public AnnotatedElementAnnotationElementAdapter(AnnotatedElement annotatedElement, DeclarationAnnotationElementAdapter<T> daea) {
        this.annotatedElement = annotatedElement;
        this.daea = daea;
    }

    @Override
    public T getValue() {
        return this.daea.getValue(this.annotatedElement.getModifiedDeclaration());
    }

    @Override
    public T getValue(CompilationUnit astRoot) {
        return this.daea.getValue(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    @Override
    public T getValue(Annotation annotation) {
        return this.daea.getValue(annotation);
    }

    @Override
    public void setValue(T value) {
        this.edit(this.buildSetValueEditor(value));
    }

    @Override
    public Expression getExpression(CompilationUnit astRoot) {
        return this.daea.getExpression(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    @Override
    public Expression getExpression(Annotation annotation) {
        return this.daea.getExpression(annotation);
    }

    @Override
    public ASTNode getAstNode(CompilationUnit astRoot) {
        return this.daea.getAstNode(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.daea);
    }

    protected void edit(AnnotatedElement.Editor editor) {
        this.annotatedElement.edit(editor);
    }

    protected AnnotatedElement.Editor buildSetValueEditor(T value) {
        return new SetValueEditor<T>(value, this.daea);
    }

    protected static class SetValueEditor<T>
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationElementAdapter<T> daea;
        private final T value;

        SetValueEditor(T value, DeclarationAnnotationElementAdapter<T> daea) {
            this.value = value;
            this.daea = daea;
        }

        @Override
        public void edit(ModifiedDeclaration declaration) {
            this.daea.setValue(this.value, declaration);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

