/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql;

import org.eclipse.xtext.xbase.XExpression;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Function Evaluation Value</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue#getExpression <em>Expression</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue#isUnwind <em>Unwind</em>}</li>
 * </ul>
 *
 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getFunctionEvaluationValue()
 * @model
 * @generated
 */
public interface FunctionEvaluationValue extends ComputationValue
{
	/**
	 * Returns the value of the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Expression</em>' containment reference.
	 * @see #setExpression(XExpression)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getFunctionEvaluationValue_Expression()
	 * @model containment="true"
	 * @generated
	 */
	XExpression getExpression();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue#getExpression <em>Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Expression</em>' containment reference.
	 * @see #getExpression()
	 * @generated
	 */
	void setExpression(XExpression value);

	/**
	 * Returns the value of the '<em><b>Unwind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * @since 2.7
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Unwind</em>' attribute.
	 * @see #setUnwind(boolean)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getFunctionEvaluationValue_Unwind()
	 * @model
	 * @generated
	 */
	boolean isUnwind();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue#isUnwind <em>Unwind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unwind</em>' attribute.
	 * @see #isUnwind()
	 * @since 2.7
	 * @generated
	 */
	void setUnwind(boolean value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	String toString();

} // FunctionEvaluationValue
