/*******************************************************************************
 * Copyright (c) 2012, 2014 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.impl;

import static org.eclipse.emf.compare.internal.utils.ComparisonUtil.isFeatureMapContainment;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.ITypedElement;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.ManyStructuralFeatureAccessorImpl;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer.MergeViewerSide;
import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * A specific {@link org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.factory.IAccessorFactory} for
 * multi-valued structural feature objects.
 * 
 * @author <a href="mailto:mikael.barbero@obeo.fr">Mikael Barbero</a>
 * @since 4.0
 */
public class ManyStructuralFeatureAccessorFactory extends AbstractAccessorFactory {

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.factory.IAccessorFactory#isFactoryFor(java.lang.Object)
	 */
	public boolean isFactoryFor(Object target) {
		EStructuralFeature eStructuralFeature = null;
		if (target instanceof ReferenceChange) {
			eStructuralFeature = ((ReferenceChange)target).getReference();
		} else if (target instanceof AttributeChange) {
			eStructuralFeature = ((AttributeChange)target).getAttribute();
		} else if (target instanceof FeatureMapChange) {
			FeatureMapChange featureMapChange = (FeatureMapChange)target;
			DifferenceKind kind = featureMapChange.getKind();
			if (kind != DifferenceKind.CHANGE && kind != DifferenceKind.MOVE
					|| (kind == DifferenceKind.MOVE && !isFeatureMapContainment(featureMapChange))) {
				eStructuralFeature = featureMapChange.getAttribute();
			}
		} else if (target instanceof Diff) {
			Diff primeRefining = ((Diff)target).getPrimeRefining();
			if (primeRefining instanceof ReferenceChange) {
				eStructuralFeature = ((ReferenceChange)primeRefining).getReference();
			}
		}

		if (eStructuralFeature != null) {
			return eStructuralFeature.isMany();
		}

		return false;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.factory.IAccessorFactory#createLeft(org.eclipse.emf.common.notify.AdapterFactory,
	 *      java.lang.Object)
	 */
	public ITypedElement createLeft(AdapterFactory adapterFactory, Object target) {
		return new ManyStructuralFeatureAccessorImpl(adapterFactory, (Diff)target, MergeViewerSide.LEFT);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.factory.IAccessorFactory#createRight(org.eclipse.emf.common.notify.AdapterFactory,
	 *      java.lang.Object)
	 */
	public ITypedElement createRight(AdapterFactory adapterFactory, Object target) {
		return new ManyStructuralFeatureAccessorImpl(adapterFactory, (Diff)target, MergeViewerSide.RIGHT);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.factory.IAccessorFactory#createAncestor(org.eclipse.emf.common.notify.AdapterFactory,
	 *      java.lang.Object)
	 */
	public ITypedElement createAncestor(AdapterFactory adapterFactory, Object target) {
		return new ManyStructuralFeatureAccessorImpl(adapterFactory, (Diff)target, MergeViewerSide.ANCESTOR);
	}

}
