/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

public class SetListenerHelperEx<E> {
    private List<InvalidationListener> invalidationListeners = null;
    private boolean lockInvalidationListeners;
    private boolean lockSetChangeListeners;
    private List<SetChangeListener<? super E>> setChangeListeners = null;
    private ObservableSet<E> source;

    public SetListenerHelperEx(ObservableSet<E> source) {
        this.source = source;
    }

    public void addListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            this.invalidationListeners = new ArrayList<InvalidationListener>();
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        this.invalidationListeners.add(listener);
    }

    public void addListener(SetChangeListener<? super E> listener) {
        if (this.setChangeListeners == null) {
            this.setChangeListeners = new ArrayList<SetChangeListener<? super E>>();
        }
        if (this.lockSetChangeListeners) {
            this.setChangeListeners = new ArrayList<SetChangeListener<SetChangeListener<? super E>>>(this.setChangeListeners);
        }
        this.setChangeListeners.add(listener);
    }

    public void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
        this.notifyInvalidationListeners();
        if (change != null) {
            this.notifySetChangeListeners(change);
        }
    }

    protected ObservableSet<E> getSource() {
        return this.source;
    }

    protected void notifyInvalidationListeners() {
        if (this.invalidationListeners != null) {
            try {
                this.lockInvalidationListeners = true;
                for (InvalidationListener l : this.invalidationListeners) {
                    try {
                        l.invalidated(this.source);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockInvalidationListeners = false;
            }
        }
    }

    protected void notifySetChangeListeners(SetChangeListener.Change<? extends E> change) {
        if (this.setChangeListeners != null) {
            try {
                this.lockSetChangeListeners = true;
                for (SetChangeListener<? super E> setChangeListener : this.setChangeListeners) {
                    try {
                        setChangeListener.onChanged(change);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockSetChangeListeners = false;
            }
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            return;
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        Iterator<InvalidationListener> iterator = this.invalidationListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.invalidationListeners.isEmpty()) {
            this.invalidationListeners = null;
        }
    }

    public void removeListener(SetChangeListener<? super E> listener) {
        if (this.setChangeListeners == null) {
            return;
        }
        if (this.lockSetChangeListeners) {
            this.setChangeListeners = new ArrayList<SetChangeListener<SetChangeListener<? super E>>>(this.setChangeListeners);
        }
        Iterator<SetChangeListener<E>> iterator = this.setChangeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.setChangeListeners.isEmpty()) {
            this.setChangeListeners = null;
        }
    }

    public static class AtomicChange<E>
    extends SetChangeListener.Change<E> {
        private E removedElement;
        private E addedElement;

        public AtomicChange(ObservableSet<E> source, E removedElement, E addedElement) {
            super(source);
            this.removedElement = removedElement;
            this.addedElement = addedElement;
        }

        public AtomicChange(ObservableSet<E> source, SetChangeListener.Change<? extends E> change) {
            super(source);
            this.addedElement = change.getElementAdded();
            this.removedElement = change.getElementRemoved();
        }

        public E getElementAdded() {
            return this.addedElement;
        }

        public E getElementRemoved() {
            return this.removedElement;
        }

        public String toString() {
            if (this.wasAdded()) {
                return "Added " + this.addedElement + ".";
            }
            return "Removed " + this.removedElement + ".";
        }

        public boolean wasAdded() {
            return this.addedElement != null;
        }

        public boolean wasRemoved() {
            return this.removedElement != null;
        }
    }
}

