/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.actions;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.ui.widgets.TimeSlider;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ui.widgets.ImageButton;
import org.eclipse.net4j.util.ui.widgets.StackComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

public class CDOCheckoutDashboard
extends Composite
implements ISelectionListener {
    private final ISelectionService selectionService;
    private final Label iconLabel;
    private final Label titleLabel;
    private final ImageButton closeButton;
    private final StackComposite stackComposite;
    private final InfoPage infoPage;
    private final ViewPage viewPage;
    private final TransactionPage transactionPage;
    private DashboardPage currentPage;
    private CDOView currentView;

    public CDOCheckoutDashboard(Composite parent, ISelectionService selectionService) {
        super(parent, 0);
        this.selectionService = selectionService;
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(16384, 1024, false, false);
        gridData.heightHint = 21;
        this.iconLabel = new Label((Composite)this, 0);
        this.iconLabel.setLayoutData((Object)gridData);
        this.titleLabel = new Label((Composite)this, 0);
        this.titleLabel.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.closeButton = new ImageButton(this, OM.getImage("icons/close_hover.gif"), OM.getImage("icons/close.gif")){

            protected void widgetSelected() {
                OM.PREF_DASHBOARD_HEIGHT.setValue((Object)(-((Integer)OM.PREF_DASHBOARD_HEIGHT.getValue()).intValue()));
                CDOCheckoutDashboard.this.dispose();
            }
        };
        this.closeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.closeButton.setToolTipText("Close");
        Label space = new Label((Composite)this, 0);
        space.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.stackComposite = new StackComposite((Composite)this, 0);
        this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.infoPage = new InfoPage(this);
        this.viewPage = new ViewPage(this);
        this.transactionPage = new TransactionPage(this);
        this.stackComposite.setTopControl((Control)this.infoPage);
        this.setSelection(selectionService.getSelection());
        selectionService.addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.selectionService.removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setSelection(selection);
    }

    public void setSelection(ISelection selection) {
        DashboardPage oldPage = this.currentPage;
        CDOView view = this.getView(selection);
        if (view != this.currentView) {
            this.currentView = view;
            if (this.currentView != null) {
                if (this.isReadOnly(this.currentView)) {
                    this.transactionPage.setView(null);
                    this.currentPage = this.viewPage;
                } else {
                    this.viewPage.setView(null);
                    this.currentPage = this.transactionPage;
                }
                this.currentPage.setView(this.currentView);
            } else {
                this.viewPage.setView(null);
                this.transactionPage.setView(null);
                this.currentPage = this.infoPage;
            }
        }
        if (this.currentPage != oldPage) {
            this.updateTitleArea(this.currentPage);
            this.stackComposite.setTopControl((Control)this.currentPage);
        }
    }

    private boolean isReadOnly(CDOView view) {
        return view.isReadOnly();
    }

    private CDOView getView(ISelection selection) {
        IStructuredSelection ssel;
        if (selection instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty()) {
            CDOView firstView = null;
            for (Object element : ssel) {
                CDOView view;
                CDOView view2;
                CDOObject cdoObject;
                EObject eObject;
                CDOView view3;
                CDOCheckout checkout = (CDOCheckout)AdapterUtil.adapt(element, CDOCheckout.class);
                if (checkout != null && (view3 = checkout.getView()) != null) {
                    element = view3;
                }
                if ((eObject = (EObject)AdapterUtil.adapt(element, EObject.class)) != null && (cdoObject = CDOUtil.getCDOObject((EObject)eObject, (boolean)false)) != null && (view2 = cdoObject.cdoView()) != null) {
                    element = view2;
                }
                if ((view = (CDOView)AdapterUtil.adapt(element, CDOView.class)) == null) continue;
                if (firstView == null) {
                    firstView = view;
                    continue;
                }
                if (firstView == view) continue;
                return null;
            }
            return firstView;
        }
        return null;
    }

    private StackComposite getStackComposite() {
        return this.stackComposite;
    }

    private void updateTitleArea(DashboardPage page) {
        if (page == this.currentPage) {
            this.iconLabel.setImage(page.getIcon());
            this.titleLabel.setText(page.getTitle());
        }
    }

    public static abstract class DashboardPage
    extends Composite {
        private final CDOCheckoutDashboard dashboard;
        private Image icon;
        private String title;
        private CDOView view;

        public DashboardPage(CDOCheckoutDashboard dashboard) {
            super((Composite)dashboard.getStackComposite(), 0);
            this.dashboard = dashboard;
        }

        public final Image getIcon() {
            return this.icon;
        }

        public final void setIcon(Image icon) {
            if (this.icon != icon) {
                this.icon = icon;
                this.dashboard.updateTitleArea(this);
            }
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            if (this.title != title) {
                this.title = title;
                this.dashboard.updateTitleArea(this);
            }
        }

        public final CDOView getView() {
            return this.view;
        }

        public final void setView(CDOView view) {
            if (view != this.view) {
                CDOView oldView = this.view;
                this.view = view;
                this.viewChanged(oldView, view);
            }
        }

        protected void viewChanged(CDOView oldView, CDOView newView) {
        }
    }

    private static class InfoPage
    extends DashboardPage {
        public InfoPage(CDOCheckoutDashboard dashboard) {
            super(dashboard);
            this.setIcon(org.eclipse.net4j.ui.shared.SharedIcons.getImage((String)"obj16/information"));
            this.setTitle("CDO Dashboard");
            this.setLayout((Layout)new FillLayout());
            Label label = new Label((Composite)this, 64);
            label.setForeground(this.getDisplay().getSystemColor(10));
            label.setText("This dashboard is context-sensitive. Select checkouts or models to show view and transaction controls.");
        }
    }

    private static class TransactionPage
    extends DashboardPage {
        private final Text commentText;
        private final Button promptButton;
        private final Button locksButton;

        public TransactionPage(CDOCheckoutDashboard dashboard) {
            super(dashboard);
            this.setIcon(SharedIcons.getImage((String)"obj16/cdo_editor.gif"));
            this.setTitle("Transaction commit comment:");
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            this.setLayout((Layout)gridLayout);
            this.commentText = new Text((Composite)this, 2114);
            this.commentText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.promptButton = new Button((Composite)this, 32);
            this.promptButton.setText("Prompt");
            this.promptButton.setToolTipText("Prompt on commit");
            this.locksButton = new Button((Composite)this, 32);
            this.locksButton.setText("Release locks");
            this.locksButton.setToolTipText("Release locks on commit");
        }
    }

    private static class ViewPage
    extends DashboardPage {
        private final TimeSlider timeSlider;

        public ViewPage(CDOCheckoutDashboard dashboard) {
            super(dashboard);
            this.setIcon(SharedIcons.getImage((String)"obj16/cdo_editor_historical.gif"));
            this.setTitle("View time:");
            this.setLayout((Layout)new FillLayout());
            this.timeSlider = new TimeSlider((Composite)this, 256);
        }

        @Override
        protected void viewChanged(CDOView oldView, CDOView newView) {
            super.viewChanged(oldView, newView);
            this.timeSlider.connect(newView, null);
        }
    }
}

