/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LazyFileHandle;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterEnvironmentVariablesBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterLibraryBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.IAddInterpreterDialogRequestor;
import org.eclipse.dltk.internal.debug.ui.interpreters.IScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.dialogs.TimeTriggeredProgressMonitorDialog;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.utils.PlatformFileUtils;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AddScriptInterpreterDialog
extends StatusDialog
implements IScriptInterpreterDialog {
    protected final IAddInterpreterDialogRequestor fRequestor;
    private IInterpreterInstallType[] fInterpreterTypes;
    protected IInterpreterInstallType fSelectedInterpreterType;
    private ComboDialogField fInterpreterTypeCombo;
    protected final IInterpreterInstall fEditedInterpreter;
    protected AbstractInterpreterLibraryBlock fLibraryBlock;
    protected AbstractInterpreterEnvironmentVariablesBlock fEnvironmentVariablesBlock;
    private StringButtonDialogField fInterpreterPath;
    private StringDialogField fInterpreterName;
    private StringDialogField fInterpreterArgs;
    private IStatus[] fStati;
    private int fPrevIndex = -1;
    private IEnvironment environment;
    private IInterpreterInstall lastInstall = null;

    protected boolean useInterpreterArgs() {
        return true;
    }

    public AddScriptInterpreterDialog(IAddInterpreterDialogRequestor requestor, Shell shell, IInterpreterInstallType[] interpreterInstallTypes, IInterpreterInstall editedInterpreter) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRequestor = requestor;
        this.fStati = new IStatus[5];
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
        this.fInterpreterTypes = interpreterInstallTypes;
        this.fSelectedInterpreterType = editedInterpreter != null ? editedInterpreter.getInterpreterInstallType() : interpreterInstallTypes[0];
        this.fEditedInterpreter = editedInterpreter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createDialogFields() {
        this.fInterpreterTypeCombo = new ComboDialogField(8);
        this.fInterpreterTypeCombo.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentType);
        this.fInterpreterTypeCombo.setItems(this.getInterpreterTypeNames());
        this.fInterpreterName = new StringDialogField();
        this.fInterpreterName.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentName);
        this.fInterpreterPath = new StringButtonDialogField(field -> this.browseForInstallation());
        this.fInterpreterPath.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterExecutableName);
        this.fInterpreterPath.setButtonLabel(InterpretersMessages.addInterpreterDialog_browse1);
        if (this.useInterpreterArgs()) {
            this.fInterpreterArgs = new StringDialogField();
            this.fInterpreterArgs.setLabelText(InterpretersMessages.AddInterpreterDialog_iArgs);
        }
    }

    protected void createFieldListeners() {
        this.fInterpreterTypeCombo.setDialogFieldListener(field -> this.updateInterpreterType());
        this.fInterpreterName.setDialogFieldListener(field -> {
            this.setInterpreterNameStatus(this.validateInterpreterName());
            this.updateStatusLine();
        });
        this.fInterpreterPath.setDialogFieldListener(field -> {
            this.updateValidateInterpreterLocation();
            this.fLibraryBlock.restoreDefaultLibraries();
            this.updateStatusLine();
        });
    }

    protected String getInterpreterName() {
        return this.fInterpreterName.getText();
    }

    protected void setInterpreterName(String value) {
        this.fInterpreterName.setText(value);
    }

    protected abstract AbstractInterpreterLibraryBlock createLibraryBlock(AddScriptInterpreterDialog var1);

    protected AbstractInterpreterEnvironmentVariablesBlock createEnvironmentVariablesBlock() {
        return this.createEnvironmentVariablesBlock(this);
    }

    @Deprecated
    protected AbstractInterpreterEnvironmentVariablesBlock createEnvironmentVariablesBlock(AddScriptInterpreterDialog dialog) {
        return null;
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        int numColumns = 3;
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.createSimpleFields(parent, 3);
        Composite blockComposite = new Composite(parent, 0);
        GridData blockCompositeLayoutData = new GridData(4, 4, true, true);
        blockCompositeLayoutData.horizontalSpan = 3;
        blockComposite.setLayoutData((Object)blockCompositeLayoutData);
        GridLayout blockCompositeLayout = new GridLayout(2, false);
        blockCompositeLayout.marginHeight = 0;
        blockCompositeLayout.marginWidth = 0;
        blockComposite.setLayout((Layout)blockCompositeLayout);
        this.createDialogBlocks(blockComposite, 2);
        this.initializeFields(this.fEditedInterpreter);
        this.createFieldListeners();
        AddScriptInterpreterDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void createSimpleFields(Composite parent, int numColumns) {
        this.createDialogFields();
        this.fInterpreterTypeCombo.doFillIntoGrid(parent, numColumns);
        ((GridData)this.fInterpreterTypeCombo.getComboControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        this.fInterpreterPath.doFillIntoGrid(parent, numColumns);
        GridData interpreterPathGridData = (GridData)this.fInterpreterPath.getTextControl(null).getLayoutData();
        interpreterPathGridData.grabExcessHorizontalSpace = true;
        interpreterPathGridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.fInterpreterName.doFillIntoGrid(parent, numColumns);
        if (this.useInterpreterArgs()) {
            this.fInterpreterArgs.doFillIntoGrid(parent, numColumns);
            ((GridData)this.fInterpreterArgs.getTextControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        }
    }

    protected void createDialogBlocks(Composite parent, int numColumns) {
        Composite libraryBlockParent = this.createLibraryBlockParent(parent, numColumns);
        this.fLibraryBlock = this.createLibraryBlock(this);
        this.fLibraryBlock.createControlsIn(libraryBlockParent);
        this.fEnvironmentVariablesBlock = this.createEnvironmentVariablesBlock();
        if (this.fEnvironmentVariablesBlock != null) {
            Composite envParent = this.createEnvironmentVariablesBlockParent(parent, numColumns);
            this.fEnvironmentVariablesBlock.createControlsIn(envParent);
        }
    }

    protected Composite createEnvironmentVariablesBlockParent(Composite parent, int numColumns) {
        Label l = new Label(parent, 0);
        l.setText(InterpretersMessages.AddScriptInterpreterDialog_interpreterEnvironmentVariables);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        l.setLayoutData((Object)gd);
        return parent;
    }

    protected Composite createLibraryBlockParent(Composite parent, int numColumns) {
        Label l = new Label(parent, 0);
        l.setText(InterpretersMessages.AddInterpreterDialog_Interpreter_system_libraries__1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        l.setLayoutData((Object)gd);
        return parent;
    }

    private void updateInterpreterType() {
        int selIndex = this.fInterpreterTypeCombo.getSelectionIndex();
        if (selIndex == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.fInterpreterTypes.length) {
            this.fSelectedInterpreterType = this.fInterpreterTypes[selIndex];
        }
        this.updateValidateInterpreterLocation();
        this.fLibraryBlock.initializeFrom(this.fEditedInterpreter, this.fSelectedInterpreterType);
        if (this.fEnvironmentVariablesBlock != null) {
            this.fEnvironmentVariablesBlock.initializeFrom(this.fEditedInterpreter, this.fSelectedInterpreterType);
        }
        this.updateStatusLine();
    }

    protected void updateValidateInterpreterLocation() {
        this.setInterpreterLocationStatus(this.validateInterpreterLocation());
    }

    public void create() {
        super.create();
        this.fInterpreterPath.setFocus();
        this.selectInterpreterType();
    }

    private String[] getInterpreterTypeNames() {
        String[] names = new String[this.fInterpreterTypes.length];
        int i = 0;
        while (i < this.fInterpreterTypes.length) {
            names[i] = this.fInterpreterTypes[i].getName();
            ++i;
        }
        return names;
    }

    private void selectInterpreterType() {
        int i = 0;
        while (i < this.fInterpreterTypes.length) {
            if (this.fSelectedInterpreterType.getId().equals(this.fInterpreterTypes[i].getId())) {
                this.fInterpreterTypeCombo.selectItem(i);
                return;
            }
            ++i;
        }
    }

    protected void initializeFields(IInterpreterInstall install) {
        this.fInterpreterTypeCombo.setItems(this.getInterpreterTypeNames());
        if (install == null) {
            this.fInterpreterName.setText("");
            this.fInterpreterPath.setText("");
            this.fLibraryBlock.initializeFrom(null, this.fSelectedInterpreterType);
            if (this.fEnvironmentVariablesBlock != null) {
                this.fEnvironmentVariablesBlock.initializeFrom(null, this.fSelectedInterpreterType);
            }
            if (this.useInterpreterArgs()) {
                this.fInterpreterArgs.setText("");
            }
        } else {
            this.fInterpreterTypeCombo.setEnabled(false);
            this.fInterpreterName.setText(install.getName());
            this.fInterpreterPath.setText(install.getRawInstallLocation().toOSString());
            if (this.fEnvironmentVariablesBlock != null) {
                this.fEnvironmentVariablesBlock.initializeFrom(install, this.fSelectedInterpreterType);
            }
            this.fLibraryBlock.initializeFrom(install, this.fSelectedInterpreterType);
            String InterpreterArgs = install.getInterpreterArgs();
            if (InterpreterArgs != null) {
                this.fInterpreterArgs.setText(InterpreterArgs);
            }
        }
        this.setInterpreterNameStatus(this.validateInterpreterName());
        this.updateStatusLine();
    }

    protected IInterpreterInstallType getInterpreterType() {
        return this.fSelectedInterpreterType;
    }

    protected IStatus validateInterpreterLocation() {
        Object s;
        IFileHandle file;
        Path location = new Path(this.fInterpreterPath.getText());
        if (location.isEmpty()) {
            file = null;
            s = new StatusInfo(1, InterpretersMessages.addInterpreterDialog_enterLocation);
        } else {
            file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)this.getEnvironment(), (IPath)location);
            s = !file.exists() ? new StatusInfo(4, InterpretersMessages.addInterpreterDialog_locationNotExists) : this.validateInterpreter(file);
        }
        if (s != null && s.isOK()) {
            String pName;
            this.fLibraryBlock.setHomeDirectory(file);
            String name = this.fInterpreterName.getText();
            if ((name == null || name.trim().length() == 0) && file != null && (pName = this.generateInterpreterName(file)) != null) {
                this.fInterpreterName.setText(pName);
            }
        } else {
            this.fLibraryBlock.setHomeDirectory(null);
        }
        return s;
    }

    private IStatus validateInterpreter(IFileHandle file) {
        IStatus[] temp = new IStatus[1];
        TimeTriggeredProgressMonitorDialog progressDialog = new TimeTriggeredProgressMonitorDialog(this.getShell(), 200);
        try {
            progressDialog.run(false, false, monitor -> {
                EnvironmentVariable[] environmentVariables = null;
                if (this.fEnvironmentVariablesBlock != null) {
                    environmentVariables = this.fEnvironmentVariablesBlock.getEnvironmentVariables();
                }
                LibraryLocation[] locations = this.fLibraryBlock.getLibraryLocations();
                iStatusArray[0] = this.getInterpreterType().validateInstallLocation(file, environmentVariables, locations, monitor);
            });
        }
        catch (InvocationTargetException e) {
            DLTKCore.error((Throwable)e);
        }
        catch (InterruptedException e) {
            DLTKCore.error((Throwable)e);
        }
        return temp[0];
    }

    protected String generateInterpreterName(IFileHandle file) {
        Path path = new Path(file.getCanonicalPath());
        String genName = path.segmentCount() > 0 ? path.lastSegment() : null;
        String pName = genName;
        if (pName != null) {
            int index = 0;
            while (!this.validateGeneratedName(pName) || this.fRequestor.isDuplicateName(pName, this.fEditedInterpreter)) {
                pName = String.valueOf(genName) + "(" + String.valueOf(++index) + ")";
            }
        }
        return pName;
    }

    protected boolean validateGeneratedName(String name) {
        int i = 0;
        while (i < this.fInterpreterTypes.length) {
            IInterpreterInstallType type = this.fInterpreterTypes[i];
            IInterpreterInstall inst = type.findInterpreterInstallByName(name);
            if (inst != null) {
                return inst == this.fEditedInterpreter;
            }
            ++i;
        }
        return true;
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(IEnvironment environment) {
        this.environment = environment;
    }

    private IStatus validateInterpreterName() {
        StatusInfo status = new StatusInfo();
        String name = this.fInterpreterName.getText();
        if (name == null || name.trim().length() == 0) {
            status.setInfo(InterpretersMessages.addInterpreterDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name, this.fEditedInterpreter) && (this.fEditedInterpreter == null || !name.equals(this.fEditedInterpreter.getName()))) {
            status.setError(InterpretersMessages.addInterpreterDialog_duplicateName);
        }
        return status;
    }

    public void updateStatusLine() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.updateStatus(max);
    }

    private void browseForInstallation() {
        String newPath;
        IEnvironment environment = this.getEnvironment();
        IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
        if (environmentUI != null && (newPath = environmentUI.selectFile(this.getShell(), 1, this.fInterpreterPath.getText().trim())) != null) {
            this.fInterpreterPath.setText(newPath);
        }
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    private void doOkPressed() {
        if (this.fEditedInterpreter == null) {
            InterpreterStandin install = new InterpreterStandin(this.fSelectedInterpreterType, this.createUniqueId(this.fSelectedInterpreterType));
            this.setFieldValuesToInterpreter((IInterpreterInstall)install);
            this.fRequestor.interpreterAdded((IInterpreterInstall)install);
            this.lastInstall = install;
        } else {
            this.setFieldValuesToInterpreter(this.fEditedInterpreter);
            this.lastInstall = this.fEditedInterpreter;
        }
    }

    private String createUniqueId(IInterpreterInstallType InterpreterType) {
        String id = null;
        while (InterpreterType.findInterpreterInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToInterpreter(IInterpreterInstall install) {
        IEnvironment selectedEnv = this.getEnvironment();
        install.setInstallLocation((IFileHandle)new LazyFileHandle(selectedEnv.getId(), (IPath)new Path(this.fInterpreterPath.getText())));
        install.setName(this.fInterpreterName.getText());
        if (this.useInterpreterArgs()) {
            String argString = this.fInterpreterArgs.getText().trim();
            if (argString != null && argString.length() > 0) {
                install.setInterpreterArgs(argString);
            } else {
                install.setInterpreterArgs(null);
            }
        } else {
            install.setInterpreterArgs(null);
        }
        this.fLibraryBlock.performApply(install);
        if (this.fEnvironmentVariablesBlock != null) {
            this.fEnvironmentVariablesBlock.performApply(install);
        }
    }

    private void setInterpreterNameStatus(IStatus status) {
        this.fStati[1] = status;
    }

    private void setInterpreterLocationStatus(IStatus status) {
        this.fStati[0] = status;
    }

    protected IStatus getInterpreterLocationStatus() {
        return this.fStati[0];
    }

    protected IStatus getSystemLibraryStatus() {
        return this.fStati[3];
    }

    public void setSystemLibraryStatus(IStatus status) {
        this.fStati[3] = status;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    public void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
        ((GridData)button.getLayoutData()).grabExcessHorizontalSpace = true;
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_INTERPRETER_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DLTKDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    public EnvironmentVariable[] getEnvironmentVariables() {
        AbstractInterpreterEnvironmentVariablesBlock environmentVariablesBlock = this.fEnvironmentVariablesBlock;
        if (environmentVariablesBlock != null) {
            return environmentVariablesBlock.fEnvironmentVariablesContentProvider.getVariables();
        }
        if (this.fEditedInterpreter != null) {
            return this.fEditedInterpreter.getEnvironmentVariables();
        }
        return null;
    }

    public void updateLibraries(EnvironmentVariable[] newVars, EnvironmentVariable[] oldVars) {
        this.fLibraryBlock.reDiscover(newVars, oldVars);
    }

    protected boolean isRediscoverSupported() {
        return false;
    }

    protected IInterpreterInstall getLastInterpreterInstall() {
        return this.lastInstall;
    }

    public boolean execute() {
        return this.open() == 0;
    }

    protected String getInterpreterPath() {
        return this.fInterpreterPath.getText();
    }
}

